/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jbpm.workbench.common.client.filters.active.ClearAllActiveFiltersEvent;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogBasicFiltersPresenter;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogFilterSettingsManager;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogHumanTaskView;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogSummaryDataSetMapper;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;

@Dependent
public class ProcessInstanceLogPresenter
extends AbstractMultiGridPresenter<ProcessInstanceLogSummary, ProcessInstanceLogView> {
    public static final int PAGE_SIZE = 10;
    private Constants constants = Constants.INSTANCE;
    @Inject
    private ProcessInstanceLogView view;
    private Caller<TaskService> taskService;
    private String serverTemplateId;
    private String containerId;
    int currentPage = 0;
    List<ProcessInstanceLogSummary> visibleLogs = new ArrayList<ProcessInstanceLogSummary>();
    protected DataSetQueryHelper logsDataSetQueryHelper;
    protected ProcessInstanceLogFilterSettingsManager filterSettingsManager;
    private ProcessInstanceLogBasicFiltersPresenter processInstanceLogBasicFiltersPresenter;

    public int getPageSize() {
        return 10;
    }

    public void setCurrentPage(int i) {
        this.currentPage = i;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    @Inject
    public void setDataSetQueryHelper(DataSetQueryHelper dataSetQueryHelper) {
        this.logsDataSetQueryHelper = dataSetQueryHelper;
    }

    @Inject
    public void setProcessInstanceLogBasicFiltersPresenter(ProcessInstanceLogBasicFiltersPresenter pILBasicFiltersPresenter) {
        this.processInstanceLogBasicFiltersPresenter = pILBasicFiltersPresenter;
    }

    @Inject
    public void setFilterSettingsManager(ProcessInstanceLogFilterSettingsManager filterSettingsManager) {
        this.filterSettingsManager = filterSettingsManager;
    }

    @PostConstruct
    public void init() {
        this.view.init((Object)this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public HTMLElement getBasicFiltersView() {
        return this.processInstanceLogBasicFiltersPresenter.getView().getElement();
    }

    public void setServerTemplateId(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
    }

    public DataSetQueryHelper getDataSetQueryHelper() {
        return this.logsDataSetQueryHelper;
    }

    public void loadProcessInstanceLogs() {
        try {
            final FilterSettings currentTableSettings = this.logsDataSetQueryHelper.getCurrentTableSettings();
            currentTableSettings.setServerTemplateId(this.serverTemplateId);
            currentTableSettings.setTablePageSize(this.getPageSize());
            this.logsDataSetQueryHelper.setCurrentTableSettings(currentTableSettings);
            this.logsDataSetQueryHelper.setDataSetHandler(currentTableSettings);
            this.logsDataSetQueryHelper.lookupDataSet(Integer.valueOf(this.currentPage * this.getPageSize()), new DataSetReadyCallback(){

                public void callback(DataSet dataSet) {
                    if (dataSet != null && ProcessInstanceLogPresenter.this.logsDataSetQueryHelper.getCurrentTableSettings().getKey().equals(currentTableSettings.getKey())) {
                        ArrayList<ProcessInstanceLogSummary> logs = new ArrayList<ProcessInstanceLogSummary>();
                        for (int i = 0; i < dataSet.getRowCount(); ++i) {
                            logs.add(new ProcessInstanceLogSummaryDataSetMapper().apply(dataSet, i));
                        }
                        if (ProcessInstanceLogPresenter.this.currentPage == 0) {
                            ProcessInstanceLogPresenter.this.visibleLogs = new ArrayList<ProcessInstanceLogSummary>();
                        }
                        ProcessInstanceLogPresenter.this.visibleLogs.addAll(logs);
                        ProcessInstanceLogPresenter.this.view.hideLoadButton(logs.size() < 10);
                        ProcessInstanceLogPresenter.this.view.setLogsList(ProcessInstanceLogPresenter.this.visibleLogs.stream().collect(Collectors.toList()));
                    }
                }

                public void notFound() {
                    ProcessInstanceLogPresenter.this.errorPopup.showMessage(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetNotFound(currentTableSettings.getDataSet().getUUID()));
                }

                public boolean onError(ClientRuntimeError error) {
                    ProcessInstanceLogPresenter.this.errorPopup.showMessage(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetError(currentTableSettings.getDataSet().getUUID(), error.getMessage()));
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.errorPopup.showMessage(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.UnexpectedError(e.getMessage()));
        }
    }

    public void loadMoreProcessInstanceLogs() {
        this.setCurrentPage(this.currentPage + 1);
        this.loadProcessInstanceLogs();
    }

    public void loadTaskDetails(Long workItemId, Date logDate, ProcessInstanceLogHumanTaskView humanTaskView) {
        ((TaskService)this.taskService.call(task -> humanTaskView.setDetailsData((TaskSummary)task, logDate))).getTaskByWorkItemId(this.serverTemplateId, this.containerId, workItemId);
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.serverTemplateId = event.getServerTemplateId();
        this.containerId = event.getDeploymentId();
        if (this.logsDataSetQueryHelper.getCurrentTableSettings() == null) {
            this.logsDataSetQueryHelper.setCurrentTableSettings(this.filterSettingsManager.createDefaultFilterSettingsPrototype(event.getProcessInstanceId()));
            this.setupDefaultActiveSearchFilters();
        } else {
            this.refreshGrid();
        }
    }

    public void refreshGrid() {
        this.currentPage = 0;
        this.loadProcessInstanceLogs();
    }

    public void setupDefaultActiveSearchFilters() {
        this.processInstanceLogBasicFiltersPresenter.onClearAllActiveFiltersEvent(new ClearAllActiveFiltersEvent());
        List<String> types = Arrays.asList(LogUtils.NODE_TYPE_START, LogUtils.NODE_TYPE_END, LogUtils.NODE_TYPE_HUMAN_TASK, LogUtils.NODE_TYPE_ACTION, LogUtils.NODE_TYPE_MILESTONE, LogUtils.NODE_TYPE_SUBPROCESS, LogUtils.NODE_TYPE_RULE_SET, LogUtils.NODE_TYPE_WORK_ITEM);
        List<String> nodeTypeLabels = Arrays.asList(this.constants.StartNodes(), this.constants.EndNodes(), this.constants.Human_Tasks(), this.constants.ActionNodes(), this.constants.Milestones(), this.constants.SubProcesses(), this.constants.RuleSets(), this.constants.WorkItems());
        this.addActiveFilter(FilterFactory.in((String)"nodeType", types), this.constants.EventNodeType(), String.join((CharSequence)", ", nodeTypeLabels), types, v -> this.removeActiveFilter(FilterFactory.in((String)"nodeType", (List)types)));
        this.addActiveFilter(FilterFactory.in((String)"type", Collections.emptyList()), this.constants.EventType(), "", Collections.emptyList(), v -> this.removeActiveFilter(FilterFactory.in((String)"type", Collections.emptyList())));
    }

    public void createListBreadcrumb() {
    }

    protected void selectSummaryItem(ProcessInstanceLogSummary summary) {
    }

    protected DataSetReadyCallback getDataSetReadyCallback(Integer startRange, FilterSettings tableSettings) {
        return null;
    }

    @Inject
    public void setTaskService(Caller<TaskService> taskService) {
        this.taskService = taskService;
    }

    public static interface ProcessInstanceLogView
    extends MultiGridView<ProcessInstanceLogSummary, ProcessInstanceLogPresenter> {
        public void setLogsList(List<ProcessInstanceLogSummary> var1);

        public void hideLoadButton(boolean var1);
    }
}

