/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.pr.client.editors.documents.list.ProcessDocumentListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsPresenter;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsTabPresenter;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramPresenter;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogPresenter;
import org.jbpm.workbench.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.jbpm.workbench.pr.service.ProcessService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDetailsPresenterTest {
    private static final Long PI_ID = 1L;
    private static final String SERVER_TEMPLATE_ID = "serverTemplateIdTest";
    private static final String PI_DEPLOYMENT_ID = "deploymentIdTest";
    @Mock
    public ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView view;
    @Mock
    ConfirmPopup confirmPopup;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Spy
    Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent = new EventSourceMock();
    @Spy
    Event<ProcessInstanceSelectionEvent> processInstanceSelected = new EventSourceMock();
    @Spy
    Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock();
    private CallerMock<ProcessService> remoteProcessServiceCaller;
    @Mock
    private ProcessService processService;
    private Caller<ProcessRuntimeDataService> processRuntimeDataServiceCaller;
    @Mock
    private ProcessRuntimeDataService processRuntimeDataService;
    @Mock
    PrimaryActionMenuBuilder signalProcessInstanceAction;
    @Mock
    PrimaryActionMenuBuilder abortProcessInstanceAction;
    @Mock
    private ProcessVariableListPresenter variableListPresenter;
    @Mock
    private ProcessDocumentListPresenter documentListPresenter;
    @Mock
    private ProcessInstanceLogPresenter processInstanceLogPresenter;
    @Mock
    private ProcessInstanceDetailsTabPresenter detailsPresenter;
    @Mock
    private ProcessInstanceDiagramPresenter processDiagramPresenter;
    @InjectMocks
    private ProcessInstanceDetailsPresenter presenter;

    @Before
    public void setupMocks() {
        ((Event)Mockito.doNothing().when(this.changeTitleWidgetEvent)).fire(Mockito.any(ChangeTitleWidgetEvent.class));
        ((Event)Mockito.doNothing().when(this.processInstanceSelected)).fire(Mockito.any(ProcessInstanceSelectionEvent.class));
        ((Event)Mockito.doNothing().when(this.processInstancesUpdatedEvent)).fire(Mockito.any(ProcessInstancesUpdateEvent.class));
        this.presenter.setSignalProcessInstanceAction(this.signalProcessInstanceAction);
        this.presenter.setAbortProcessInstanceAction(this.abortProcessInstanceAction);
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.processRuntimeDataServiceCaller = new CallerMock((Object)this.processRuntimeDataService);
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
        this.presenter.setProcessRuntimeDataService(this.processRuntimeDataServiceCaller);
    }

    @Test
    public void isForLogRemainsEnabledAfterRefresh() {
        ProcessInstanceSummary summary = ProcessInstanceSummary.builder().withServerTemplateId(SERVER_TEMPLATE_ID).withDeploymentId(PI_DEPLOYMENT_ID).withProcessInstanceId(PI_ID).withState(Integer.valueOf(1)).build();
        Mockito.when((Object)this.processRuntimeDataService.getProcessInstance((ProcessInstanceKey)Mockito.any())).thenReturn((Object)summary);
        boolean isLogOnly = true;
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(summary.getProcessInstanceKey(), isLogOnly));
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayOnlyLogTab();
        Assert.assertTrue((boolean)this.presenter.isForLog());
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(isLogOnly);
        this.presenter.onRefresh();
        Assert.assertTrue((boolean)this.presenter.isForLog());
    }

    @Test
    public void isForLogRemainsDisabledAfterRefresh() {
        ProcessInstanceSummary summary = ProcessInstanceSummary.builder().withServerTemplateId(SERVER_TEMPLATE_ID).withDeploymentId(PI_DEPLOYMENT_ID).withProcessInstanceId(PI_ID).withState(Integer.valueOf(1)).build();
        Mockito.when((Object)this.processRuntimeDataService.getProcessInstance((ProcessInstanceKey)Mockito.any())).thenReturn((Object)summary);
        boolean isLogOnly = false;
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(summary.getProcessInstanceKey(), isLogOnly));
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayAllTabs();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(isLogOnly);
        Assert.assertFalse((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForLog());
    }

    @Test
    public void confirmPopupTest() {
        ProcessInstanceSummary summary = ProcessInstanceSummary.builder().withServerTemplateId(SERVER_TEMPLATE_ID).withDeploymentId(PI_DEPLOYMENT_ID).withProcessInstanceId(PI_ID).withState(Integer.valueOf(1)).build();
        Mockito.when((Object)this.processRuntimeDataService.getProcessInstance((ProcessInstanceKey)Mockito.any())).thenReturn((Object)summary);
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(summary.getProcessInstanceKey(), true));
        this.presenter.openAbortProcessInstancePopup();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((ConfirmPopup)Mockito.verify((Object)this.confirmPopup)).show((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (Command)captureCommand.capture());
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
        ((Command)captureCommand.getValue()).execute();
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.DEFAULT, (Object)((NotificationEvent)captor.getValue()).getType());
        Assert.assertEquals((Object)Constants.INSTANCE.Aborting_Process_Instance((Object)PI_ID), (Object)((NotificationEvent)captor.getValue()).getNotification());
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstance(new ProcessInstanceKey(SERVER_TEMPLATE_ID, PI_DEPLOYMENT_ID, PI_ID));
    }

    @Test
    public void abortActiveInstanceFromDetailsHidesActionsTest() {
        ProcessInstanceSummary summary = ProcessInstanceSummary.builder().withServerTemplateId(SERVER_TEMPLATE_ID).withDeploymentId(PI_DEPLOYMENT_ID).withProcessInstanceId(PI_ID).withState(Integer.valueOf(1)).build();
        Mockito.when((Object)this.processRuntimeDataService.getProcessInstance((ProcessInstanceKey)Mockito.any())).thenReturn((Object)summary);
        ((ProcessService)Mockito.doAnswer(invocation -> null).when((Object)this.processService)).abortProcessInstance(summary.getProcessInstanceKey());
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(summary.getProcessInstanceKey(), false));
        this.verifySignalAbortActionsVisibility(false, true);
        this.verifyNoMoreInteractionsWithSignalAbortActions();
        Mockito.reset((Object[])new PrimaryActionMenuBuilder[]{this.signalProcessInstanceAction});
        Mockito.reset((Object[])new PrimaryActionMenuBuilder[]{this.abortProcessInstanceAction});
        this.presenter.abortProcessInstance();
        this.verifySignalAbortActionsVisibility(false);
        this.verifyNoMoreInteractionsWithSignalAbortActions();
    }

    @Test
    public void actionsDisabledForAbortedProcessInstance() {
        this.verifyActionsVisibility(3, false, false);
    }

    @Test
    public void actionsDisabledForCompletedProcessInstance() {
        this.verifyActionsVisibility(2, false, false);
    }

    @Test
    public void actionDisabledForPendingProcessInstance() {
        this.verifyActionsVisibility(0, false, false);
    }

    @Test
    public void actionDisabledForSuspendedProcessInstance() {
        this.verifyActionsVisibility(4, false, false);
    }

    @Test
    public void actionEnabledForActiveProcessInstance() {
        this.verifyActionsVisibility(1, false, true);
    }

    @Test
    public void actionDisabledForActiveProcessInstanceForLog() {
        this.verifyActionsVisibility(1, true, false);
    }

    private void verifyActionsVisibility(int status, boolean isForLog, boolean visibilityExpected) {
        ProcessInstanceSummary summary = ProcessInstanceSummary.builder().withServerTemplateId(SERVER_TEMPLATE_ID).withDeploymentId(PI_DEPLOYMENT_ID).withProcessInstanceId(PI_ID).withState(Integer.valueOf(status)).build();
        Mockito.when((Object)this.processRuntimeDataService.getProcessInstance((ProcessInstanceKey)Mockito.any())).thenReturn((Object)summary);
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(summary.getProcessInstanceKey(), isForLog));
        this.verifySignalAbortActionsVisibility(false, visibilityExpected);
        this.verifyNoMoreInteractionsWithSignalAbortActions();
    }

    private void verifySignalAbortActionsVisibility(Boolean ... expectedValues) {
        ArgumentCaptor captorSignal = ArgumentCaptor.forClass(Boolean.class);
        ((PrimaryActionMenuBuilder)Mockito.verify((Object)this.signalProcessInstanceAction, (VerificationMode)Mockito.times((int)expectedValues.length))).setVisible(((Boolean)captorSignal.capture()).booleanValue());
        Assertions.assertThat((List)captorSignal.getAllValues()).containsExactly((Object[])expectedValues);
        ArgumentCaptor captorAbort = ArgumentCaptor.forClass(Boolean.class);
        ((PrimaryActionMenuBuilder)Mockito.verify((Object)this.abortProcessInstanceAction, (VerificationMode)Mockito.times((int)expectedValues.length))).setVisible(((Boolean)captorAbort.capture()).booleanValue());
        Assertions.assertThat((List)captorAbort.getAllValues()).containsExactly((Object[])expectedValues);
    }

    private void verifyNoMoreInteractionsWithSignalAbortActions() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalProcessInstanceAction});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.abortProcessInstanceAction});
    }

    @Test
    public void refreshTest() {
        ProcessInstanceSummary summary = ProcessInstanceSummary.builder().withState(Integer.valueOf(1)).build();
        Mockito.when((Object)this.processRuntimeDataService.getProcessInstance((ProcessInstanceKey)Mockito.any())).thenReturn((Object)summary);
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(SERVER_TEMPLATE_ID, PI_DEPLOYMENT_ID, PI_ID, false));
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayAllTabs();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(false);
        this.presenter.onRefresh();
        ArgumentCaptor processInstanceSelectionEventArgumentCaptor = ArgumentCaptor.forClass(ProcessInstanceSelectionEvent.class);
        ((Event)Mockito.verify(this.processInstanceSelected)).fire(processInstanceSelectionEventArgumentCaptor.capture());
        Assert.assertEquals((Object)PI_DEPLOYMENT_ID, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getDeploymentId());
        Assert.assertEquals((Object)PI_ID, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getProcessInstanceId());
        Assert.assertFalse((boolean)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).isForLog());
        Assert.assertEquals((Object)SERVER_TEMPLATE_ID, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getServerTemplateId());
        this.presenter.onProcessSelectionEvent((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue());
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).displayAllTabs();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(false);
        ((ProcessVariableListPresenter)Mockito.verify((Object)this.variableListPresenter, (VerificationMode)Mockito.times((int)2))).setProcessInstance(summary);
        ((ProcessDocumentListPresenter)Mockito.verify((Object)this.documentListPresenter, (VerificationMode)Mockito.times((int)2))).setProcessInstance(summary);
        ((ProcessInstanceLogPresenter)Mockito.verify((Object)this.processInstanceLogPresenter, (VerificationMode)Mockito.times((int)2))).setProcessInstance(summary);
        ((ProcessInstanceDetailsTabPresenter)Mockito.verify((Object)this.detailsPresenter, (VerificationMode)Mockito.times((int)2))).setProcessInstance(summary);
        ((ProcessInstanceDiagramPresenter)Mockito.verify((Object)this.processDiagramPresenter, (VerificationMode)Mockito.times((int)2))).setProcessInstance(summary);
    }
}

