/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramPresenter;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramView;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceDiagramSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDiagramPresenterTest {
    @Mock
    ProcessRuntimeDataService processService;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    EventSourceMock<ProcessInstanceSelectionEvent> processInstanceEvent;
    @Mock
    ProcessInstanceDiagramView view;
    @InjectMocks
    ProcessInstanceDiagramPresenter presenter;

    @Before
    public void setup() {
        this.presenter.setProcessService((Caller)new CallerMock((Object)this.processService));
    }

    @Test
    public void testEmptyProcessInstanceDiagram() {
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.any())).thenReturn((Object)ProcessInstanceDiagramSummary.builder().withProcessNodes(Collections.emptyList()).withNodeInstances(Collections.emptyList()).withTimerInstances(Collections.emptyList()).build(), (Object[])new ProcessInstanceDiagramSummary[]{ProcessInstanceDiagramSummary.builder().withProcessNodes(Collections.emptyList()).withNodeInstances(Collections.emptyList()).withTimerInstances(Collections.emptyList()).withSvgContent("").build()});
        this.presenter.setProcessInstance(ProcessInstanceSummary.builder().withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build());
        this.presenter.setProcessInstance(ProcessInstanceSummary.builder().withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).displayMessage(Constants.INSTANCE.Process_Diagram_Not_FoundContainerShouldBeAvailable(Mockito.anyString()));
    }

    @Test
    public void testProcessInstanceDiagram() {
        String svgContent = "<svg></svg>";
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary((ProcessInstanceKey)Matchers.any())).thenReturn((Object)ProcessInstanceDiagramSummary.builder().withProcessNodes(Collections.emptyList()).withNodeInstances(Collections.emptyList()).withTimerInstances(Collections.emptyList()).withSvgContent("<svg></svg>").build(), (Object[])new ProcessInstanceDiagramSummary[]{ProcessInstanceDiagramSummary.builder().withProcessNodes(Collections.emptyList()).withNodeInstances(Collections.emptyList()).withTimerInstances(Collections.emptyList()).build()});
        this.presenter.setProcessInstance(ProcessInstanceSummary.builder().withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).displayMessage(Constants.INSTANCE.Process_Diagram_Not_FoundContainerShouldBeAvailable(Mockito.anyString()));
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).displayImage("<svg></svg>");
    }

    @Test
    public void testOnProcessInstanceSelectionEvent() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        String svgContent = "<svg></svg>";
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(1L), " ", "StartNode"), new ProcessNodeSummary(Long.valueOf(2L), "task-name", "HumanTask"), new ProcessNodeSummary(Long.valueOf(3L), " ", "Split"));
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withType("HumanTask").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withType("End").withCompleted(Boolean.valueOf(true)).build());
        List<TimerInstanceSummary> timerInstances = Arrays.asList(TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withName("t2").build(), TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withName("t1").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setSvgContent(svgContent);
        summary.setProcessNodes(nodes);
        summary.setNodeInstances(nodeInstances);
        summary.setTimerInstances(timerInstances);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary(processInstance.getProcessInstanceKey())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).showBusyIndicator((String)Matchers.any());
        ArgumentCaptor nodesCaptor = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setProcessNodes((List)nodesCaptor.capture());
        Assertions.assertThat((List)((List)nodesCaptor.getAllValues().get(0))).isEmpty();
        List viewNodes = (List)nodesCaptor.getAllValues().get(1);
        Assertions.assertThat((List)viewNodes).hasSameSizeAs(nodes);
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(0)).getLabel()).isEqualTo((Object)"Split-3");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(0)).getName()).isEqualTo((Object)"Split");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(0)).getType()).isEqualTo((Object)"Split");
        Assertions.assertThat((List)((ProcessNodeSummary)viewNodes.get(0)).getCallbacks()).hasSize(1);
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(1)).getLabel()).isEqualTo((Object)"StartNode-1");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(1)).getName()).isEqualTo((Object)"StartNode");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(1)).getType()).isEqualTo((Object)"StartNode");
        Assertions.assertThat((List)((ProcessNodeSummary)viewNodes.get(1)).getCallbacks()).isNullOrEmpty();
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(2)).getLabel()).isEqualTo((Object)"task-name-2");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(2)).getName()).isEqualTo((Object)"task-name");
        Assertions.assertThat((String)((ProcessNodeSummary)viewNodes.get(2)).getType()).isEqualTo((Object)"HumanTask");
        Assertions.assertThat((List)((ProcessNodeSummary)viewNodes.get(2)).getCallbacks()).hasSize(1);
        ArgumentCaptor nodeInstancesCaptor = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setNodeInstances((List)nodeInstancesCaptor.capture());
        Assertions.assertThat((List)((List)nodeInstancesCaptor.getAllValues().get(0))).isEmpty();
        List viewNodeInstances = (List)nodeInstancesCaptor.getAllValues().get(1);
        Assertions.assertThat((List)viewNodeInstances).hasSameSizeAs(nodeInstances);
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getLabel()).isEqualTo((Object)"End-4");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getName()).isEqualTo((Object)"End");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getType()).isEqualTo((Object)"End");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(0)).getDescription()).startsWith((CharSequence)"Completed");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(0)).getCallbacks()).isNullOrEmpty();
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getLabel()).isEqualTo((Object)"name-1-1");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getName()).isEqualTo((Object)"name-1");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getType()).isEqualTo((Object)"HumanTask");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(1)).getDescription()).startsWith((CharSequence)"Started");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(1)).getCallbacks()).hasSize(2);
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getLabel()).isEqualTo((Object)"name-3-3");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getName()).isEqualTo((Object)"name-3");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getType()).isEqualTo((Object)"HumanTask");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(2)).getDescription()).startsWith((CharSequence)"Completed");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(2)).getCallbacks()).isNullOrEmpty();
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getLabel()).isEqualTo((Object)"Split-2");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getName()).isEqualTo((Object)"Split");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getType()).isEqualTo((Object)"Split");
        Assertions.assertThat((String)((NodeInstanceSummary)viewNodeInstances.get(3)).getDescription()).startsWith((CharSequence)"Started");
        Assertions.assertThat((List)((NodeInstanceSummary)viewNodeInstances.get(3)).getCallbacks()).hasSize(2);
        ArgumentCaptor timerInstancesCaptor = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setTimerInstances((List)timerInstancesCaptor.capture());
        Assertions.assertThat((List)((List)timerInstancesCaptor.getAllValues().get(0))).isEmpty();
        List viewTimerInstances = (List)timerInstancesCaptor.getAllValues().get(1);
        Assertions.assertThat((List)viewTimerInstances).hasSameSizeAs(timerInstances);
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(0)).getLabel()).isEqualTo((Object)"t1-1");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(0)).getName()).isEqualTo((Object)"t1");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(0)).getDescription()).startsWith((CharSequence)"NextExecution");
        Assertions.assertThat((List)((TimerInstanceSummary)viewTimerInstances.get(0)).getCallbacks()).hasSize(1);
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(1)).getLabel()).isEqualTo((Object)"t2-2");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(1)).getName()).isEqualTo((Object)"t2");
        Assertions.assertThat((String)((TimerInstanceSummary)viewTimerInstances.get(1)).getDescription()).startsWith((CharSequence)"NextExecution");
        Assertions.assertThat((List)((TimerInstanceSummary)viewTimerInstances.get(1)).getCallbacks()).hasSize(1);
    }

    @Test
    public void testOnProcessNodeNullSelected() {
        this.presenter.onProcessNodeSelected(null);
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setValue((Object)new ProcessNodeSummary());
    }

    @Test
    public void testOnProcessNodeSelected() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessNodeSummary humanTask = new ProcessNodeSummary(Long.valueOf(1L), "name-1", "HumanTask");
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(0L), " ", "Start"), humanTask, new ProcessNodeSummary(Long.valueOf(2L), " ", "Split"));
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessNodes(nodes);
        summary.setNodeInstances(Collections.emptyList());
        summary.setTimerInstances(Collections.emptyList());
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary(processInstance.getProcessInstanceKey())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onProcessNodeSelected(Long.valueOf(1L));
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setValue((Object)humanTask);
    }

    @Test
    public void testOnNodeTriggered() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        ProcessNodeSummary humanTask = new ProcessNodeSummary(Long.valueOf(1L), "name-1", "HumanTask");
        List<ProcessNodeSummary> nodes = Arrays.asList(new ProcessNodeSummary(Long.valueOf(0L), " ", "Start"), humanTask, new ProcessNodeSummary(Long.valueOf(2L), " ", "Split"));
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessNodes(nodes);
        summary.setNodeInstances(Collections.emptyList());
        summary.setTimerInstances(Collections.emptyList());
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary(processInstance.getProcessInstanceKey())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onProcessNodeTrigger(humanTask);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).triggerProcessInstanceNode(processInstance.getProcessInstanceKey(), (Long)humanTask.getId());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
        ((ProcessInstanceDiagramView)Mockito.verify((Object)this.view)).setValue((Object)new ProcessNodeSummary());
    }

    @Test
    public void testOnNodeInstanceCancelled() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        NodeInstanceSummary humanTask = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withType("HumanTask").withCompleted(Boolean.valueOf(false)).build();
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(humanTask, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withType("End").withCompleted(Boolean.valueOf(true)).build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessNodes(Collections.emptyList());
        summary.setNodeInstances(nodeInstances);
        summary.setTimerInstances(Collections.emptyList());
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary(processInstance.getProcessInstanceKey())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onNodeInstanceCancel(humanTask);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).cancelProcessInstanceNode(processInstance.getProcessInstanceKey(), (Long)humanTask.getId());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testOnNodeInstanceReTriggered() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        NodeInstanceSummary humanTask = NodeInstanceSummary.builder().withId(Long.valueOf(1L)).withName("name-1").withType("HumanTask").withCompleted(Boolean.valueOf(false)).build();
        List<NodeInstanceSummary> nodeInstances = Arrays.asList(humanTask, NodeInstanceSummary.builder().withId(Long.valueOf(2L)).withName(" ").withType("Split").withCompleted(Boolean.valueOf(false)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(3L)).withName("name-3").withType("HumanTask").withCompleted(Boolean.valueOf(true)).build(), NodeInstanceSummary.builder().withId(Long.valueOf(4L)).withName(" ").withType("End").withCompleted(Boolean.valueOf(true)).build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessNodes(Collections.emptyList());
        summary.setNodeInstances(nodeInstances);
        summary.setTimerInstances(Collections.emptyList());
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary(processInstance.getProcessInstanceKey())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onNodeInstanceReTrigger(humanTask);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).reTriggerProcessInstanceNode(processInstance.getProcessInstanceKey(), (Long)humanTask.getId());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testOnTimerInstanceReschedule() {
        ProcessInstanceSummary processInstance = ProcessInstanceSummary.builder().withServerTemplateId("serverTemplateId").withDeploymentId("containerId").withProcessInstanceId(Long.valueOf(1L)).withState(Integer.valueOf(1)).build();
        TimerInstanceSummary timer = TimerInstanceSummary.builder().withId(Long.valueOf(1L)).withName("t1").build();
        List<TimerInstanceSummary> timerInstance = Arrays.asList(timer, TimerInstanceSummary.builder().withId(Long.valueOf(2L)).withName("t2").build());
        ProcessInstanceDiagramSummary summary = new ProcessInstanceDiagramSummary();
        summary.setProcessNodes(Collections.emptyList());
        summary.setNodeInstances(Collections.emptyList());
        summary.setTimerInstances(timerInstance);
        Mockito.when((Object)this.processService.getProcessInstanceDiagramSummary(processInstance.getProcessInstanceKey())).thenReturn((Object)summary);
        this.presenter.setProcessInstance(processInstance);
        this.presenter.onTimerInstanceReschedule(timer);
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processService)).rescheduleTimerInstance(processInstance.getProcessInstanceKey(), timer);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Matchers.any());
    }

    @Test
    public void testIsProcessNodeTypeTriggerAllowed() {
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(null));
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary()));
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "StartNode")));
        Assert.assertFalse((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "Join")));
        Assert.assertTrue((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "Split")));
        Assert.assertTrue((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "HumanTaskNode")));
        Assert.assertTrue((boolean)this.presenter.isProcessNodeTypeTriggerAllowed(new ProcessNodeSummary(Long.valueOf(1L), "", "TimerNode")));
    }
}

