/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.pr.client.editors.instance.ProcessInstanceSummaryAware;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.TimerInstanceRescheduleView;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class ProcessInstanceDiagramPresenter
implements ProcessInstanceSummaryAware {
    private Constants constants = Constants.INSTANCE;
    private Caller<ProcessRuntimeDataService> processService;
    private List<ProcessNodeSummary> processNodes;
    private ProcessInstanceSummary processInstance;
    private boolean forLog;
    @Inject
    private TimerInstanceRescheduleView rescheduleView;
    @Inject
    private ProcessInstanceDiagramView view;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceEvent;
    @Inject
    private Event<NotificationEvent> notification;

    @PostConstruct
    public void init() {
        this.view.setOnProcessNodeSelectedCallback((Callback<Long>)((Callback)id -> this.onProcessNodeSelected((Long)id)));
    }

    @Override
    public void setProcessInstance(ProcessInstanceSummary processInstance) {
        this.view.showBusyIndicator(this.constants.Loading());
        this.processInstance = processInstance;
        this.processNodes = Collections.emptyList();
        this.view.setProcessNodes(this.processNodes);
        this.view.setNodeInstances(Collections.emptyList());
        this.view.setTimerInstances(Collections.emptyList());
        this.loadProcessInstanceDetails();
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.forLog = event.isForLog();
    }

    protected void loadProcessInstanceDetails() {
        ((ProcessRuntimeDataService)this.processService.call(summary -> {
            this.displayImage(summary.getSvgContent(), this.processInstance.getDeploymentId());
            this.processNodes = summary.getProcessNodes().stream().sorted(Comparator.comparing(ProcessNodeSummary::getName, String.CASE_INSENSITIVE_ORDER).thenComparingLong(GenericSummary::getId)).collect(Collectors.toList());
            this.processNodes.stream().filter(this::isProcessNodeTypeTriggerAllowed).forEach(pn -> pn.addCallback(this.constants.Trigger(), () -> this.onProcessNodeTrigger((ProcessNodeSummary)pn)));
            this.view.setProcessNodes(this.processNodes);
            List<NodeInstanceSummary> nodeInstances = summary.getNodeInstances().stream().sorted(Comparator.comparing(NodeInstanceSummary::getName, String.CASE_INSENSITIVE_ORDER).thenComparingLong(GenericSummary::getId)).collect(Collectors.toList());
            nodeInstances.forEach(ni -> {
                ni.setDescription((ni.isCompleted() != false ? this.constants.Completed() : this.constants.Started()) + " " + DateUtils.getPrettyTime((Date)ni.getTimestamp()));
                if (!ni.isCompleted().booleanValue()) {
                    ni.addCallback(this.constants.Cancel(), () -> this.onNodeInstanceCancel((NodeInstanceSummary)ni));
                    ni.addCallback(this.constants.ReTrigger(), () -> this.onNodeInstanceReTrigger((NodeInstanceSummary)ni));
                }
            });
            this.view.setNodeInstances(nodeInstances);
            List<TimerInstanceSummary> timerInstances = summary.getTimerInstances().stream().sorted(Comparator.comparing(TimerInstanceSummary::getName, String.CASE_INSENSITIVE_ORDER).thenComparingLong(GenericSummary::getId)).collect(Collectors.toList());
            timerInstances.forEach(ti -> {
                ti.setDescription(this.constants.NextExecution() + " " + DateUtils.getPrettyTime((Date)ti.getNextFireTime()));
                ti.addCallback(this.constants.Reschedule(), () -> {
                    this.rescheduleView.setOnReschedule((Callback<TimerInstanceSummary>)((Callback)timer -> this.onTimerInstanceReschedule((TimerInstanceSummary)timer)));
                    this.rescheduleView.setValue((TimerInstanceSummary)ti);
                    this.rescheduleView.show();
                });
            });
            this.view.setTimerInstances(timerInstances);
            if (this.forLog || this.processInstance.getState() != 1) {
                this.view.hideNodeActions();
            }
        })).getProcessInstanceDiagramSummary(this.processInstance.getProcessInstanceKey());
    }

    public void displayImage(String svgContent, String containerId) {
        if (svgContent == null || svgContent.isEmpty()) {
            this.view.displayMessage(this.constants.Process_Diagram_Not_FoundContainerShouldBeAvailable(containerId));
        } else {
            this.view.displayImage(svgContent);
        }
        this.view.hideBusyIndicator();
    }

    public void onProcessNodeSelected(Long nodeId) {
        ProcessNodeSummary nodeSummary = nodeId == null ? new ProcessNodeSummary() : this.getProcessNodeSummary(nodeId);
        this.view.setValue(nodeSummary);
    }

    protected Boolean isProcessNodeTypeTriggerAllowed(ProcessNodeSummary nodeSummary) {
        if (nodeSummary == null || nodeSummary.getType() == null) {
            return false;
        }
        if ("StartNode".equals(nodeSummary.getType()) || "Join".equals(nodeSummary.getType())) {
            return false;
        }
        return true;
    }

    protected ProcessNodeSummary getProcessNodeSummary(Long nodeId) {
        return this.processNodes.stream().filter(node -> ((Long)node.getId()).equals(nodeId)).findFirst().get();
    }

    public void onProcessNodeTrigger(ProcessNodeSummary node) {
        ((ProcessRuntimeDataService)this.processService.call(Void2 -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.NodeTriggered(node.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.view.setValue(new ProcessNodeSummary());
            this.refreshDetails();
        })).triggerProcessInstanceNode(this.processInstance.getProcessInstanceKey(), (Long)node.getId());
    }

    protected void refreshDetails() {
        this.processInstanceEvent.fire((Object)new ProcessInstanceSelectionEvent(this.processInstance.getProcessInstanceKey(), this.forLog));
    }

    public void onNodeInstanceReTrigger(NodeInstanceSummary node) {
        ((ProcessRuntimeDataService)this.processService.call(Void2 -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.NodeInstanceReTriggered(node.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.refreshDetails();
        })).reTriggerProcessInstanceNode(this.processInstance.getProcessInstanceKey(), (Long)node.getId());
    }

    public void onNodeInstanceCancel(NodeInstanceSummary node) {
        ((ProcessRuntimeDataService)this.processService.call(Void2 -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.NodeInstanceCancelled(node.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.refreshDetails();
        })).cancelProcessInstanceNode(this.processInstance.getProcessInstanceKey(), (Long)node.getId());
    }

    public void onTimerInstanceReschedule(TimerInstanceSummary summary) {
        ((ProcessRuntimeDataService)this.processService.call(Void2 -> {
            this.notification.fire((Object)new NotificationEvent(this.constants.TimerInstanceRescheduled(summary.getLabel()), NotificationEvent.NotificationType.SUCCESS));
            this.refreshDetails();
        })).rescheduleTimerInstance(this.processInstance.getProcessInstanceKey(), summary);
    }

    @WorkbenchPartTitle
    public String getName() {
        return this.constants.Diagram();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    @Inject
    public void setProcessService(Caller<ProcessRuntimeDataService> processService) {
        this.processService = processService;
    }
}

