/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.diagram;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetView;
import org.jbpm.workbench.pr.client.editors.diagram.ZoomControlView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.views.pfly.widgets.D3;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Dependent
@Templated
public class ProcessDiagramWidgetViewImpl
extends Composite
implements ProcessDiagramWidgetView,
RequiresResize {
    @Inject
    @DataField(value="processDiagramDiv")
    private HTMLDivElement processDiagramDiv;
    @Inject
    @DataField(value="message")
    @Named(value="span")
    private HTMLElement heading;
    @Inject
    @DataField
    private HTMLDivElement alert;
    @Inject
    private ZoomControlView zoomControlView;
    private Callback<String> nodeSelectionCallback;

    @Override
    public void setOnDiagramNodeSelectionCallback(Callback<String> callback) {
        this.nodeSelectionCallback = callback;
    }

    @Override
    public void displayImage(String svgContent) {
        this.processDiagramDiv.innerHTML = svgContent;
        D3 d3 = D3.Builder.get();
        D3 svg = d3.select("#processDiagramDiv svg");
        D3.CallbackFunction callback = () -> {
            D3.ZoomEvent event = (D3.ZoomEvent)D3.Builder.get().getEvent();
            svg.attr("transform", (Object)event.getTransform());
            double zoom = Math.round(100.0 + (event.getTransform().getK() - 1.0) * 100.0);
            this.zoomControlView.setZoomText(zoom + "%");
        };
        D3.Zoom zoom = d3.zoom();
        svg.call(zoom.on("zoom", callback), new Object[0]);
        this.zoomControlView.setScaleTo100Command(() -> zoom.transform(svg.transition().duration(500.0), d3.getZoomIdentity()));
        this.zoomControlView.setScaleTo300Command(() -> zoom.scaleTo(svg.transition().duration(500.0), 3.0));
        this.zoomControlView.setScaleTo150Command(() -> zoom.scaleTo(svg.transition().duration(500.0), 1.5));
        this.zoomControlView.setScaleTo50Command(() -> zoom.scaleTo(svg.transition().duration(500.0), 0.5));
        this.zoomControlView.setScaleMinusCommand(() -> zoom.scaleBy(svg.transition().duration(500.0), 0.95));
        this.zoomControlView.setScalePlusCommand(() -> zoom.scaleBy(svg.transition().duration(500.0), 1.05));
        this.processDiagramDiv.appendChild((Node)this.zoomControlView.getElement());
        if (this.nodeSelectionCallback == null) {
            return;
        }
        D3 selectAll = svg.selectAll("g [bpmn2nodeid]");
        selectAll.on("mouseenter", () -> {
            Object target = D3.Builder.get().getEvent().getCurrentTarget();
            D3 node = d3.select(target);
            node.style("cursor", (Object)"pointer");
            node.attr("opacity", (Object)0.7);
        });
        selectAll.on("mouseleave", () -> {
            Object target = D3.Builder.get().getEvent().getCurrentTarget();
            D3 node = d3.select(target);
            node.style("cursor", (Object)"default");
            node.attr("opacity", (Object)1);
        });
        selectAll.on("click", () -> {
            Object target = D3.Builder.get().getEvent().getCurrentTarget();
            D3 node = d3.select(target);
            this.nodeSelectionCallback.callback((Object)((String)node.attr("bpmn2nodeid")));
        });
    }

    @Override
    public void displayMessage(String message) {
        this.alert.classList.remove(new String[]{"hidden"});
        this.heading.textContent = message;
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight();
        int width = this.getParent().getOffsetWidth();
        this.setPixelSize(width, height);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

