/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.HTMLDivElement;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetViewImpl;
import org.jbpm.workbench.pr.client.editors.instance.diagram.NodeInstancesView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessInstanceDiagramView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.ProcessNodeItemView;
import org.jbpm.workbench.pr.client.editors.instance.diagram.TimerInstancesView;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessNodeSummary;
import org.jbpm.workbench.pr.model.TimerInstanceSummary;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.views.pfly.widgets.Select;

@Dependent
@Templated(stylesheet="ProcessInstanceDiagram.css")
public class ProcessInstanceDiagramViewImpl
extends Composite
implements ProcessInstanceDiagramView {
    @Inject
    @DataField(value="diagram")
    private ProcessDiagramWidgetViewImpl diagram;
    @Inject
    @DataField(value="available-nodes")
    private Select processNodes;
    @Inject
    @DataField(value="node-details-panel")
    private ProcessNodeItemView processNodeSummaryView;
    @Inject
    @DataField(value="node-instances")
    private NodeInstancesView nodeInstancesView;
    @Inject
    @DataField(value="timer-instances")
    private TimerInstancesView timerInstancesView;
    @Inject
    @DataField(value="node-actions-panel")
    private HTMLDivElement nodeActionsPanel;
    @Inject
    @DataField(value="process-diagram-panel")
    private HTMLDivElement processDiagramPanel;
    private Callback<String> onProcessNodeSelectedCallback;

    @Override
    public void setOnProcessNodeSelectedCallback(Callback<String> callback) {
        this.onProcessNodeSelectedCallback = callback;
    }

    @Override
    public void setOnDiagramNodeSelectionCallback(Callback<String> callback) {
        this.diagram.setOnDiagramNodeSelectionCallback(callback);
    }

    @Override
    public void setProcessNodes(List<ProcessNodeSummary> nodes) {
        this.processNodes.removeAllOptions();
        nodes.forEach(node -> this.processNodes.addOption(node.getLabel(), node.getUniqueId()));
        this.processNodes.refresh();
    }

    public ProcessNodeSummary getValue() {
        return this.processNodeSummaryView.getValue();
    }

    public void setValue(ProcessNodeSummary node) {
        this.processNodeSummaryView.setValue(node);
        if (node.getId() == null) {
            this.processNodeSummaryView.getElement().classList.add(new String[]{"hidden"});
            this.processNodes.setValue("");
        } else {
            this.processNodeSummaryView.getElement().classList.remove(new String[]{"hidden"});
            this.processNodes.setValue(node.getUniqueId());
        }
    }

    @Override
    public void setNodeInstances(List<NodeInstanceSummary> nodes) {
        if (nodes.isEmpty()) {
            this.nodeInstancesView.getElement().classList.add(new String[]{"hidden"});
        } else {
            this.nodeInstancesView.getElement().classList.remove(new String[]{"hidden"});
        }
        this.nodeInstancesView.setValue(nodes);
    }

    @Override
    public void setTimerInstances(List<TimerInstanceSummary> timers) {
        if (timers.isEmpty()) {
            this.timerInstancesView.getElement().classList.add(new String[]{"hidden"});
        } else {
            this.timerInstancesView.getElement().classList.remove(new String[]{"hidden"});
        }
        this.timerInstancesView.setValue(timers);
    }

    @EventHandler(value={"available-nodes"})
    public void onProcessNodeChange(@ForEvent(value={"change"}) Event e) {
        this.processNodes.toggle();
        if (this.onProcessNodeSelectedCallback != null) {
            String node = this.processNodes.getValue();
            this.onProcessNodeSelectedCallback.callback(node == null || node.trim().isEmpty() ? null : node);
        }
    }

    @Override
    public void hideNodeActions() {
        this.nodeActionsPanel.classList.remove(new String[]{"col-md-2"});
        this.nodeActionsPanel.classList.add(new String[]{"hidden"});
        this.processDiagramPanel.classList.remove(new String[]{"col-md-10"});
        this.processDiagramPanel.classList.add(new String[]{"col-md-12"});
    }

    @Override
    public void displayImage(String svgContent) {
        this.diagram.displayImage(svgContent);
    }

    @Override
    public void displayMessage(String message) {
        this.diagram.displayMessage(message);
    }

    public void showBusyIndicator(String message) {
        this.diagram.showBusyIndicator(message);
    }

    public void hideBusyIndicator() {
        this.diagram.hideBusyIndicator();
    }
}

