/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.List;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.list.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.model.PortableQueryFilter;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.NewCaseInstanceEvent;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProcessDefinitionListScreen")
public class ProcessDefinitionListPresenter
extends AbstractScreenListPresenter<ProcessSummary> {
    @Inject
    PopupFormDisplayerView formDisplayPopUp;
    @Inject
    StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    private ProcessDefinitionListView view;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;
    @Inject
    private DefaultWorkbenchErrorCallback errorCallback;
    protected AuthorizationManager authorizationManager;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private Event<ProcessDefSelectionEvent> processDefSelected;
    private Constants constants = Constants.INSTANCE;
    private final org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;

    @Inject
    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    @WorkbenchPartView
    public UberView<ProcessDefinitionListPresenter> getView() {
        return this.view;
    }

    public void createListBreadcrumb() {
        this.setupListBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions());
    }

    public void setupDetailBreadcrumb(String detailLabel) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions(), detailLabel, "ProcessDefinitionDetailsScreen");
    }

    public void openGenericForm(String processDefId, String deploymentId, String processDefName, boolean isDynamic) {
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.getSelectedServerTemplate(), deploymentId, processDefId, processDefName), processDefName, isDynamic);
        this.formDisplayPopUp.setTitle(processDefName);
        this.startProcessDisplayProvider.setup(config, (FormDisplayerView)this.formDisplayPopUp);
    }

    protected ListView getListView() {
        return this.view;
    }

    public void getData(Range visibleRange) {
        ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() == 0 || columnSortList.get(0).isAscending());
        }
        if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
            this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
            this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
        } else {
            this.currentFilter.setOffset(Integer.valueOf(0));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        }
        this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
        this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() == 0 || columnSortList.get(0).isAscending()));
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(processDefsSums -> {
            boolean lastPageExactCount = processDefsSums.size() < visibleRange.getLength();
            this.updateDataOnCallback((List)processDefsSums, visibleRange.getStart(), visibleRange.getStart() + processDefsSums.size(), lastPageExactCount);
        }, (message, throwable) -> this.onRuntimeDataServiceError(throwable))).getProcesses(this.getSelectedServerTemplate(), Integer.valueOf(visibleRange.getStart() / visibleRange.getLength()), Integer.valueOf(visibleRange.getLength()), this.currentFilter.getOrderBy(), this.currentFilter.isAscending());
    }

    boolean onRuntimeDataServiceError(Throwable throwable) {
        this.setEmptyResults();
        this.errorCallback.error(throwable);
        return false;
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    protected void selectProcessDefinition(ProcessSummary processSummary) {
        this.setupDetailBreadcrumb(this.constants.ProcessDefinitionBreadcrumb(processSummary.getName()));
        this.placeManager.goTo("ProcessDefinitionDetailsScreen");
        this.fireProcessDefSelectionEvent(processSummary);
    }

    private void fireProcessDefSelectionEvent(ProcessSummary processSummary) {
        this.processDefSelected.fire((Object)new ProcessDefSelectionEvent(processSummary.getProcessDefId(), processSummary.getDeploymentId(), this.getSelectedServerTemplate(), processSummary.getProcessDefName(), processSummary.isDynamic()));
    }

    public void refreshNewProcessInstance(@Observes NewProcessInstanceEvent newProcessInstance) {
        this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions(), this.constants.ProcessInstanceBreadcrumb(newProcessInstance.getNewProcessInstanceId()), "ProcessInstanceDetailsScreen");
        this.placeManager.goTo("ProcessInstanceDetailsScreen");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(newProcessInstance.getServerTemplateId(), newProcessInstance.getDeploymentId(), newProcessInstance.getNewProcessInstanceId(), false));
    }

    public void refreshNewCaseInstance(@Observes NewCaseInstanceEvent newCaseInstance) {
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(newProcessInstance -> {
            this.setupDetailBreadcrumb(this.placeManager, this.commonConstants.Manage_Process_Definitions(), this.constants.ProcessInstanceBreadcrumb((Long)newProcessInstance.getId()), "ProcessInstanceDetailsScreen");
            this.placeManager.goTo("ProcessInstanceDetailsScreen");
            this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(newProcessInstance.getServerTemplateId(), newProcessInstance.getDeploymentId(), (Long)newProcessInstance.getId(), false));
        }, (message, throwable) -> this.onRuntimeDataServiceError(throwable))).getProcessInstanceByCorrelationKey(newCaseInstance.getServerTemplateId(), newCaseInstance.getNewCaseId());
    }

    public Predicate<ProcessSummary> getViewProcessInstanceActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("ProcessInstances");
    }

    public Predicate<ProcessSummary> getStartCondition() {
        return processSummary -> !processSummary.isDynamic() || processSummary.isDynamic() && processSummary.isDynamicFormsEnabled();
    }

    public void viewProcessInstances(String processDefId) {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("ProcessInstances");
        placeRequestImpl.addParameter("processDefinitionId", processDefId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public boolean isUserAuthorizedForPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.identity);
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public static interface ProcessDefinitionListView
    extends ListView<ProcessSummary, ProcessDefinitionListPresenter> {
    }
}

