/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsTabPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.UserTaskSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDetailsTabPresenterTest {
    private static final int ACTIVE_STATE = 1;
    private static final int SLA_MET = 2;
    private static final String PROCESS_VERSION = "1.0";
    private static final String PROCESS_ID = "evaluation";
    private static final Long PROCESS_INSTANCE_ID = 3L;
    private static final String SERVER_TEMPLATE_ID = "testTemplate";
    private static final String DEPLOYMENT_ID = "evaluation_1.0.0-SNAPSHOT";
    private UserTaskSummary userTaskSummary;
    private NodeInstanceSummary nodeInstanceSummary;
    private ProcessInstanceSummary processInstanceSummary;
    @Mock
    private ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView view;
    @Mock
    private ProcessRuntimeDataService processRuntimeDataServiceMock;
    @InjectMocks
    private ProcessInstanceDetailsTabPresenter presenter;

    @Before
    public void setUp() {
        this.presenter.setProcessRuntimeDataService((Caller)new CallerMock((Object)this.processRuntimeDataServiceMock));
        this.nodeInstanceSummary = this.getNodeInstanceSummary();
        this.processInstanceSummary = this.getProcessInstanceSummary();
        Mockito.when((Object)this.processRuntimeDataServiceMock.getProcessInstanceActiveNodes(this.processInstanceSummary.getProcessInstanceKey())).thenReturn(Collections.singletonList(this.nodeInstanceSummary));
    }

    @Test
    public void setProcessInstanceDetailsTest() {
        this.presenter.setProcessInstance(this.processInstanceSummary);
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view)).setProcessDefinitionIdText(this.processInstanceSummary.getProcessId());
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view)).setStateText(Constants.INSTANCE.Active());
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view)).setProcessDeploymentText(this.processInstanceSummary.getDeploymentId());
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view)).setProcessVersionText(this.processInstanceSummary.getProcessVersion());
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view)).setCorrelationKeyText(this.processInstanceSummary.getCorrelationKey());
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view)).setParentProcessInstanceIdText(Constants.INSTANCE.No_Parent_Process_Instance());
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view)).setSlaComplianceText(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.SlaMet());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(String.class);
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setActiveTasksListBox((String)argumentCaptor.capture());
        ((ListAssert)Assertions.assertThat((List)argumentCaptor.getAllValues()).as("Active user tasks are set", new Object[0])).hasSize(2);
        Assert.assertEquals((Object)"", argumentCaptor.getAllValues().get(0));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)argumentCaptor.getAllValues().get(1))).as("Active user tasks", new Object[0])).contains(new CharSequence[]{this.userTaskSummary.getName(), this.userTaskSummary.getStatus(), this.userTaskSummary.getOwner()});
        argumentCaptor = ArgumentCaptor.forClass(String.class);
        ((ProcessInstanceDetailsTabPresenter.ProcessInstanceDetailsTabView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setCurrentActivitiesListBox((String)argumentCaptor.capture());
        ((ListAssert)Assertions.assertThat((List)argumentCaptor.getAllValues()).as("Current Activities are set", new Object[0])).hasSize(2);
        Assert.assertEquals((Object)"", argumentCaptor.getAllValues().get(0));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)((String)argumentCaptor.getAllValues().get(1))).as("Current Activities", new Object[0])).contains(new CharSequence[]{this.nodeInstanceSummary.getTimestamp().toString(), String.valueOf(this.nodeInstanceSummary.getId()), this.nodeInstanceSummary.getName(), this.nodeInstanceSummary.getType()});
    }

    private NodeInstanceSummary getNodeInstanceSummary() {
        NodeInstanceSummary nodeInstanceSummary = new NodeInstanceSummary();
        nodeInstanceSummary.setTimestamp(new Date());
        nodeInstanceSummary.setId((Object)1L);
        nodeInstanceSummary.setName("Self Evaluation");
        nodeInstanceSummary.setType("HumanTaskNode");
        return nodeInstanceSummary;
    }

    private ProcessInstanceSummary getProcessInstanceSummary() {
        ProcessInstanceSummary processInstanceSummary = new ProcessInstanceSummary();
        processInstanceSummary.setServerTemplateId(SERVER_TEMPLATE_ID);
        processInstanceSummary.setProcessId(PROCESS_ID);
        processInstanceSummary.setState(Integer.valueOf(1));
        processInstanceSummary.setDeploymentId(DEPLOYMENT_ID);
        processInstanceSummary.setProcessVersion(PROCESS_VERSION);
        processInstanceSummary.setCorrelationKey(PROCESS_INSTANCE_ID.toString());
        processInstanceSummary.setParentId(Long.valueOf(0L));
        processInstanceSummary.setActiveTasks(Collections.singletonList(this.getUserTaskSummary()));
        processInstanceSummary.setSlaCompliance(Integer.valueOf(2));
        return processInstanceSummary;
    }

    private UserTaskSummary getUserTaskSummary() {
        this.userTaskSummary = new UserTaskSummary(Long.valueOf(1L), "Self Evaluation", "testuser", "Reserved");
        return this.userTaskSummary;
    }
}

