/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessDefinitionListPresenterTest {
    private static final String PERSPECTIVE_ID = "ProcessDefinitions";
    private org.jbpm.workbench.common.client.resources.i18n.Constants commonConstants;
    @Mock
    protected PlaceManager placeManager;
    @Mock
    private UberfireBreadcrumbs breadcrumbs;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User identity;
    @Mock
    private PerspectiveManager perspectiveManager;
    @Mock
    private PerspectiveActivity perspectiveActivity;
    @Mock
    protected EventSourceMock<ProcessDefSelectionEvent> processDefSelectionEvent;
    @Mock
    ProcessDefinitionListPresenter.ProcessDefinitionListView view;
    @Mock
    ExtendedPagedTable extendedPagedTable;
    Caller<ProcessRuntimeDataService> processRuntimeDataServiceCaller;
    @Mock
    ProcessRuntimeDataService processRuntimeDataService;
    @Mock
    StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Mock
    PopupFormDisplayerView formDisplayPopUp;
    @Mock
    DefaultWorkbenchErrorCallback errorCallback;
    @InjectMocks
    @Spy
    ProcessDefinitionListPresenter presenter;

    private static List<ProcessSummary> getMockList(int instances) {
        ArrayList<ProcessSummary> summaries = new ArrayList<ProcessSummary>();
        for (int i = 0; i < instances; ++i) {
            summaries.add(new ProcessSummary());
        }
        return summaries;
    }

    @Before
    public void setup() {
        this.processRuntimeDataServiceCaller = new CallerMock((Object)this.processRuntimeDataService);
        this.presenter.setProcessRuntimeDataService(this.processRuntimeDataServiceCaller);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getColumnSortList()).thenReturn((Object)new ColumnSortList());
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)this.perspectiveActivity);
        Mockito.when((Object)this.perspectiveActivity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        this.commonConstants = org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE;
    }

    @Test
    public void testProcessDefNameDefinitionPropagation() {
        ProcessSummary processSummary = new ProcessSummary();
        processSummary.setProcessDefId("testProcessDefId");
        processSummary.setDeploymentId("testDeploymentId");
        processSummary.setProcessDefName("testProcessDefName");
        processSummary.setDynamic(Boolean.valueOf(false));
        this.presenter.selectProcessDefinition(processSummary);
        ((EventSourceMock)Mockito.verify(this.processDefSelectionEvent)).fire(Mockito.any(ProcessDefSelectionEvent.class));
        ArgumentCaptor argument = ArgumentCaptor.forClass(ProcessDefSelectionEvent.class);
        ((EventSourceMock)Mockito.verify(this.processDefSelectionEvent)).fire(argument.capture());
        ProcessDefSelectionEvent event = (ProcessDefSelectionEvent)argument.getValue();
        Assert.assertEquals((Object)processSummary.getProcessDefName(), (Object)event.getProcessDefName());
        Assert.assertEquals((Object)processSummary.getDeploymentId(), (Object)event.getDeploymentId());
        Assert.assertEquals((Object)processSummary.getProcessDefId(), (Object)event.getProcessId());
        Assert.assertEquals((Object)processSummary.isDynamic(), (Object)event.isDynamic());
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)Constants.INSTANCE.ProcessDefinitionBreadcrumb(processSummary.getName())), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
    }

    @Test
    public void testProcessDefNameDefinitionOpenGenericForm() {
        String processDefName = "testProcessDefName";
        this.presenter.openGenericForm("processDefId", "deploymentId", processDefName, false);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ProcessDisplayerConfig.class);
        ((StartProcessFormDisplayProviderImpl)Mockito.verify((Object)this.startProcessDisplayProvider)).setup((ProcessDisplayerConfig)argument.capture(), (FormDisplayerView)Mockito.any());
        Assert.assertEquals((Object)processDefName, (Object)((ProcessDisplayerConfig)argument.getValue()).getProcessName());
    }

    @Test
    public void testGetData() {
        Mockito.when((Object)this.processRuntimeDataService.getProcesses(Mockito.anyString(), Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()), Mockito.anyString(), Boolean.valueOf(Mockito.anyBoolean()))).thenReturn(ProcessDefinitionListPresenterTest.getMockList(10)).thenReturn(ProcessDefinitionListPresenterTest.getMockList(1));
        Range range = new Range(0, 10);
        this.presenter.getData(range);
        ((ProcessDefinitionListPresenter)Mockito.verify((Object)this.presenter)).updateDataOnCallback(Mockito.anyList(), Mockito.eq((int)0), Mockito.eq((int)10), Mockito.eq((boolean)false));
        range = new Range(10, 10);
        this.presenter.getData(range);
        ((ProcessDefinitionListPresenter)Mockito.verify((Object)this.presenter)).updateDataOnCallback(Mockito.anyList(), Mockito.eq((int)10), Mockito.eq((int)11), Mockito.eq((boolean)true));
    }

    @Test
    public void testOnRuntimeDataServiceError() {
        Throwable throwable = (Throwable)Mockito.mock(Throwable.class);
        Assert.assertFalse((boolean)this.presenter.onRuntimeDataServiceError(throwable));
        ((ProcessDefinitionListPresenter)Mockito.verify((Object)this.presenter)).updateDataOnCallback(Collections.emptyList(), 0, 0, true);
        ((DefaultWorkbenchErrorCallback)Mockito.verify((Object)this.errorCallback)).error(throwable);
        ((ProcessDefinitionListPresenter.ProcessDefinitionListView)Mockito.verify((Object)this.view)).hideBusyIndicator();
    }

    @Test
    public void testListBreadcrumbCreation() {
        this.presenter.createListBreadcrumb();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Manage_Process_Definitions()), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.breadcrumbs});
    }

    @Test
    public void testSetupDetailBreadcrumb() {
        String detailLabel = "detailLabel";
        String detailScreenId = "screenId";
        PlaceManager placeManagerMock = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.presenter.setPlaceManager(placeManagerMock);
        this.presenter.setupDetailBreadcrumb(placeManagerMock, this.commonConstants.Manage_Process_Definitions(), detailLabel, detailScreenId);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)this.commonConstants.Manage_Process_Definitions()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).closePlace(detailScreenId);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Mockito.eq((Object)PERSPECTIVE_ID), (String)Mockito.eq((Object)detailLabel), (Command)Mockito.eq((Object)Commands.DO_NOTHING));
    }

    @Test
    public void testIsAuthorizedForView() {
        String perspectiveId = "ProcessInstances";
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertTrue((boolean)this.presenter.isUserAuthorizedForPerspective(perspectiveId));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ResourceRef.class);
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize((Resource)captor.capture(), (User)Mockito.eq((Object)this.identity));
        Assert.assertEquals((Object)perspectiveId, (Object)((ResourceRef)captor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.PERSPECTIVE, (Object)((ResourceRef)captor.getValue()).getResourceType());
        Assert.assertFalse((boolean)this.presenter.isUserAuthorizedForPerspective(perspectiveId));
    }

    @Test
    public void testViewProcessInstanceActionCondition() {
        ((AuthorizationManager)Mockito.doAnswer((Answer)new PerspectiveAnswer("ProcessInstances")).when((Object)this.authorizationManager)).authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity));
        Assert.assertTrue((boolean)this.presenter.getViewProcessInstanceActionCondition().test(new ProcessSummary()));
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.presenter.getViewProcessInstanceActionCondition().test(new ProcessSummary()));
    }

    @Test
    public void testViewProcessInstances() {
        String processDefinition = "procDef";
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Mockito.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        this.presenter.viewProcessInstances(processDefinition);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)"ProcessInstances", (Object)((PlaceRequest)captor.getValue()).getIdentifier());
        Assert.assertEquals((long)1L, (long)((PlaceRequest)captor.getValue()).getParameters().size());
        Assert.assertEquals((Object)processDefinition, ((PlaceRequest)captor.getValue()).getParameters().get("processDefinitionId"));
    }

    protected class PerspectiveAnswer
    implements Answer<Boolean> {
        private String perspectiveId;

        public PerspectiveAnswer(String perspectiveId) {
            this.perspectiveId = perspectiveId;
        }

        public Boolean answer(InvocationOnMock invocation) throws Throwable {
            return this.perspectiveId.equals(((ResourceRef)invocation.getArguments()[0]).getIdentifier());
        }
    }
}

