/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.ConditionalKebabActionCell;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListPresenter;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessDefinitionListViewTest {
    @Mock
    ExtendedPagedTable currentListGrid;
    @Mock
    ManagedInstance<ConditionalKebabActionCell> conditionalKebabActionCell;
    @Mock
    ManagePreferences preferences;
    CallerMock<UserPreferencesService> userPreferencesService;
    @Mock
    UserPreferencesService userPreferencesServiceMock;
    @Mock
    ProcessDefinitionListPresenter presenter;
    @InjectMocks
    @Spy
    ProcessDefinitionListViewImpl view;

    @Before
    public void setup() {
        Mockito.when((Object)this.conditionalKebabActionCell.get()).thenReturn(Mockito.mock(ConditionalKebabActionCell.class));
        this.userPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.view.setPreferencesService(this.userPreferencesService);
        ((ProcessDefinitionListViewImpl)Mockito.doNothing().when((Object)this.view)).addNewTableToColumn((ExtendedPagedTable)Mockito.any());
    }

    @Test
    public void testDataStoreNameIsSet() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when((Object)this.currentListGrid)).addColumns(Mockito.anyList());
        Mockito.when((Object)this.currentListGrid.getColumnSortList()).thenReturn((Object)new ColumnSortList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testGlobalPreferences() {
        ((ManagePreferences)Mockito.doAnswer(inv -> {
            ((ParameterizedCommand)inv.getArguments()[0]).execute((Object)new ManagePreferences().defaultValue(new ManagePreferences()));
            return null;
        }).when((Object)this.preferences)).load((ParameterizedCommand)Mockito.any(ParameterizedCommand.class), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        this.view.init(this.presenter);
        ArgumentCaptor captor = ArgumentCaptor.forClass(GridGlobalPreferences.class);
        ((ProcessDefinitionListViewImpl)Mockito.verify((Object)this.view)).createListGrid((GridGlobalPreferences)captor.capture());
        Assert.assertNotNull((Object)captor.getValue());
        Assert.assertEquals((long)ManagePreferences.DEFAULT_PAGINATION_OPTION.intValue(), (long)((GridGlobalPreferences)captor.getValue()).getPageSize());
    }
}

