/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.common.collect.Sets;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.data.Index;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.AbstractMultiGridViewTest;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.client.util.GenericErrorSummaryCountCell;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListViewImpl;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceListViewImplTest
extends AbstractMultiGridViewTest<ProcessInstanceSummary> {
    @Mock
    private ProcessInstanceListPresenter presenter;
    @Spy
    private GenericErrorSummaryCountCell cellMock;
    @Mock
    private ManagedInstance<GenericErrorSummaryCountCell> popoverCellInstance;
    @Mock
    private ConfirmPopup confirmPopup;
    @GwtMock
    private AnchorListItem anchorListItem;
    @InjectMocks
    @Spy
    private ProcessInstanceListViewImpl view;

    protected AbstractMultiGridView getView() {
        return this.view;
    }

    protected AbstractMultiGridPresenter getPresenter() {
        return this.presenter;
    }

    public List<String> getExpectedInitialColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "processVersion", "lastModificationDate", "errorCount", "Actions");
    }

    public List<String> getExpectedBannedColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "Actions");
    }

    public Integer getExpectedNumberOfColumns() {
        return 14;
    }

    @Before
    public void setupMocks() {
        super.setupMocks();
        Mockito.when((Object)this.popoverCellInstance.get()).thenReturn((Object)this.cellMock);
    }

    @Test
    public void testSignalCommand() {
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getSignalCommand(table).execute();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkSignal((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }

    @Test
    public void testBulkSignal() {
        ((AnchorListItem)Mockito.doAnswer(invocation -> {
            ClickHandler handler = (ClickHandler)invocation.getArguments()[0];
            handler.onClick((ClickEvent)Mockito.mock(ClickEvent.class));
            return null;
        }).when((Object)this.anchorListItem)).addClickHandler((ClickHandler)Mockito.any());
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getBulkSignal(table);
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkSignal((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }

    @Test
    public void testBulkAbort() {
        ((AnchorListItem)Mockito.doAnswer(invocation -> {
            ClickHandler handler = (ClickHandler)invocation.getArguments()[0];
            handler.onClick((ClickEvent)Mockito.mock(ClickEvent.class));
            return null;
        }).when((Object)this.anchorListItem)).addClickHandler((ClickHandler)Mockito.any());
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getBulkAbort(table);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Command.class);
        ((ConfirmPopup)Mockito.verify((Object)this.confirmPopup)).show((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (Command)captor.capture());
        ((Command)captor.getValue()).execute();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkAbort((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }

    @Test
    public void testAbortCommand() {
        ExtendedPagedTable table = (ExtendedPagedTable)Mockito.mock(ExtendedPagedTable.class);
        this.view.getAbortCommand(table).execute();
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).bulkAbort((List)Mockito.any());
        ((ExtendedPagedTable)Mockito.verify((Object)table)).deselectAllItems();
    }

    @Test
    public void addDomainSpecifColumnsTest() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)currentListGrid);
        HashSet<String> domainColumns = new HashSet<String>(Arrays.asList("var1", "var2", "var3"));
        this.getView().addDomainSpecifColumns(domainColumns);
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((ListTable)Mockito.verify((Object)currentListGrid, (VerificationMode)Mockito.times((int)3))).addColumns((List)argument.capture());
        List columnsList = argument.getAllValues();
        Assertions.assertThat((int)columnsList.size()).isEqualTo(3);
        Assertions.assertThat(columnsList.stream()).extracting(columns -> ((ColumnMeta)columns.get(0)).getCaption()).contains((Object)"var3", Index.atIndex((int)0)).contains((Object)"var2", Index.atIndex((int)1)).contains((Object)"var1", Index.atIndex((int)2));
    }

    @Test
    public void testRenameProcessVariableForInitColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        List gridColumnPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        gridColumnPreferenceList.add(new GridColumnPreference("Name", Integer.valueOf(-1), ""));
        gridColumnPreferenceList.add(new GridColumnPreference("Id", Integer.valueOf(-1), ""));
        gridColumnPreferenceList.add(new GridColumnPreference("performance", Integer.valueOf(-1), ""));
        ColumnMeta checkColumnMeta = this.view.initChecksColumn(extendedPagedTable);
        ColumnMeta actionsColumnMeta = this.view.initActionsColumn();
        Column errorCountColumn = this.view.initErrorCountColumn();
        extendedPagedTable.addSelectionIgnoreColumn(checkColumnMeta.getColumn());
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        extendedPagedTable.addSelectionIgnoreColumn(errorCountColumn);
        Column startColumn = this.view.createTextColumn("start_date", process -> DateUtils.getDateTimeStr((Date)process.getStartTime()));
        List columnMetas = this.view.getGeneralColumnMetas(extendedPagedTable, startColumn, checkColumnMeta, actionsColumnMeta, errorCountColumn);
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat(columnMetas.stream()).extracting(columnMeta -> columnMeta.getCaption()).hasSize(14)).doesNotContain((Object[])new String[]{"Var_Name"})).doesNotContain((Object[])new String[]{"Var_Id"});
        columnMetas.addAll(this.view.renameVariables(extendedPagedTable, columnMetas));
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat(columnMetas.stream()).extracting(columnMeta -> columnMeta.getCaption()).hasSize(17)).containsOnlyOnce((Object[])new String[]{"Var_Name"})).containsOnlyOnce((Object[])new String[]{"Var_Id"});
    }

    @Test
    public void testRenameProcessVariableForAddDomainSpecifColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)extendedPagedTable);
        Set<String> set = Collections.singleton("Version");
        this.view.initColumns(extendedPagedTable);
        ((AbstractListAssert)Assertions.assertThat((Iterable)extendedPagedTable.getColumnMetaList()).extracting(columnMeta -> columnMeta.getCaption()).hasSize(14)).doesNotContain((Object[])new String[]{"Var_Version"});
        this.view.addDomainSpecifColumns(set);
        ((AbstractListAssert)Assertions.assertThat((Iterable)extendedPagedTable.getColumnMetaList()).extracting(columnMeta -> columnMeta.getCaption()).hasSize(15)).containsOnlyOnce((Object[])new String[]{"Var_Version"});
    }

    @Test
    public void testRemoveColumnMetaFromColumnsForAddDomainSpecifColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)extendedPagedTable);
        extendedPagedTable.getGridPreferencesStore().getColumnPreferences().add(new GridColumnPreference("Extra", Integer.valueOf(-1), ""));
        HashSet set = Sets.newHashSet((Object[])new String[]{"Extra"});
        this.view.initColumns(extendedPagedTable);
        Assertions.assertThat((int)extendedPagedTable.getColumnMetaList().size()).isEqualTo(15);
        this.view.addDomainSpecifColumns((Set)set);
        Assertions.assertThat((int)set.size()).isEqualTo(0);
    }

    @Test
    public void testRemoveColumnMetaFromExtendedPagedTableForAddDomainSpecifColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)extendedPagedTable);
        extendedPagedTable.getGridPreferencesStore().getColumnPreferences().add(new GridColumnPreference("Extra", Integer.valueOf(-1), ""));
        Column column = this.view.createTextColumn("Extra", process -> process.getDeploymentId());
        Set<String> set = Collections.singleton("Extra_test");
        this.view.initColumns(extendedPagedTable);
        ((IterableAssert)Assertions.assertThat((Iterable)extendedPagedTable.getColumnMetaList()).hasSize(15)).extracting(columnMeta -> columnMeta.getCaption()).containsOnlyOnce((Object[])new String[]{"Extra"});
        this.view.addDomainSpecifColumns(set);
        ((AbstractListAssert)((IterableAssert)Assertions.assertThat((Iterable)extendedPagedTable.getColumnMetaList()).hasSize(15)).extracting(columnMeta -> columnMeta.getCaption()).doesNotContain((Object[])new String[]{"Extra"})).containsOnlyOnce((Object[])new String[]{"Extra_test"});
        Assertions.assertThat((int)set.size()).isEqualTo(1);
    }

    @Test
    public void removeDomainSpecifColumnsTest() {
        ListTable listGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ColumnMeta columnToRemove = new ColumnMeta(ProcessInstanceListViewImplTest.newColumnMock((String)"c1"), "", true, true);
        listGrid.getColumnMetaList().add(columnToRemove);
        listGrid.getColumnMetaList().add(new ColumnMeta(ProcessInstanceListViewImplTest.newColumnMock((String)"c2"), "", false, true));
        listGrid.getColumnMetaList().add(new ColumnMeta(ProcessInstanceListViewImplTest.newColumnMock((String)"c3"), "", true, false));
        listGrid.getColumnMetaList().add(new ColumnMeta(ProcessInstanceListViewImplTest.newColumnMock((String)"c4"), "", false, false));
        listGrid.getGridPreferencesStore().setPreferenceKey("key");
        Mockito.when((Object)this.getView().getListGrid()).thenReturn((Object)listGrid);
        ((ListTable)Mockito.doNothing().when((Object)listGrid)).removeColumnMeta((ColumnMeta)Mockito.any());
        GridPreferencesStore store = new GridPreferencesStore(new GridGlobalPreferences());
        store.getColumnPreferences().add(new GridColumnPreference("c3", Integer.valueOf(0), ""));
        store.getColumnPreferences().add(new GridColumnPreference("c1", Integer.valueOf(1), ""));
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences(listGrid.getGridPreferencesStore().getPreferenceKey(), UserPreferencesType.GRIDPREFERENCES)).thenReturn((Object)store);
        this.getView().removeDomainSpecifColumns();
        Assert.assertEquals((long)1L, (long)store.getColumnPreferences().size());
        Assert.assertEquals((Object)"c3", (Object)((GridColumnPreference)store.getColumnPreferences().get(0)).getName());
        ((ListTable)Mockito.verify((Object)listGrid)).removeColumnMeta(columnToRemove);
        ((ListTable)Mockito.verify((Object)listGrid)).saveGridPreferences();
    }
}

