/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.diagram;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetView;
import org.jbpm.workbench.pr.client.editors.diagram.ZoomControlView;
import org.jbpm.workbench.pr.events.ProcessDiagramExpandEvent;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.views.pfly.widgets.D3;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@Dependent
@Templated
public class ProcessDiagramWidgetViewImpl
extends Composite
implements ProcessDiagramWidgetView,
RequiresResize {
    @Inject
    @DataField(value="processDiagramDiv")
    private HTMLDivElement processDiagramDiv;
    @Inject
    @DataField(value="diagramContainerDiv")
    private HTMLDivElement diagramContainerDiv;
    @Inject
    @DataField(value="message")
    @Named(value="span")
    private HTMLElement heading;
    @Inject
    @DataField
    private HTMLDivElement alert;
    @Inject
    @DataField(value="expand-diagram")
    private Anchor expandAnchor;
    @Inject
    private ZoomControlView zoomControlView;
    @Inject
    private Event<ProcessDiagramExpandEvent> processDiagramExpandEvent;
    private Callback<String> nodeSelectionCallback;
    private Callback<String> nodeSelectionDoubleClick;
    private D3 d3;
    private boolean isExpand = false;
    boolean isDoubleClick;

    public void setD3Component(D3 d3) {
        this.d3 = d3;
    }

    @PostConstruct
    public void init() {
        this.d3 = D3.Builder.get();
        this.expandAnchor.setIcon(IconType.EXPAND);
        this.isDoubleClick = false;
    }

    @Override
    public void setOnDiagramNodeSelectionCallback(Callback<String> callback) {
        this.nodeSelectionCallback = callback;
    }

    @Override
    public void setOnNodeSelectionDoubleClick(Callback<String> callback) {
        this.nodeSelectionDoubleClick = callback;
    }

    @Override
    public void displayImage(String svgContent) {
        this.processDiagramDiv.innerHTML = svgContent;
        D3.Selection svg = this.d3.select("#processDiagramDiv svg");
        String[] viewBoxValues = svg.attr("viewBox").toString().split(" ");
        double svgWidth = Double.parseDouble(viewBoxValues[2]);
        double svgHeight = Double.parseDouble(viewBoxValues[3]);
        svg.attr("width", (Object)svgWidth);
        svg.attr("height", (Object)svgHeight);
        D3.Zoom zoom = this.d3.zoom();
        double[] scaleExtent = new double[]{0.1, 3.0};
        zoom.scaleExtent(scaleExtent);
        D3.CallbackFunction callback = () -> this.lambda$displayImage$0(svgWidth, svgHeight, zoom, (D3)svg);
        svg.call(zoom.on("zoom", callback), new Object[0]);
        this.zoomControlView.setScaleTo100Command(() -> this.lambda$displayImage$1(zoom, (D3)svg));
        this.zoomControlView.setScaleTo300Command(() -> ProcessDiagramWidgetViewImpl.lambda$displayImage$2(zoom, (D3)svg));
        this.zoomControlView.setScaleTo150Command(() -> ProcessDiagramWidgetViewImpl.lambda$displayImage$3(zoom, (D3)svg));
        this.zoomControlView.setScaleTo50Command(() -> ProcessDiagramWidgetViewImpl.lambda$displayImage$4(zoom, (D3)svg));
        this.zoomControlView.setScaleMinusCommand(() -> ProcessDiagramWidgetViewImpl.lambda$displayImage$5(zoom, (D3)svg));
        this.zoomControlView.setScalePlusCommand(() -> ProcessDiagramWidgetViewImpl.lambda$displayImage$6(zoom, (D3)svg));
        this.processDiagramDiv.appendChild((Node)this.zoomControlView.getElement());
        if (this.nodeSelectionCallback == null) {
            return;
        }
        D3.Selection selectAll = this.select();
        this.d3.select("svg").on("dblclick.zoom", () -> {});
        selectAll.on("mouseenter", () -> {
            Object target = D3.Builder.get().getEvent().getCurrentTarget();
            D3.Selection node = this.d3.select(target);
            node.style("cursor", (Object)"pointer");
            node.attr("opacity", (Object)0.7);
        });
        selectAll.on("mouseleave", () -> {
            Object target = D3.Builder.get().getEvent().getCurrentTarget();
            D3.Selection node = this.d3.select(target);
            node.style("cursor", (Object)"default");
            node.attr("opacity", (Object)1);
        });
        DoubleClickTimer timer = new DoubleClickTimer();
        selectAll.on("click", () -> {
            this.isDoubleClick = false;
            Object target = D3.Builder.get().getEvent().getCurrentTarget();
            D3.Selection node = this.d3.select(target);
            timer.setTarget((D3)node);
            timer.schedule(50);
        });
        selectAll.on("dblclick", () -> {
            this.isDoubleClick = true;
            timer.cancel();
            Object target = D3.Builder.get().getEvent().getCurrentTarget();
            D3.Selection node = this.d3.select(target);
            this.nodeSelectionDoubleClick.callback((Object)((String)node.attr("bpmn2nodeid")));
        });
    }

    protected native D3.Selection select();

    private void refreshExtent(D3.Zoom zoom, double minX, double minY, double maxX, double maxY) {
        double[][] translateExtent = new double[2][2];
        translateExtent[0][0] = minX;
        translateExtent[0][1] = minY;
        translateExtent[1][0] = maxX;
        translateExtent[1][1] = maxY;
        zoom.translateExtent(translateExtent);
    }

    @Override
    public void displayMessage(String message) {
        this.alert.classList.remove(new String[]{"hidden"});
        this.heading.textContent = message;
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight();
        int width = this.getParent().getOffsetWidth();
        this.setPixelSize(width, height);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public void expandDiagramContainer() {
        this.diagramContainerDiv.classList.remove(new String[]{"col-md-10"});
        this.diagramContainerDiv.classList.add(new String[]{"col-md-12"});
        this.isExpand = true;
    }

    @EventHandler(value={"expand-diagram"})
    protected void onClickExpandDiagram(ClickEvent event) {
        if (this.isExpand) {
            this.diagramContainerDiv.classList.add(new String[]{"col-md-10"});
            this.diagramContainerDiv.classList.remove(new String[]{"col-md-12"});
            this.isExpand = false;
            this.expandAnchor.setIcon(IconType.EXPAND);
        } else {
            this.expandDiagramContainer();
            this.isExpand = true;
            this.expandAnchor.setIcon(IconType.COMPRESS);
        }
        this.processDiagramExpandEvent.fire((Object)new ProcessDiagramExpandEvent(this.isExpand));
    }

    @Override
    public void disableExpandAnchor() {
        this.expandAnchor.setEnabled(false);
    }

    private static /* synthetic */ void lambda$displayImage$6(D3.Zoom zoom, D3 svg) {
        zoom.scaleBy(svg.transition().duration(200.0), 1.05);
    }

    private static /* synthetic */ void lambda$displayImage$5(D3.Zoom zoom, D3 svg) {
        zoom.scaleBy(svg.transition().duration(200.0), 0.95);
    }

    private static /* synthetic */ void lambda$displayImage$4(D3.Zoom zoom, D3 svg) {
        zoom.scaleTo(svg.transition().duration(500.0), 0.5);
    }

    private static /* synthetic */ void lambda$displayImage$3(D3.Zoom zoom, D3 svg) {
        zoom.scaleTo(svg.transition().duration(500.0), 1.5);
    }

    private static /* synthetic */ void lambda$displayImage$2(D3.Zoom zoom, D3 svg) {
        zoom.scaleTo(svg.transition().duration(500.0), 3.0);
    }

    private /* synthetic */ void lambda$displayImage$1(D3.Zoom zoom, D3 svg) {
        zoom.transform(svg.transition().duration(500.0), this.d3.getZoomIdentity());
    }

    private /* synthetic */ void lambda$displayImage$0(double svgWidth, double svgHeight, D3.Zoom zoom, D3 svg) {
        D3.ZoomEvent event = (D3.ZoomEvent)this.d3.getEvent();
        double k = event.getTransform().getK();
        event.getTransform().setX((svgWidth * k - svgWidth) / 2.0);
        event.getTransform().setY((svgHeight * k - svgHeight) / 2.0);
        this.refreshExtent(zoom, 0.0, 0.0, svgWidth * k, svgHeight * k);
        svg.attr("transform", (Object)event.getTransform());
        this.zoomControlView.disablePlusButton(k >= 3.0);
        this.zoomControlView.disableMinusButton(k <= 0.1);
        double zoomTxt = Math.round(100.0 + (event.getTransform().getK() - 1.0) * 100.0);
        this.zoomControlView.setZoomText(zoomTxt + "%");
    }

    private class DoubleClickTimer
    extends Timer {
        public D3 node;

        private DoubleClickTimer() {
        }

        public void setTarget(D3 node) {
            this.node = node;
        }

        public void run() {
            if (!ProcessDiagramWidgetViewImpl.this.isDoubleClick) {
                ProcessDiagramWidgetViewImpl.this.nodeSelectionCallback.callback((Object)((String)this.node.attr("bpmn2nodeid")));
            }
        }
    }
}

