/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.details.multi;

import javax.enterprise.event.Event;
import org.jbpm.workbench.pr.client.editors.definition.details.multi.BaseProcessDefDetailsMultiPresenter;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

public abstract class BaseProcessDefDetailsMultiPresenterTest<T extends BaseProcessDefDetailsMultiPresenter.BaseProcessDefDetailsMultiView> {
    @Mock
    protected EventSourceMock<ProcessDefSelectionEvent> processDefSelectionEvent = new EventSourceMock();
    @Mock
    PlaceManager placeManager;
    @Mock
    T view;
    @Spy
    Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock();

    public abstract BaseProcessDefDetailsMultiPresenter getPresenter();

    @Before
    public void setup() {
        ((Event)Mockito.doNothing().when(this.changeTitleWidgetEvent)).fire(Mockito.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void testViewInstance() {
        String process = "evaluation";
        this.getPresenter().onProcessSelectionEvent(new ProcessDefSelectionEvent("evaluation"));
        this.getPresenter().viewProcessInstances();
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        PlaceRequest request = (PlaceRequest)captor.getValue();
        Assert.assertEquals((Object)"ProcessInstances", (Object)request.getIdentifier());
        Assert.assertEquals((Object)"evaluation", (Object)request.getParameter("processDefinitionId", null));
    }

    @Test
    public void testProcessDefNameInChangeTitleEvent() {
        String processDefName = "testProcessDefName";
        String deploymentId = "testDeploymentId";
        ProcessDefSelectionEvent processDefSelectionEvent = new ProcessDefSelectionEvent();
        processDefSelectionEvent.setProcessDefName("testProcessDefName");
        processDefSelectionEvent.setDeploymentId("testDeploymentId");
        this.getPresenter().onProcessSelectionEvent(processDefSelectionEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(ChangeTitleWidgetEvent.class);
        ((Event)Mockito.verify(this.changeTitleWidgetEvent)).fire(argument.capture());
        Assert.assertEquals((Object)"testDeploymentId - testProcessDefName", (Object)((ChangeTitleWidgetEvent)argument.getValue()).getTitle());
    }
}

