/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.diagram;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.TakesValue;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;

@Dependent
@Templated(stylesheet="ProcessInstanceDiagram.css")
public class SubProcessInstanceItemView
implements TakesValue<ProcessInstanceSummary>,
IsElement {
    @Inject
    @DataField(value="list-group-item")
    private ListItem listItem;
    @Inject
    @DataField(value="sub-process-name-text")
    public Anchor subProcessNameAnchor;
    @Inject
    @AutoBound
    private DataBinder<ProcessInstanceSummary> processInstanceSummary;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceEvent;
    private Constants constants = Constants.INSTANCE;
    private ProcessInstanceKey processInstanceKey;

    public void setValue(ProcessInstanceSummary value) {
        this.subProcessNameAnchor.setText(this.constants.ProcessInstanceIdAndName(value.getProcessInstanceId().toString(), value.getProcessName()));
        this.processInstanceKey = new ProcessInstanceKey(value.getServerTemplateId(), value.getDeploymentId(), value.getProcessInstanceId());
    }

    public ProcessInstanceSummary getValue() {
        return (ProcessInstanceSummary)this.processInstanceSummary.getModel();
    }

    public HTMLElement getElement() {
        return this.listItem;
    }

    @EventHandler(value={"sub-process-name-text"})
    protected void onClickSubProcessInstanceId(ClickEvent event) {
        this.processInstanceEvent.fire((Object)new ProcessInstanceSelectionEvent(this.processInstanceKey, false, true));
    }
}

