/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.NodeInstanceSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.model.UserTaskSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;

@Dependent
public class ProcessInstanceDetailsPresenter {
    private String currentDeploymentId;
    private String currentProcessInstanceId;
    private String currentServerTemplateId;
    private ProcessInstanceDetailsView view;
    private Constants constants = Constants.INSTANCE;
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;

    @Inject
    public void setView(ProcessInstanceDetailsView view) {
        this.view = view;
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.currentDeploymentId = event.getDeploymentId();
        this.currentProcessInstanceId = String.valueOf(event.getProcessInstanceId());
        this.currentServerTemplateId = event.getServerTemplateId();
        this.refreshProcessInstanceDataRemote(this.currentDeploymentId, this.currentProcessInstanceId, this.currentServerTemplateId);
    }

    public void refreshProcessInstanceDataRemote(String deploymentId, String processId, String serverTemplateId) {
        this.view.getProcessDefinitionIdText().setText("");
        this.view.getProcessVersionText().setText("");
        this.view.getProcessDeploymentText().setText("");
        this.view.getCorrelationKeyText().setText("");
        this.view.getParentProcessInstanceIdText().setText("");
        this.view.getActiveTasksListBox().setText("");
        this.view.getStateText().setText("");
        this.view.getCurrentActivitiesListBox().setText("");
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<ProcessInstanceSummary>(){

            public void callback(ProcessInstanceSummary process) {
                ProcessInstanceDetailsPresenter.this.view.getProcessDefinitionIdText().setText(process.getProcessId());
                ProcessInstanceDetailsPresenter.this.view.getProcessVersionText().setText(process.getProcessVersion());
                ProcessInstanceDetailsPresenter.this.view.getProcessDeploymentText().setText(process.getDeploymentId());
                ProcessInstanceDetailsPresenter.this.view.getCorrelationKeyText().setText(process.getCorrelationKey());
                if (process.getParentId() > 0L) {
                    ProcessInstanceDetailsPresenter.this.view.getParentProcessInstanceIdText().setText(process.getParentId().toString());
                } else {
                    ProcessInstanceDetailsPresenter.this.view.getParentProcessInstanceIdText().setText(ProcessInstanceDetailsPresenter.this.constants.No_Parent_Process_Instance());
                }
                String statusStr = ProcessInstanceDetailsPresenter.this.constants.Unknown();
                switch (process.getState()) {
                    case 1: {
                        statusStr = ProcessInstanceDetailsPresenter.this.constants.Active();
                        break;
                    }
                    case 3: {
                        statusStr = ProcessInstanceDetailsPresenter.this.constants.Aborted();
                        break;
                    }
                    case 2: {
                        statusStr = ProcessInstanceDetailsPresenter.this.constants.Completed();
                        break;
                    }
                    case 0: {
                        statusStr = ProcessInstanceDetailsPresenter.this.constants.Pending();
                        break;
                    }
                    case 4: {
                        statusStr = ProcessInstanceDetailsPresenter.this.constants.Suspended();
                        break;
                    }
                }
                if (process.getActiveTasks() != null && !process.getActiveTasks().isEmpty()) {
                    SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                    for (UserTaskSummary uts : process.getActiveTasks()) {
                        safeHtmlBuilder.appendEscapedLines(uts.getName() + " (" + uts.getStatus() + ")  " + ProcessInstanceDetailsPresenter.this.constants.Owner() + ": " + uts.getOwner() + " \n");
                    }
                    ProcessInstanceDetailsPresenter.this.view.getActiveTasksListBox().setHTML(safeHtmlBuilder.toSafeHtml());
                }
                ProcessInstanceDetailsPresenter.this.view.getStateText().setText(statusStr);
            }
        })).getProcessInstance(serverTemplateId, new ProcessInstanceKey(serverTemplateId, deploymentId, Long.valueOf(Long.parseLong(processId))));
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<List<NodeInstanceSummary>>(){

            public void callback(List<NodeInstanceSummary> details) {
                SafeHtmlBuilder safeHtmlBuilder = new SafeHtmlBuilder();
                for (NodeInstanceSummary nis : details) {
                    safeHtmlBuilder.appendEscapedLines(nis.getTimestamp() + ": " + nis.getId() + " - " + nis.getNodeName() + " (" + nis.getType() + ") \n");
                }
                ProcessInstanceDetailsPresenter.this.view.getCurrentActivitiesListBox().setHTML(safeHtmlBuilder.toSafeHtml());
            }
        })).getProcessInstanceActiveNodes(serverTemplateId, deploymentId, Long.valueOf(Long.parseLong(processId)));
    }

    public static interface ProcessInstanceDetailsView
    extends IsWidget {
        public HTML getCurrentActivitiesListBox();

        public HTML getActiveTasksListBox();

        public HTML getProcessDefinitionIdText();

        public HTML getStateText();

        public HTML getProcessDeploymentText();

        public HTML getProcessVersionText();

        public HTML getCorrelationKeyText();

        public HTML getParentProcessInstanceIdText();
    }
}

