/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.html.Div;
import org.gwtbootstrap3.client.ui.html.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;

@Dependent
@Templated(value="RuntimeLogViewImpl.html")
public class RuntimeLogViewImpl
extends Composite
implements RuntimeLogPresenter.RuntimeLogView {
    @DataField
    public Div logTextArea = new Div();
    @Inject
    @DataField
    public Button showBusinessLogButton;
    @Inject
    @DataField
    public Button showTechnicalLogButton;
    @Inject
    @DataField
    public Button showAscLogButton;
    @Inject
    @DataField
    public Button showDescLogButton;
    private RuntimeLogPresenter presenter;
    private LogUtils.LogOrder logOrder = LogUtils.LogOrder.ASC;
    private LogUtils.LogType logType = LogUtils.LogType.BUSINESS;
    private Constants constants = Constants.INSTANCE;

    @Override
    public void init(RuntimeLogPresenter presenter) {
        this.presenter = presenter;
        this.setFilters(this.showBusinessLogButton, this.constants.Business_Log(), LogUtils.LogType.BUSINESS);
        this.setFilters(this.showTechnicalLogButton, this.constants.Technical_Log(), LogUtils.LogType.TECHNICAL);
        this.setOrder(this.showAscLogButton, this.constants.Asc_Log_Order(), LogUtils.LogOrder.ASC);
        this.setOrder(this.showDescLogButton, this.constants.Desc_Log_Order(), LogUtils.LogOrder.DESC);
    }

    private void setFilters(Button button, String description, final LogUtils.LogType logType) {
        button.setText(description);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuntimeLogViewImpl.this.setActiveLogTypeButton(logType);
                RuntimeLogViewImpl.this.getInstanceData();
            }
        });
    }

    private void setOrder(Button button, String description, final LogUtils.LogOrder logOrder) {
        button.setText(description);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RuntimeLogViewImpl.this.setActiveLogOrderButton(logOrder);
                RuntimeLogViewImpl.this.getInstanceData();
            }
        });
    }

    public void getInstanceData() {
        this.presenter.refreshProcessInstanceData(this.logOrder, this.logType);
    }

    @Override
    public void setLogs(List<String> logs) {
        this.logTextArea.clear();
        UnorderedList list = new UnorderedList(){
            {
                this.addStyleName("list-unstyled");
            }
        };
        for (String log : logs) {
            list.add((Widget)new ListItem(log));
        }
        this.logTextArea.add((Widget)list);
    }

    public void setActiveLogTypeButton(LogUtils.LogType logType) {
        this.logType = logType;
        switch (logType) {
            case TECHNICAL: {
                this.showTechnicalLogButton.setActive(true);
                this.showBusinessLogButton.setActive(false);
                break;
            }
            case BUSINESS: {
                this.showBusinessLogButton.setActive(true);
                this.showTechnicalLogButton.setActive(false);
            }
        }
    }

    public void setActiveLogOrderButton(LogUtils.LogOrder logOrder) {
        this.logOrder = logOrder;
        switch (logOrder) {
            case ASC: {
                this.showAscLogButton.setActive(true);
                this.showDescLogButton.setActive(false);
                break;
            }
            case DESC: {
                this.showDescLogButton.setActive(true);
                this.showAscLogButton.setActive(false);
            }
        }
    }
}

