/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.diagram;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramPresenter;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramWidgetViewImpl;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.service.ProcessImageService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessDiagramPresenterTest {
    @Mock
    ProcessImageService imageService;
    @Mock
    ProcessDiagramWidgetViewImpl view;
    @InjectMocks
    ProcessDiagramPresenter presenter;

    @Before
    public void setup() {
        this.presenter.setProcessImageService((Caller)new CallerMock((Object)this.imageService));
    }

    @Test
    public void testEmptyProcessDiagram() {
        Mockito.when((Object)this.imageService.getProcessDiagram((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)"", null);
        this.presenter.onProcessSelectionEvent(new ProcessDefSelectionEvent());
        this.presenter.onProcessSelectionEvent(new ProcessDefSelectionEvent());
        ((ProcessDiagramWidgetViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).displayMessage(Constants.INSTANCE.Process_Diagram_Not_FoundContainerShouldBeAvailable(Mockito.anyString()));
    }

    @Test
    public void testProcessDiagram() {
        String svgContent = "<svg></svg>";
        Mockito.when((Object)this.imageService.getProcessDiagram((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any())).thenReturn((Object)"<svg></svg>");
        this.presenter.onProcessSelectionEvent(new ProcessDefSelectionEvent());
        ((ProcessDiagramWidgetViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).displayMessage(Constants.INSTANCE.Process_Diagram_Not_FoundContainerShouldBeAvailable(Mockito.anyString()));
        ((ProcessDiagramWidgetViewImpl)Mockito.verify((Object)this.view)).displayImage("<svg></svg>");
    }
}

