/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.dom.client.Document;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogItemDetailsView;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogItemView;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceLogItemViewTest {
    @Mock
    private MouseEvent mouseEvent;
    @Mock
    private ProcessInstanceLogPresenter presenter;
    @Mock
    private Constants constants;
    @Mock
    private Span logTime;
    @Mock
    protected Span logInfo;
    @Mock
    protected Span logIcon;
    @Mock
    protected Span logTypeDesc;
    @Mock
    private Div detailsPanelDiv;
    @Mock
    private Anchor detailsLink;
    @Mock
    private Div detailsInfoDiv;
    @Mock
    private TranslationService translationService;
    @Mock
    private DataBinder<ProcessInstanceLogSummary> logSummary;
    @Mock
    private ProcessInstanceLogItemDetailsView workItemView;
    @InjectMocks
    private ProcessInstanceLogItemView view;
    private static final Date date = Date.from(LocalDateTime.of(2018, 12, 12, 11, 55, 57).atZone(ZoneId.of("GMT+1")).toInstant());

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.constants.Human_Task()).thenReturn((Object)"Human task");
        Mockito.when((Object)this.constants.System_Task()).thenReturn((Object)"System task");
        Mockito.when((Object)this.constants.NodeWasLeft((String)Matchers.any())).then(i -> "(" + (String)i.getArgument(0, String.class) + ") node was COMPLETED");
        Mockito.when((Object)this.constants.NodeWasEntered((String)Matchers.any())).then(i -> "(" + (String)i.getArgument(0, String.class) + ") node was ENTERED");
        Mockito.when((Object)this.constants.Task_((String)Matchers.any())).then(i -> "Task '" + (String)i.getArgument(0, String.class) + "'");
        Mockito.when((Object)this.constants.Human()).thenReturn((Object)"Human");
        Mockito.when((Object)this.constants.System()).thenReturn((Object)"System");
        Mockito.when((Object)this.translationService.format((String)Matchers.any(), new Object[0])).then(i -> (String)i.getArgument(0, String.class));
        Mockito.when((Object)Document.get().createUniqueId()).thenReturn((Object)"123");
    }

    @Test
    public void testCompletedHumanTask() {
        ProcessInstanceLogSummary model = this.createModel("HumanTaskNode", "userTask", true, true);
        this.view.setValue(model);
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Human task");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-user kie-timeline-icon--completed");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("(Human) node was COMPLETED");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task 'userTask'");
        ((Div)Mockito.verify((Object)this.detailsPanelDiv)).setHidden(false);
        this.verifyHumanTaskDetails(model);
    }

    @Test
    public void testNotCompletedHumanTask() {
        ProcessInstanceLogSummary model = this.createModel("HumanTaskNode", "userTask", false, true);
        this.view.setValue(model);
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Human task");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-user");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("(Human) node was ENTERED");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("Task 'userTask'");
        ((Div)Mockito.verify((Object)this.detailsPanelDiv)).setHidden(false);
        this.verifyHumanTaskDetails(model);
    }

    @Test
    public void testCompletedWorkItemNode() {
        ProcessInstanceLogSummary model = this.createModel("WorkItemNode", "workItemTask", true, true);
        this.view.setValue(model);
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "System task");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-cogs kie-timeline-icon--completed");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("(System) node was COMPLETED");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("WorkItemNode 'workItemTask' ");
        ((Div)Mockito.verify((Object)this.detailsPanelDiv)).setHidden(false);
        this.verifySystemTaskDetails(model);
    }

    @Test
    public void testNotCompletedWorkItemNode() {
        ProcessInstanceLogSummary model = this.createModel("WorkItemNode", "workItemTask", false, true);
        this.view.setValue(model);
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "System task");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-cogs");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("(System) node was ENTERED");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("WorkItemNode 'workItemTask' ");
        ((Div)Mockito.verify((Object)this.detailsPanelDiv)).setHidden(false);
        this.verifySystemTaskDetails(model);
    }

    @Test
    public void testCompletedStartNode() {
        ProcessInstanceLogSummary model = this.createModel("StartNode", "startNode", true, false);
        this.view.setValue(model);
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "System task");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-cogs kie-timeline-icon--completed");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("(System) node was COMPLETED");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("StartNode 'startNode' ");
        ((Div)Mockito.verify((Object)this.detailsPanelDiv)).setHidden(true);
        this.verifyNoDetails(model);
    }

    @Test
    public void testNotCompletedStartNode() {
        ProcessInstanceLogSummary model = this.createModel("StartNode", "startNode", false, false);
        this.view.setValue(model);
        ((Span)Mockito.verify((Object)this.logIcon)).setAttribute("data-original-title", "Human task");
        ((Span)Mockito.verify((Object)this.logIcon)).setClassName("list-view-pf-icon-sm kie-timeline-list-view-pf-icon-sm fa fa-user");
        ((Span)Mockito.verify((Object)this.logInfo)).setTextContent("(Human) node was ENTERED");
        ((Span)Mockito.verify((Object)this.logTypeDesc)).setTextContent("StartNode 'startNode' ");
        ((Div)Mockito.verify((Object)this.detailsPanelDiv)).setHidden(true);
        this.verifyNoDetails(model);
    }

    private static Date createDate(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return Date.from(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second).atZone(ZoneId.systemDefault()).toInstant());
    }

    private ProcessInstanceLogSummary createModel(String nodeType, String name, boolean completed, boolean hasWorkItem) {
        Long workItemId = hasWorkItem ? Long.valueOf(2L) : null;
        return ProcessInstanceLogSummary.builder().id(Long.valueOf(1L)).name(name).date(date).nodeId("2").workItemId(workItemId).nodeType(nodeType).completed(completed).nodeContainerId("userTask").logDeploymentId("_5CEF0690-F864-4E0D-B03B-0E3288172D5D").build();
    }

    private void verifyHumanTaskDetails(ProcessInstanceLogSummary model) {
        ((Anchor)Mockito.verify((Object)this.detailsLink)).setAttribute("href", "#123");
        ((Div)Mockito.verify((Object)this.detailsInfoDiv)).setId("123");
        Mockito.when((Object)this.logSummary.getModel()).thenReturn((Object)model);
        Mockito.when((Object)this.detailsInfoDiv.hasChildNodes()).thenReturn((Object)false);
        this.view.loadProcessInstanceLogsDetails(this.mouseEvent);
        ((ProcessInstanceLogPresenter)Mockito.verify((Object)this.presenter)).loadTaskDetails(Long.valueOf(2L), date, this.workItemView);
    }

    private void verifySystemTaskDetails(ProcessInstanceLogSummary model) {
        ((Anchor)Mockito.verify((Object)this.detailsLink)).setAttribute("href", "#123");
        ((Div)Mockito.verify((Object)this.detailsInfoDiv)).setId("123");
        Mockito.when((Object)this.logSummary.getModel()).thenReturn((Object)model);
        Mockito.when((Object)this.detailsInfoDiv.hasChildNodes()).thenReturn((Object)false);
        this.view.loadProcessInstanceLogsDetails(this.mouseEvent);
        ((ProcessInstanceLogPresenter)Mockito.verify((Object)this.presenter)).loadWorkItemDetails(model.getWorkItemId(), this.workItemView);
    }

    private void verifyNoDetails(ProcessInstanceLogSummary model) {
        ((Anchor)Mockito.verify((Object)this.detailsLink, (VerificationMode)Mockito.never())).setAttribute("href", "#11544612157000");
        ((Div)Mockito.verify((Object)this.detailsInfoDiv, (VerificationMode)Mockito.never())).setId("11544612157000");
        Mockito.when((Object)this.logSummary.getModel()).thenReturn((Object)model);
        Mockito.when((Object)this.detailsInfoDiv.hasChildNodes()).thenReturn((Object)false);
        this.view.loadProcessInstanceLogsDetails(this.mouseEvent);
        ((ProcessInstanceLogPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).loadTaskDetails(Long.valueOf(2L), date, this.workItemView);
        ((ProcessInstanceLogPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).loadWorkItemDetails(model.getWorkItemId(), this.workItemView);
    }
}

