/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details.multi;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jbpm.workbench.pr.client.editors.instance.details.multi.ProcessInstanceDetailsMultiPresenter;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.service.ProcessService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDetailsMultiPresenterTest {
    private static final Long PI_ID = 1L;
    private static final String SERVER_TEMPLATE_ID = "serverTemplateIdTest";
    private static final String PI_DEPLOYMENT_ID = "deploymentIdTest";
    private static final String PI_PROCESS_DEF_ID = "processDefIdTest";
    private static final String PI_PROCESS_DEF_NAME = "processDefNameTest";
    @Mock
    public ProcessInstanceDetailsMultiPresenter.ProcessInstanceDetailsMultiView view;
    @Mock
    ConfirmPopup confirmPopup;
    @Spy
    Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent = new EventSourceMock();
    @Spy
    Event<ProcessInstanceSelectionEvent> processInstanceSelected = new EventSourceMock();
    @Spy
    Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock();
    private CallerMock<ProcessService> remoteProcessServiceCaller;
    @Mock
    private ProcessService processService;
    @InjectMocks
    private ProcessInstanceDetailsMultiPresenter presenter;

    @Before
    public void setupMocks() {
        ((Event)Mockito.doNothing().when(this.changeTitleWidgetEvent)).fire(Mockito.any(ChangeTitleWidgetEvent.class));
        ((Event)Mockito.doNothing().when(this.processInstanceSelected)).fire(Mockito.any(ProcessInstanceSelectionEvent.class));
        ((Event)Mockito.doNothing().when(this.processInstancesUpdatedEvent)).fire(Mockito.any(ProcessInstancesUpdateEvent.class));
    }

    @Test
    public void isForLogRemainsEnabledAfterRefresh() {
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), true, SERVER_TEMPLATE_ID));
        ((ProcessInstanceDetailsMultiPresenter.ProcessInstanceDetailsMultiView)Mockito.verify((Object)this.view)).displayOnlyLogTab();
        Assert.assertTrue((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertTrue((boolean)this.presenter.isForLog());
    }

    @Test
    public void isForLogRemainsDisabledAfterRefresh() {
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), false, SERVER_TEMPLATE_ID));
        ((ProcessInstanceDetailsMultiPresenter.ProcessInstanceDetailsMultiView)Mockito.verify((Object)this.view)).displayAllTabs();
        Assert.assertFalse((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForLog());
    }

    @Test
    public void confirmPopupTest() {
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), true, SERVER_TEMPLATE_ID));
        this.presenter.abortProcessInstance();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((ConfirmPopup)Mockito.verify((Object)this.confirmPopup)).show((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (Command)captureCommand.capture());
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
        ((Command)captureCommand.getValue()).execute();
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstance((String)Mockito.eq((Object)SERVER_TEMPLATE_ID), (String)Mockito.eq((Object)PI_DEPLOYMENT_ID), (Long)Mockito.eq((Object)PI_ID));
    }
}

