/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsJSONMarshaller;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.jbpm.workbench.pr.client.editors.definition.list.ProcessDefinitionListFilterSettingsManager;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessDefinitionListFilterSettingsManagerTest {
    @Mock
    UserPreferencesService userPreferencesService;
    Caller<UserPreferencesService> preferencesService;
    @Mock
    FilterSettingsJSONMarshaller marshaller;
    @InjectMocks
    ProcessDefinitionListFilterSettingsManager manager;

    @Before
    public void init() {
        this.preferencesService = new CallerMock((Object)this.userPreferencesService);
        this.manager.setPreferencesService(this.preferencesService);
    }

    @Test
    public void testFilterSettings() {
        FilterSettings filterSettings = this.manager.createFilterSettingsPrototype();
        Assert.assertEquals((Object)"DS_ProcessDefinitionGrid", (Object)filterSettings.getKey());
        Assert.assertEquals((Object)"jbpmProcessDefinition", (Object)filterSettings.getUUID());
    }

    @Test
    public void testDefaultFilters() {
        Consumer<List> callback = filters -> {
            Assert.assertEquals((long)1L, (long)filters.size());
            Assert.assertEquals((Object)Constants.INSTANCE.All(), (Object)((SavedFilter)filters.get(0)).getName());
            Assert.assertEquals((Object)"DS_ProcessDefinitionGrid_0", (Object)((SavedFilter)filters.get(0)).getKey());
        };
        MultiGridPreferencesStore store = new MultiGridPreferencesStore();
        this.manager.loadSavedFiltersFromPreferences(store, callback);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesService)).saveUserPreferences((UserPreference)store);
    }
}

