/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.service.ProcessService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceDetailsPresenterTest {
    private static final Long PI_ID = 1L;
    private static final String SERVER_TEMPLATE_ID = "serverTemplateIdTest";
    private static final String PI_DEPLOYMENT_ID = "deploymentIdTest";
    private static final String PI_PROCESS_DEF_ID = "processDefIdTest";
    private static final String PI_PROCESS_DEF_NAME = "processDefNameTest";
    @Mock
    public ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView view;
    @Mock
    ConfirmPopup confirmPopup;
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Spy
    Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent = new EventSourceMock();
    @Spy
    Event<ProcessInstanceSelectionEvent> processInstanceSelected = new EventSourceMock();
    @Spy
    Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock();
    private CallerMock<ProcessService> remoteProcessServiceCaller;
    @Mock
    private ProcessService processService;
    @Mock
    PrimaryActionMenuBuilder signalProcessInstanceAction;
    @Mock
    PrimaryActionMenuBuilder abortProcessInstanceAction;
    @Mock
    ContainerSpec containerSpecMock;
    @Mock
    ServerTemplate serverTemplateMock;
    @Mock
    SpecManagementService specManagementService;
    Caller<SpecManagementService> specManagementServiceCaller;
    @InjectMocks
    private ProcessInstanceDetailsPresenter presenter;

    @Before
    public void setupMocks() {
        this.specManagementServiceCaller = new CallerMock((Object)this.specManagementService);
        this.presenter.setSpecManagementService(this.specManagementServiceCaller);
        Mockito.when((Object)this.specManagementService.getServerTemplate(Mockito.anyString())).thenReturn((Object)this.serverTemplateMock);
        Mockito.when((Object)this.serverTemplateMock.getContainerSpec(Mockito.anyString())).thenReturn((Object)this.containerSpecMock);
        Mockito.when((Object)this.containerSpecMock.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        ((Event)Mockito.doNothing().when(this.changeTitleWidgetEvent)).fire(Mockito.any(ChangeTitleWidgetEvent.class));
        ((Event)Mockito.doNothing().when(this.processInstanceSelected)).fire(Mockito.any(ProcessInstanceSelectionEvent.class));
        ((Event)Mockito.doNothing().when(this.processInstancesUpdatedEvent)).fire(Mockito.any(ProcessInstancesUpdateEvent.class));
        this.presenter.setSignalProcessInstanceAction(this.signalProcessInstanceAction);
        this.presenter.setAbortProcessInstanceAction(this.abortProcessInstanceAction);
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
    }

    @Test
    public void isForLogRemainsEnabledAfterRefresh() {
        boolean isLogOnly = true;
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), isLogOnly, SERVER_TEMPLATE_ID));
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayOnlyLogTab();
        Assert.assertTrue((boolean)this.presenter.isForLog());
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(isLogOnly);
        this.presenter.onRefresh();
        Assert.assertTrue((boolean)this.presenter.isForLog());
    }

    @Test
    public void isForLogRemainsDisabledAfterRefresh() {
        boolean isLogOnly = false;
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), isLogOnly, SERVER_TEMPLATE_ID));
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayAllTabs();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(isLogOnly);
        Assert.assertFalse((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForLog());
    }

    @Test
    public void confirmPopupTest() {
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), true, SERVER_TEMPLATE_ID));
        this.presenter.openAbortProcessInstancePopup();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((ConfirmPopup)Mockito.verify((Object)this.confirmPopup)).show((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any(), (Command)captureCommand.capture());
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
        ((Command)captureCommand.getValue()).execute();
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.DEFAULT, (Object)((NotificationEvent)captor.getValue()).getType());
        Assert.assertEquals((Object)Constants.INSTANCE.Aborting_Process_Instance((Object)PI_ID), (Object)((NotificationEvent)captor.getValue()).getNotification());
        ((ProcessService)Mockito.verify((Object)this.processService)).abortProcessInstance((String)Mockito.eq((Object)SERVER_TEMPLATE_ID), (String)Mockito.eq((Object)PI_DEPLOYMENT_ID), (Long)Mockito.eq((Object)PI_ID));
    }

    @Test
    public void abortActiveInstanceFromDetailsHidesActionsTest() {
        ((ProcessService)Mockito.doAnswer(invocation -> null).when((Object)this.processService)).abortProcessInstance((String)Mockito.eq((Object)SERVER_TEMPLATE_ID), (String)Mockito.eq((Object)PI_DEPLOYMENT_ID), (Long)Mockito.eq((Object)PI_ID));
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(1), false, SERVER_TEMPLATE_ID));
        this.verifySignalAbortActionsVisibility(true);
        this.verifyNoMoreInteractionsWithSignalAbortActions();
        this.presenter.abortProcessInstance();
        this.verifySignalAbortActionsVisibility(false);
        this.verifyNoMoreInteractionsWithSignalAbortActions();
    }

    @Test
    public void actionsDisabledForAbortedProcessInstance() {
        this.verifyActionsVisibility(3, false, false);
    }

    @Test
    public void actionsDisabledForCompletedProcessInstance() {
        this.verifyActionsVisibility(2, false, false);
    }

    @Test
    public void actionDisabledForPendingProcessInstance() {
        this.verifyActionsVisibility(0, false, false);
    }

    @Test
    public void actionDisabledForSuspendedProcessInstance() {
        this.verifyActionsVisibility(4, false, false);
    }

    @Test
    public void actionEnabledForActiveProcessInstance() {
        this.verifyActionsVisibility(1, false, true);
    }

    @Test
    public void actionDisabledForActiveProcessInstanceForLog() {
        this.verifyActionsVisibility(1, true, false);
    }

    private void verifyActionsVisibility(int status, boolean isForLog, boolean visibilityExpected) {
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(status), isForLog, SERVER_TEMPLATE_ID));
        this.verifySignalAbortActionsVisibility(visibilityExpected);
        this.verifyNoMoreInteractionsWithSignalAbortActions();
    }

    private void verifySignalAbortActionsVisibility(boolean expectedValue) {
        ((PrimaryActionMenuBuilder)Mockito.verify((Object)this.signalProcessInstanceAction)).setVisible(expectedValue);
        ((PrimaryActionMenuBuilder)Mockito.verify((Object)this.abortProcessInstanceAction)).setVisible(expectedValue);
    }

    private void verifyNoMoreInteractionsWithSignalAbortActions() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.signalProcessInstanceAction});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.abortProcessInstanceAction});
    }

    @Test
    public void refreshTest() {
        Mockito.when((Object)this.containerSpecMock.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), false, SERVER_TEMPLATE_ID));
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayAllTabs();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(false);
        this.presenter.onRefresh();
        ArgumentCaptor processInstanceSelectionEventArgumentCaptor = ArgumentCaptor.forClass(ProcessInstanceSelectionEvent.class);
        ((Event)Mockito.verify(this.processInstanceSelected)).fire(processInstanceSelectionEventArgumentCaptor.capture());
        Assert.assertEquals((Object)PI_DEPLOYMENT_ID, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getDeploymentId());
        Assert.assertEquals((Object)PI_ID, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getProcessInstanceId());
        Assert.assertEquals((Object)PI_PROCESS_DEF_ID, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getProcessDefId());
        Assert.assertEquals((Object)PI_PROCESS_DEF_NAME, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getProcessDefName());
        Assert.assertEquals((Object)0, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getProcessInstanceStatus());
        Assert.assertFalse((boolean)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).isForLog());
        Assert.assertEquals((Object)SERVER_TEMPLATE_ID, (Object)((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue()).getServerTemplateId());
        this.presenter.onProcessSelectionEvent((ProcessInstanceSelectionEvent)processInstanceSelectionEventArgumentCaptor.getValue());
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).displayAllTabs();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(false);
    }

    @Test
    public void refreshWhenContainerStoppedTest() {
        Mockito.when((Object)this.containerSpecMock.getStatus()).thenReturn((Object)KieContainerStatus.STOPPED);
        this.presenter.onProcessSelectionEvent(new ProcessInstanceSelectionEvent(PI_DEPLOYMENT_ID, PI_ID, PI_PROCESS_DEF_ID, PI_PROCESS_DEF_NAME, Integer.valueOf(0), false, SERVER_TEMPLATE_ID));
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayAllTabs();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).resetTabs(false);
        this.presenter.onRefresh();
        ((ProcessInstanceDetailsPresenter.ProcessInstanceDetailsView)Mockito.verify((Object)this.view)).displayNotification(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.processInstanceSelected});
    }
}

