/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.model.RuntimeLogSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class RuntimeLogPresenterTest {
    @Mock
    RuntimeLogPresenter.RuntimeLogView view;
    Caller<ProcessRuntimeDataService> processRuntimeDataServiceCaller;
    @Mock
    ProcessRuntimeDataService processRuntimeDataService;
    @InjectMocks
    RuntimeLogPresenter presenter;
    private String serverTemplateId = "serverTemplateId";
    private String deploymentId = "deploymentId";
    private String processName = "processName";
    private String testTask = "testTask";
    private Long processInstanceId = 1L;
    private Date logDate = new Date();
    private String prettyTime = "";
    private String techTime;

    @Before
    public void setup() {
        this.processRuntimeDataServiceCaller = new CallerMock((Object)this.processRuntimeDataService);
        this.presenter.setProcessRuntimeDataService(this.processRuntimeDataServiceCaller);
        this.techTime = DateUtils.getDateTimeStr((Date)this.logDate);
        RuntimeLogSummary logs0 = new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_START, false);
        RuntimeLogSummary logs1 = new RuntimeLogSummary(1L, this.logDate, this.testTask, RuntimeLogPresenter.NODE_HUMAN_TASK, false);
        RuntimeLogSummary logs2 = new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_END, true);
        RuntimeLogSummary logs3 = new RuntimeLogSummary(1L, this.logDate, "", "Split", false);
        Mockito.when((Object)this.processRuntimeDataService.getProcessInstanceLogs(this.serverTemplateId, this.deploymentId, this.processInstanceId)).thenReturn(Arrays.asList(logs0, logs1, logs2, logs3));
        this.presenter.setServerTemplateId(this.serverTemplateId);
        this.presenter.setProcessName(this.processName);
        this.presenter.setDeploymentId(this.deploymentId);
        this.presenter.setProcessInstanceId(this.processInstanceId);
    }

    @Test
    public void addTechLogLineTest() {
        Optional logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_START, false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", false, true), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_START, true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", true, false), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "testTask", RuntimeLogPresenter.NODE_HUMAN_TASK, false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, false, false), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "testTask", RuntimeLogPresenter.NODE_HUMAN_TASK, true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, true, true), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_END, false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", false, false), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_END, true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", true, false), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", "Split", false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", false, false), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", "Split", true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", true, false), logLine.get());
    }

    @Test
    public void addBusinessLoglineTest() {
        this.presenter.setProcessName(this.processName);
        Optional logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_START, false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasStarted()), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_START, true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "testTask", RuntimeLogPresenter.NODE_HUMAN_TASK, false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasStarted()), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "testTask", RuntimeLogPresenter.NODE_HUMAN_TASK, true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasCompleted()), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_END, false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", RuntimeLogPresenter.NODE_END, true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasCompleted()), logLine.get());
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", "Split", false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
        logLine = this.presenter.getLogLine(new RuntimeLogSummary(1L, this.logDate, "", "Split", true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
    }

    @Test
    public void refreshProcessInstanceDataDescTechTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.DESC, LogUtils.LogType.TECHNICAL);
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((RuntimeLogPresenter.RuntimeLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processRuntimeDataService)).getProcessInstanceLogs(this.serverTemplateId, this.deploymentId, this.processInstanceId);
        Assert.assertEquals((long)4L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", false, true), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, false, false), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", true, false), ((List)argumentDESC.getValue()).get(2));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", false, false), ((List)argumentDESC.getValue()).get(3));
    }

    @Test
    public void refreshProcessInstanceDataAscTechTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.TECHNICAL);
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((RuntimeLogPresenter.RuntimeLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processRuntimeDataService)).getProcessInstanceLogs(this.serverTemplateId, this.deploymentId, this.processInstanceId);
        Assert.assertEquals((long)4L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", false, false), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", true, false), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, false, false), ((List)argumentDESC.getValue()).get(2));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", false, true), ((List)argumentDESC.getValue()).get(3));
    }

    @Test
    public void refreshProcessInstanceDataDescBusinessTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.DESC, LogUtils.LogType.BUSINESS);
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((RuntimeLogPresenter.RuntimeLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processRuntimeDataService)).getProcessInstanceLogs(this.serverTemplateId, this.deploymentId, this.processInstanceId);
        Assert.assertEquals((long)3L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasCompleted()), ((List)argumentDESC.getValue()).get(2));
    }

    @Test
    public void refreshProcessInstanceDataAscBusinessTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.BUSINESS);
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((RuntimeLogPresenter.RuntimeLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processRuntimeDataService)).getProcessInstanceLogs(this.serverTemplateId, this.deploymentId, this.processInstanceId);
        Assert.assertEquals((long)3L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasCompleted()), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(2));
    }

    private String getBusinessLogCall(String time, String logType, String logName, String completed) {
        return RuntimeLogPresenter.LOG_TEMPLATES.getBusinessLog(time, logType, SafeHtmlUtils.fromString((String)logName), completed).asString();
    }

    private String getTechLogCall(String time, String logType, String logName, boolean completed, boolean human) {
        return RuntimeLogPresenter.LOG_TEMPLATES.getTechLog(time, logType, SafeHtmlUtils.fromString((String)logName), completed ? " " + Constants.INSTANCE.Completed() : "", human ? Constants.INSTANCE.Human() : Constants.INSTANCE.System()).asString();
    }
}

