/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.signal;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.jbpm.workbench.pr.client.editors.instance.signal.ProcessInstanceSignalPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.service.ProcessService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceSignalPresenterTest {
    private static final Long PI_ID = 1L;
    private static final Long PI_ID2 = 2L;
    private static final String SERVER_TEMPLATE_ID = "serverTemplateIdTest";
    private static final String PI_DEPLOYMENT_ID = "deploymentIdTest";
    @Mock
    public ProcessInstanceSignalPresenter.PopupView view;
    @Mock
    ConfirmPopup confirmPopup;
    @Spy
    Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent = new EventSourceMock();
    private CallerMock<ProcessService> remoteProcessServiceCaller;
    @Mock
    private ProcessService processService;
    @Mock
    private PlaceRequest place;
    @Mock
    private PlaceManager placeManager;
    @InjectMocks
    private ProcessInstanceSignalPresenter presenter;

    @Before
    public void setupMocks() {
        ((Event)Mockito.doNothing().when(this.processInstancesUpdatedEvent)).fire(Mockito.any(ProcessInstancesUpdateEvent.class));
        this.remoteProcessServiceCaller = new CallerMock((Object)this.processService);
        this.presenter.setProcessService(this.remoteProcessServiceCaller);
        Mockito.when((Object)this.place.getParameter("serverTemplateId", "")).thenReturn((Object)SERVER_TEMPLATE_ID);
        Mockito.when((Object)this.place.getParameter("deploymentId", "")).thenReturn((Object)PI_DEPLOYMENT_ID);
        Mockito.when((Object)this.place.getParameter("processInstanceId", "-1")).thenReturn((Object)(PI_ID + ""));
    }

    @Test
    public void signalProcessInstancesEmptyRefTest() {
        Mockito.when((Object)this.view.getSignalRefText()).thenReturn((Object)"");
        this.presenter.signalProcessInstances(Arrays.asList(PI_ID));
        ((ProcessInstanceSignalPresenter.PopupView)Mockito.verify((Object)this.view)).setHelpText(Constants.INSTANCE.Signal_Name_Required());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.processService});
    }

    @Test
    public void signalProcessInstancesTest() {
        String signalRef = "SIGNAL_REF";
        String eventText = "EVENT_TEXT";
        List<Long> processInstanceIds = Arrays.asList(PI_ID, PI_ID2);
        this.presenter.onStartup(this.place);
        this.presenter.onOpen();
        Mockito.when((Object)this.view.getSignalRefText()).thenReturn((Object)signalRef);
        Mockito.when((Object)this.view.getEventText()).thenReturn((Object)eventText);
        this.presenter.signalProcessInstances(processInstanceIds);
        ((ProcessInstanceSignalPresenter.PopupView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)processInstanceIds.size()))).displayNotification(Mockito.anyString());
        ((ProcessInstanceSignalPresenter.PopupView)Mockito.verify((Object)this.view)).displayNotification(Constants.INSTANCE.Signaling_Process_Instance() + " (" + Constants.INSTANCE.Id() + " = " + PI_ID + ") " + Constants.INSTANCE.Signal() + " = " + signalRef + " - " + Constants.INSTANCE.Signal_Data() + " = " + eventText);
        ((ProcessInstanceSignalPresenter.PopupView)Mockito.verify((Object)this.view)).displayNotification(Constants.INSTANCE.Signaling_Process_Instance() + " (" + Constants.INSTANCE.Id() + " = " + PI_ID2 + ") " + Constants.INSTANCE.Signal() + " = " + signalRef + " - " + Constants.INSTANCE.Signal_Data() + " = " + eventText);
        ((ProcessService)Mockito.verify((Object)this.processService)).signalProcessInstances((String)Mockito.eq((Object)SERVER_TEMPLATE_ID), (List)Mockito.eq(Arrays.asList(PI_DEPLOYMENT_ID)), (List)Mockito.eq(processInstanceIds), (String)Mockito.eq((Object)signalRef), Mockito.eq((Object)eventText));
    }
}

