/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.details;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.menu.PrimaryActionMenuBuilder;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.pr.client.editors.diagram.ProcessDiagramPresenter;
import org.jbpm.workbench.pr.client.editors.documents.list.ProcessDocumentListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.details.ProcessInstanceDetailsTabPresenter;
import org.jbpm.workbench.pr.client.editors.instance.log.RuntimeLogPresenter;
import org.jbpm.workbench.pr.client.editors.variables.list.ProcessVariableListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.service.ProcessService;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProcessInstanceDetailsScreen")
public class ProcessInstanceDetailsPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    @Inject
    public ProcessInstanceDetailsView view;
    @Inject
    ConfirmPopup confirmPopup;
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private PlaceManager placeManager;
    private Caller<ProcessService> processService;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private Event<ProcessInstancesUpdateEvent> processInstancesUpdatedEvent;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    private ProcessInstanceDetailsTabPresenter detailsPresenter;
    @Inject
    private ProcessDiagramPresenter processDiagramPresenter;
    @Inject
    private ProcessVariableListPresenter variableListPresenter;
    @Inject
    private ProcessDocumentListPresenter documentListPresenter;
    @Inject
    private RuntimeLogPresenter runtimeLogPresenter;
    protected Caller<SpecManagementService> specManagementService;
    private String selectedDeploymentId = "";
    private int selectedProcessInstanceStatus = 0;
    private String selectedProcessDefName = "";
    private PlaceRequest place;
    private String deploymentId = "";
    private String processId = "";
    private Long processInstanceId;
    private String serverTemplateId = "";
    private boolean forLog = false;
    PrimaryActionMenuBuilder signalProcessInstanceAction;
    PrimaryActionMenuBuilder abortProcessInstanceAction;

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }

    @WorkbenchPartView
    public UberView<ProcessInstanceDetailsPresenter> getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.setSignalProcessInstanceAction(new PrimaryActionMenuBuilder(this.constants.Signal(), () -> this.signalProcessInstance()));
        this.setAbortProcessInstanceAction(new PrimaryActionMenuBuilder(this.constants.Abort(), () -> this.openAbortProcessInstancePopup()));
        this.place = place;
    }

    public void setSignalProcessInstanceAction(PrimaryActionMenuBuilder signalProcessInstanceAction) {
        this.signalProcessInstanceAction = signalProcessInstanceAction;
    }

    public void setAbortProcessInstanceAction(PrimaryActionMenuBuilder abortProcessInstanceAction) {
        this.abortProcessInstanceAction = abortProcessInstanceAction;
    }

    private void setSignalAbortActionsVisible(boolean visible) {
        this.signalProcessInstanceAction.setVisible(visible);
        this.abortProcessInstanceAction.setVisible(visible);
    }

    public boolean isForLog() {
        return this.forLog;
    }

    public void setIsForLog(boolean isForLog) {
        this.forLog = isForLog;
    }

    public void onProcessSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        boolean refreshDetails = event != null && event.getProcessInstanceId() != null && event.getProcessInstanceId().equals(this.processInstanceId);
        this.deploymentId = event.getDeploymentId();
        this.processId = event.getProcessDefId();
        this.processInstanceId = event.getProcessInstanceId();
        this.serverTemplateId = event.getServerTemplateId();
        this.selectedDeploymentId = event.getDeploymentId();
        this.selectedProcessInstanceStatus = event.getProcessInstanceStatus();
        this.selectedProcessDefName = event.getProcessDefName();
        this.setIsForLog(event.isForLog());
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.processInstanceId) + " - " + this.selectedProcessDefName));
        boolean signalAbortVisible = false;
        if (this.isForLog()) {
            this.view.displayOnlyLogTab();
        } else {
            if (this.selectedProcessInstanceStatus == 1) {
                signalAbortVisible = true;
            }
            this.view.displayAllTabs();
        }
        this.setSignalAbortActionsVisible(signalAbortVisible);
        if (!refreshDetails) {
            this.view.resetTabs(event.isForLog());
        }
    }

    public void onRefresh() {
        ((SpecManagementService)this.specManagementService.call(serverTemplate -> {
            if (serverTemplate != null && serverTemplate.getContainerSpec(this.selectedDeploymentId) != null && serverTemplate.getContainerSpec(this.selectedDeploymentId).getStatus().equals((Object)KieContainerStatus.STARTED)) {
                this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(this.selectedDeploymentId, this.processInstanceId, this.processId, this.selectedProcessDefName, Integer.valueOf(this.selectedProcessInstanceStatus), this.isForLog(), this.serverTemplateId));
            } else {
                this.view.displayNotification(this.constants.ProcessDetailsNotAvailableContainerNotStarted(this.selectedDeploymentId));
            }
        })).getServerTemplate(this.serverTemplateId);
    }

    public void signalProcessInstance() {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", String.valueOf(this.processInstanceId));
        placeRequestImpl.addParameter("deploymentId", this.deploymentId);
        placeRequestImpl.addParameter("serverTemplateId", this.serverTemplateId);
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void openAbortProcessInstancePopup() {
        this.confirmPopup.show(this.constants.Abort_Confirmation(), this.constants.Abort(), this.constants.Abort_Process_Instance(), () -> this.abortProcessInstance());
    }

    protected void abortProcessInstance() {
        ((ProcessService)this.processService.call(processInstance -> {
            this.displayNotification(this.constants.Aborting_Process_Instance(this.processInstanceId));
            this.selectedProcessInstanceStatus = 3;
            this.setSignalAbortActionsVisible(false);
            this.processInstancesUpdatedEvent.fire((Object)new ProcessInstancesUpdateEvent(Long.valueOf(0L)));
        })).abortProcessInstance(this.serverTemplateId, this.deploymentId, this.processInstanceId);
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.signalProcessInstanceAction).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.abortProcessInstanceAction).endMenu()).build();
    }

    public void variableListRefreshGrid() {
        this.variableListPresenter.refreshGrid();
    }

    public void documentListRefreshGrid() {
        this.documentListPresenter.refreshGrid();
    }

    public IsWidget getProcessInstanceView() {
        return this.detailsPresenter.getWidget();
    }

    public IsWidget getProcessVariablesView() {
        return this.variableListPresenter.getWidget();
    }

    public IsWidget getDocumentView() {
        return this.documentListPresenter.getWidget();
    }

    public IsWidget getLogsView() {
        return this.runtimeLogPresenter.getWidget();
    }

    public IsWidget getProcessDiagramView() {
        return this.processDiagramPresenter.getView();
    }

    @Inject
    public void setSpecManagementService(Caller<SpecManagementService> specManagementService) {
        this.specManagementService = specManagementService;
    }

    public static interface ProcessInstanceDetailsView
    extends UberView<ProcessInstanceDetailsPresenter> {
        public void displayAllTabs();

        public void displayOnlyLogTab();

        public void resetTabs(boolean var1);

        public void displayNotification(String var1);
    }
}

