/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.workbench.cm.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public interface Constants {

    @TranslationKey(defaultValue = "")
    String ID = "Id";

    @TranslationKey(defaultValue = "")
    String CASE = "Case";

    @TranslationKey(defaultValue = "")
    String DESCRIPTION = "Description";

    @TranslationKey(defaultValue = "")
    String STATUS = "Status";

    @TranslationKey(defaultValue = "")
    String OWNER = "Owner";

    @TranslationKey(defaultValue = "")
    String STARTED_AT = "StartedAt";

    @TranslationKey(defaultValue = "")
    String ACTIONS = "Actions";

    @TranslationKey(defaultValue = "")
    String CASES_LIST = "CasesList";

    @TranslationKey(defaultValue = "")
    String CREATE = "Create";

    @TranslationKey(defaultValue = "")
    String CASE_CREATED_WITH_ID = "CaseCreatedWithId";

    @TranslationKey(defaultValue = "")
    String ACTIVE = "Active";

    @TranslationKey(defaultValue = "")
    String INVALID_CASE_DEFINITION = "InvalidCaseDefinition";

    @TranslationKey(defaultValue = "")
    String PLEASE_SELECT_CASE_DEFINITION = "PleaseSelectCaseDefinition";

    @TranslationKey(defaultValue = "")
    String NO_CASE_DEFINITION = "NoCaseDefinition";

    @TranslationKey(defaultValue = "")
    String PLEASE_SELECT_ROLE = "PleaseSelectRole";

    @TranslationKey(defaultValue = "")
    String CASE_OVERVIEW = "CaseOverview";

    @TranslationKey(defaultValue = "")
    String CASE_DETAILS = "CaseDetails";

    @TranslationKey(defaultValue = "")
    String ROLES = "Roles";

    @TranslationKey(defaultValue = "")
    String REMOVE = "Remove";

    @TranslationKey(defaultValue = "")
    String USER = "User";

    @TranslationKey(defaultValue = "")
    String USER_REQUIRED = "UserRequired";

    @TranslationKey(defaultValue = "")
    String GROUP = "Group";

    @TranslationKey(defaultValue = "")
    String GROUP_REQUIRED = "GroupRequired";

    @TranslationKey(defaultValue = "")
    String CASE_COMMENTS = "Comments";

    @TranslationKey(defaultValue = "")
    String CASE_COMMENT_CANT_BE_EMPTY = "CommentCannotBeEmpty";

    @TranslationKey(defaultValue = "")
    String DELETE = "Delete";

    @TranslationKey(defaultValue = "")
    String EDIT = "Edit";

    @TranslationKey(defaultValue = "")
    String SAVE = "Save";

    @TranslationKey(defaultValue = "")
    String CANCEL = "Cancel";

    @TranslationKey(defaultValue = "")
    String MILESTONES = "Milestones";

    @TranslationKey(defaultValue = "")
    String CASE_STAGES = "CaseStages";

}