/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jbpm.workbench.ht.client.editors.taskform;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;

import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.EmbeddedFormDisplayView;

@Dependent
public class TaskFormViewImpl extends Composite implements TaskFormPresenter.TaskFormView {

    interface Binder
            extends
            UiBinder<Widget, TaskFormViewImpl> {

    }

    private static Binder uiBinder = GWT.create(Binder.class);

    @UiField
    FlowPanel content;

    @Inject
    private EmbeddedFormDisplayView view;

    @PostConstruct
    public void init() {
        initWidget(uiBinder.createAndBindUi(this));
        content.add(view.getView());
    }

    @Override
    public FormDisplayerView getDisplayerView() {
        return view;
    }
}
