/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import java.util.Arrays;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.email.Connection;
import org.jbpm.process.workitem.email.Email;
import org.jbpm.process.workitem.email.Message;
import org.jbpm.process.workitem.email.Recipient;
import org.jbpm.process.workitem.email.Recipients;
import org.jbpm.process.workitem.email.SendHtml;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

public class EmailWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private Connection connection;

    public EmailWorkItemHandler() {
    }

    public EmailWorkItemHandler(String host, String port, String userName, String password) {
        this.setConnection(host, port, userName, password);
    }

    public EmailWorkItemHandler(String host, String port, String userName, String password, String startTls) {
        this.setConnection(host, port, userName, password, startTls);
    }

    public void setConnection(String host, String port, String userName, String password) {
        this.connection = new Connection();
        this.connection.setHost(host);
        this.connection.setPort(port);
        this.connection.setUserName(userName);
        this.connection.setPassword(password);
    }

    public void setConnection(String host, String port, String userName, String password, String startTls) {
        this.connection = new Connection();
        this.connection.setHost(host);
        this.connection.setPort(port);
        this.connection.setUserName(userName);
        this.connection.setPassword(password);
        this.connection.setStartTls(Boolean.parseBoolean(startTls));
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        if (this.connection == null) {
            throw new IllegalArgumentException("Connection not initialized for Email");
        }
        try {
            Email email = EmailWorkItemHandler.createEmail(workItem, this.connection);
            SendHtml.sendHtml(email, this.getDebugFlag(workItem));
            if (manager != null) {
                manager.completeWorkItem(workItem.getId(), null);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected static Email createEmail(WorkItem workItem, Connection connection) {
        String bcc;
        Email email = new Email();
        Message message = new Message();
        message.setFrom((String)workItem.getParameter("From"));
        message.setReplyTo((String)workItem.getParameter("Reply-To"));
        Recipients recipients = new Recipients();
        String to = (String)workItem.getParameter("To");
        if (to == null || to.trim().length() == 0) {
            throw new RuntimeException("Email must have one or more to adresses");
        }
        for (String s : to.split(";")) {
            if (s == null || "".equals(s)) continue;
            Recipient recipient = new Recipient();
            recipient.setEmail(s);
            recipient.setType("To");
            recipients.addRecipient(recipient);
        }
        String cc = (String)workItem.getParameter("Cc");
        if (cc != null && cc.trim().length() > 0) {
            for (String s : cc.split(";")) {
                if (s == null || "".equals(s)) continue;
                Recipient recipient = new Recipient();
                recipient.setEmail(s);
                recipient.setType("Cc");
                recipients.addRecipient(recipient);
            }
        }
        if ((bcc = (String)workItem.getParameter("Bcc")) != null && bcc.trim().length() > 0) {
            for (String s : bcc.split(";")) {
                if (s == null || "".equals(s)) continue;
                Recipient recipient = new Recipient();
                recipient.setEmail(s);
                recipient.setType("Bcc");
                recipients.addRecipient(recipient);
            }
        }
        message.setRecipients(recipients);
        message.setSubject((String)workItem.getParameter("Subject"));
        message.setBody((String)workItem.getParameter("Body"));
        String attachmentList = (String)workItem.getParameter("Attachments");
        if (attachmentList != null) {
            String[] attachments = attachmentList.split(",");
            message.setAttachments(Arrays.asList(attachments));
        }
        email.setMessage(message);
        email.setConnection(connection);
        return email;
    }

    public void abortWorkItem(WorkItem arg0, WorkItemManager arg1) {
    }

    protected boolean getDebugFlag(WorkItem workItem) {
        Object debugParam = workItem.getParameter("Debug");
        if (debugParam == null) {
            return false;
        }
        return Boolean.parseBoolean(debugParam.toString());
    }
}

