/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.jms;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.jms.JMSSendTaskWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JMSSendTaskWorkItemHandlerTest {
    @Mock
    ConnectionFactory connectionFactory;
    @Mock
    Destination destination;
    @Mock
    Connection connection;
    @Mock
    Session session;
    @Mock
    MessageProducer producer;
    @Mock
    BytesMessage message;

    @Test
    public void testSendMessage() throws Exception {
        ArgumentCaptor bytesCaptor = ArgumentCaptor.forClass(byte[].class);
        Mockito.when((Object)this.connectionFactory.createConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.createSession(Mockito.anyBoolean(), Mockito.anyInt())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.createProducer((Destination)Mockito.any(Destination.class))).thenReturn((Object)this.producer);
        Mockito.when((Object)this.session.createBytesMessage()).thenReturn((Object)this.message);
        ((MessageProducer)Mockito.doNothing().when((Object)this.producer)).close();
        ((Session)Mockito.doNothing().when((Object)this.session)).close();
        ((Connection)Mockito.doNothing().when((Object)this.connection)).close();
        ((MessageProducer)Mockito.doNothing().when((Object)this.producer)).send((Message)Mockito.any(Message.class));
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Signal", (Object)"mysignal");
        workItem.setParameter("SignalProcessInstanceId", (Object)"abcde");
        workItem.setParameter("SignalWorkItemId", (Object)"12345");
        workItem.setParameter("SignalDeploymentId", (Object)"deployment-123");
        workItem.setProcessInstanceId(123L);
        workItem.setDeploymentId("deploy-123");
        workItem.setParameter("Data", (Object)"hello world");
        JMSSendTaskWorkItemHandler handler = new JMSSendTaskWorkItemHandler(this.connectionFactory, this.destination, false, false);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        ((BytesMessage)Mockito.verify((Object)this.message)).writeBytes((byte[])bytesCaptor.capture());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])bytesCaptor.getValue());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        String messageVal = (String)objectInputStream.readObject();
        Assert.assertTrue((boolean)"hello world".equals(messageVal));
    }
}

