/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.process.workitem.rest.Person;

@Path(value="/test")
public class TestRESTResource {
    @GET
    @Produces(value={"text/plain"})
    public String get(@QueryParam(value="param") String param) {
        return "Hello from REST" + (param != null ? " " + param : "");
    }

    @GET
    @Path(value="/charset")
    @Produces(value={"text/plain"})
    public Response getPlainText(@HeaderParam(value="Accept-Charset") String acceptCharset) {
        String entity = "\u0160";
        Charset charset = Charset.forName(acceptCharset);
        Response myResponse = Response.status((Response.Status)Response.Status.OK).entity((Object)entity.getBytes(charset)).build();
        return myResponse;
    }

    @POST
    @Path(value="/{name}")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String post(@PathParam(value="name") String name) {
        return "Created resource with name " + name;
    }

    @POST
    @Path(value="/xml")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Person postXml(Person person) {
        person.setName("Post " + person.getName());
        return person;
    }

    @PUT
    @Path(value="/xml")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public Person putXml(Person person) {
        person.setName("Put " + person.getName());
        return person;
    }

    @PATCH
    @Path(value="/xml")
    @Consumes(value={"application/xml"})
    @Produces(value={"text/plain"})
    public Response patchXml(Person person) {
        person.setName("Patch " + person.getName());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @PUT
    @Path(value="/xml-charset")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml; charset=UTF-8"})
    public Person putXmlWithCharset(Person person) {
        person.setName("Put " + person.getName());
        return person;
    }

    @DELETE
    @Path(value="/xml/{name}")
    @Produces(value={"application/xml"})
    public Person delete(@PathParam(value="name") String name) {
        Person person = new Person();
        person.setAge(-1);
        person.setName("deleted " + name);
        return person;
    }

    @GET
    @Path(value="/xml")
    @Produces(value={"application/xml"})
    public Person getXml() {
        Person person = new Person();
        person.setName("Person Xml");
        return person;
    }

    @GET
    @Path(value="/json")
    @Produces(value={"application/json"})
    public String getJson() {
        return "{\"name\":\"Person Json\"}";
    }

    @GET
    @Path(value="/xml-charset")
    @Produces(value={"application/xml; charset=utf-8"})
    public Person getXmlWithCharset() {
        Person person = new Person();
        person.setName("Person Xml");
        return person;
    }

    @GET
    @Path(value="/json-charset")
    @Produces(value={"application/json; charset=utf-8"})
    public String getJsonWithCharset() {
        return "{\"name\":\"Person Json\"}";
    }

    @GET
    @Path(value="/header/{headerKey}")
    @Produces(value={"text/plain"})
    public String getHeaderValue(@PathParam(value="headerKey") String headerKey, @Context HttpHeaders headers) {
        return ((List)headers.getRequestHeaders().getOrDefault((Object)headerKey, Collections.emptyList())).stream().collect(Collectors.joining(","));
    }

    @GET
    @Path(value="/testSingleCookie")
    @Produces(value={"application/xml"})
    public String getSingleCookie(@CookieParam(value="cookieParam1") Cookie cookieParam1) {
        return cookieParam1.getName() + "=" + cookieParam1.getValue();
    }

    @GET
    @Path(value="/testMultipleCookie")
    @Produces(value={"application/xml"})
    public String getMultipleCookie(@CookieParam(value="cookieParam1") Cookie cookieParam1, @CookieParam(value="cookieParam2") Cookie cookieParam2) {
        return cookieParam1.getName() + "=" + cookieParam1.getValue() + ";" + cookieParam2.getName() + "=" + cookieParam2.getValue();
    }
}

