/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.transport.http.HTTPConduit;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.webservice.WebServiceCommand;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class WebServiceCommandTest {
    @Mock
    KieSession kieSession;
    @Mock
    Client client;
    @Mock
    ConcurrentHashMap<String, Client> clients;
    @Mock
    CommandContext commandContext;

    @Test
    public void testExecuteCommand() throws Exception {
        Object[] clientObject = Arrays.asList("testResults").toArray();
        Mockito.when((Object)this.clients.containsKey(Mockito.anyObject())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.anyObject())).thenReturn((Object)this.client);
        Mockito.when((Object)this.client.invoke(Mockito.anyString(), (Object[])Mockito.any(Object[].class))).thenReturn((Object)clientObject);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        Mockito.when((Object)this.commandContext.getData(Mockito.anyString())).thenReturn((Object)workItem);
        WebServiceCommand command = new WebServiceCommand();
        command.setClients(this.clients);
        ExecutionResults results = command.execute(this.commandContext);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((Object)"testResults", (Object)results.getData("Result"));
    }

    @Test
    public void testExecuteCommandWithBasicAuth() throws Exception {
        Object[] clientObject = Arrays.asList("testResults").toArray();
        Mockito.when((Object)this.clients.containsKey(Mockito.anyObject())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.anyObject())).thenReturn((Object)this.client);
        Mockito.when((Object)this.client.invoke(Mockito.anyString(), (Object[])Mockito.any(Object[].class))).thenReturn((Object)clientObject);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Username", (Object)"testUserName");
        workItem.setParameter("Password", (Object)"testPassword");
        Mockito.when((Object)this.commandContext.getData(Mockito.anyString())).thenReturn((Object)workItem);
        HTTPConduit http = (HTTPConduit)Mockito.mock(HTTPConduit.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)this.client.getConduit()).thenReturn((Object)http);
        WebServiceCommand command = new WebServiceCommand();
        command.setClients(this.clients);
        ExecutionResults results = command.execute(this.commandContext);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((Object)"testResults", (Object)results.getData("Result"));
        Assert.assertNotNull((Object)http.getAuthorization());
        AuthorizationPolicy authorizationPolicy = http.getAuthorization();
        Assert.assertEquals((Object)"Basic", (Object)authorizationPolicy.getAuthorizationType());
        Assert.assertEquals((Object)"testUserName", (Object)authorizationPolicy.getUserName());
        Assert.assertEquals((Object)"testPassword", (Object)authorizationPolicy.getPassword());
    }
}

