/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.interceptors.HolderInInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.webservice.WebServiceWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WebServiceWorkItemHandlerTest {
    @Mock
    KieSession kieSession;
    @Mock
    Client client;
    @Mock
    ConcurrentHashMap<String, Client> clients;

    @Test
    public void testExecuteSyncOperation() throws Exception {
        Mockito.when((Object)this.clients.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.any())).thenReturn((Object)this.client);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Parameter", (Object)"myParam");
        workItem.setParameter("Mode", (Object)"SYNC");
        WebServiceWorkItemHandler handler = new WebServiceWorkItemHandler(this.kieSession);
        handler.setClients(this.clients);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testExecuteWrappedModeSync() throws Exception {
        Mockito.when((Object)this.clients.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.any())).thenReturn((Object)this.client);
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)this.client.getEndpoint()).thenReturn((Object)endpoint);
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(Mockito.mock(WrapperClassInInterceptor.class));
        interceptors.add(Mockito.mock(HolderInInterceptor.class));
        Mockito.when((Object)endpoint.getInInterceptors()).thenReturn(interceptors);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Parameter", (Object)"myParam");
        workItem.setParameter("Mode", (Object)"SYNC");
        workItem.setParameter("Wrapped", (Object)"true");
        WebServiceWorkItemHandler handler = new WebServiceWorkItemHandler(this.kieSession);
        handler.setClients(this.clients);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ((Client)Mockito.verify((Object)this.client)).invokeWrapped((String)Mockito.any(String.class), (Object[])Mockito.any());
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).invoke((String)Mockito.any(String.class), (Object[])Mockito.any());
        Assert.assertEquals((long)0L, (long)interceptors.size());
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }

    @Test
    public void testExecuteWrappedModeOneWay() throws Exception {
        Mockito.when((Object)this.clients.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.any())).thenReturn((Object)this.client);
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)this.client.getEndpoint()).thenReturn((Object)endpoint);
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(Mockito.mock(WrapperClassInInterceptor.class));
        interceptors.add(Mockito.mock(HolderInInterceptor.class));
        Mockito.when((Object)endpoint.getInInterceptors()).thenReturn(interceptors);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Parameter", (Object)"myParam");
        workItem.setParameter("Mode", (Object)"ONEWAY");
        workItem.setParameter("Wrapped", (Object)"true");
        WebServiceWorkItemHandler handler = new WebServiceWorkItemHandler(this.kieSession);
        handler.setClients(this.clients);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ((Client)Mockito.verify((Object)this.client)).invokeWrapped((ClientCallback)Mockito.any(ClientCallback.class), (String)Mockito.any(String.class), (Object[])Mockito.any());
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).invoke((ClientCallback)Mockito.any(ClientCallback.class), (String)Mockito.any(String.class), (Object[])Mockito.any());
        Assert.assertEquals((long)0L, (long)interceptors.size());
    }

    @Test
    public void testExecuteWrappedModeAsync() throws Exception {
        Mockito.when((Object)this.clients.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.any())).thenReturn((Object)this.client);
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)this.client.getEndpoint()).thenReturn((Object)endpoint);
        ArrayList<Object> interceptors = new ArrayList<Object>();
        interceptors.add(Mockito.mock(WrapperClassInInterceptor.class));
        interceptors.add(Mockito.mock(HolderInInterceptor.class));
        Mockito.when((Object)endpoint.getInInterceptors()).thenReturn(interceptors);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Parameter", (Object)"myParam");
        workItem.setParameter("Mode", (Object)"ASYNC");
        workItem.setParameter("Wrapped", (Object)"true");
        WebServiceWorkItemHandler handler = new WebServiceWorkItemHandler(this.kieSession);
        handler.setClients(this.clients);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        ((Client)Mockito.verify((Object)this.client)).invokeWrapped((ClientCallback)Mockito.any(ClientCallback.class), (String)Mockito.any(String.class), (Object[])Mockito.any());
        ((Client)Mockito.verify((Object)this.client, (VerificationMode)Mockito.never())).invoke((ClientCallback)Mockito.any(ClientCallback.class), (String)Mockito.any(String.class), (Object[])Mockito.any());
        Assert.assertEquals((long)0L, (long)interceptors.size());
    }

    @Test
    public void testExecuteSyncOperationWithBasicAuth() throws Exception {
        HTTPConduit http = (HTTPConduit)Mockito.mock(HTTPConduit.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)this.clients.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.any())).thenReturn((Object)this.client);
        Mockito.when((Object)this.client.getConduit()).thenReturn((Object)http);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Parameter", (Object)"myParam");
        workItem.setParameter("Mode", (Object)"SYNC");
        WebServiceWorkItemHandler handler = new WebServiceWorkItemHandler(this.kieSession, "testusername", "testpassword");
        handler.setClients(this.clients);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
        Assert.assertNotNull((Object)http.getAuthorization());
        AuthorizationPolicy authorizationPolicy = http.getAuthorization();
        Assert.assertEquals((Object)"Basic", (Object)authorizationPolicy.getAuthorizationType());
        Assert.assertEquals((Object)"testusername", (Object)authorizationPolicy.getUserName());
        Assert.assertEquals((Object)"testpassword", (Object)authorizationPolicy.getPassword());
    }

    @Test
    public void testExecuteSyncOperationHandlingException() throws Exception {
        Mockito.when((Object)this.clients.containsKey(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.any())).thenReturn(null);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Parameter", (Object)"myParam");
        workItem.setParameter("Mode", (Object)"SYNC");
        WebServiceWorkItemHandler handler = new WebServiceWorkItemHandler("test", "COMPLETE", this.kieSession);
        handler.setClients(this.clients);
        try {
            handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
            Assert.fail((String)"Should throw exception as it was instructed to do so");
        }
        catch (ProcessWorkItemHandlerException ex) {
            Assert.assertEquals((Object)"Unable to create client for web service someInterface - someOperation", (Object)ex.getCause().getMessage());
            Assert.assertEquals((Object)"test", (Object)ex.getProcessId());
            Assert.assertEquals((Object)"COMPLETE", (Object)ex.getStrategy().name());
        }
    }
}

