/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.endpoint.Client;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.TestWorkItemManager;
import org.jbpm.process.workitem.webservice.WebServiceWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WebServiceWorkItemHandlerTest {
    @Mock
    KieSession kieSession;
    @Mock
    Client client;
    @Mock
    ConcurrentHashMap<String, Client> clients;

    @Test
    public void testExecuteSyncOperation() throws Exception {
        Mockito.when((Object)this.clients.containsKey(Mockito.anyObject())).thenReturn((Object)true);
        Mockito.when((Object)this.clients.get(Mockito.anyObject())).thenReturn((Object)this.client);
        TestWorkItemManager manager = new TestWorkItemManager();
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Interface", (Object)"someInterface");
        workItem.setParameter("Operation", (Object)"someOperation");
        workItem.setParameter("Parameter", (Object)"myParam");
        workItem.setParameter("Mode", (Object)"SYNC");
        WebServiceWorkItemHandler handler = new WebServiceWorkItemHandler(this.kieSession);
        handler.setClients(this.clients);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertNotNull((Object)manager.getResults());
        Assert.assertEquals((long)1L, (long)manager.getResults().size());
        Assert.assertTrue((boolean)manager.getResults().containsKey(workItem.getId()));
    }
}

