/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.workitem.email;

import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.drools.process.workitem.email.Connection;
import org.drools.process.workitem.email.Email;
import org.drools.process.workitem.email.Message;
import org.drools.process.workitem.email.Recipient;

public class SendHtml {
    public static void sendHtml(Email email) {
        Message message = email.getMessage();
        Connection connection = email.getConnection();
        String subject = message.getSubject();
        String from = message.getFrom();
        String replyTo = message.getReplyTo();
        String mailhost = connection.getHost();
        String username = connection.getUserName();
        String password = connection.getPassword();
        String mailer = "sendhtml";
        if (from == null) {
            throw new RuntimeException("Email must have 'from' address");
        }
        if (replyTo == null) {
            replyTo = from;
        }
        boolean debug = false;
        try {
            Properties props = new Properties();
            if (mailhost != null && mailhost.trim().length() > 0) {
                props.setProperty("mail.smtp.host", mailhost);
            }
            if (connection.getPort() != null && connection.getPort().trim().length() > 0) {
                props.setProperty("mail.smtp.port", connection.getPort());
            }
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(debug);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(replyTo)});
            for (Recipient recipient : message.getRecipients().getRecipients()) {
                Message.RecipientType type = null;
                if ("To".equals(recipient.getType())) {
                    type = Message.RecipientType.TO;
                } else if ("Cc".equals(recipient.getType())) {
                    type = Message.RecipientType.CC;
                } else if ("Bcc".equals(recipient.getType())) {
                    type = Message.RecipientType.BCC;
                } else {
                    throw new RuntimeException("Unable to determine recipient type");
                }
                msg.addRecipients(type, (Address[])InternetAddress.parse((String)recipient.getEmail(), (boolean)false));
            }
            msg.setSubject(subject);
            SendHtml.collect(message.getBody(), (javax.mail.Message)msg);
            msg.setHeader("X-Mailer", mailer);
            msg.setSentDate(new Date());
            Transport t = session.getTransport("smtp");
            try {
                t.connect(mailhost, username, password);
                t.sendMessage((javax.mail.Message)msg, msg.getAllRecipients());
            }
            catch (Exception e) {
                throw new RuntimeException("Connection failure", e);
            }
            finally {
                t.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to send email", e);
        }
    }

    public static void collect(String body, javax.mail.Message msg) throws MessagingException, IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(body);
        msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(sb.toString(), "text/html")));
    }
}

