/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.workitem.transform;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.drools.process.instance.WorkItemHandler;
import org.drools.process.workitem.transform.Transformer;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformWorkItemHandler
implements WorkItemHandler {
    private static String INPUT_KEY = "InputObject";
    private static String OUTPUT_TYPE_KEY = "OutputType";
    private static String VARIABLE_OUTPUT_NAME = "OutputObject";
    private Map<Class<?>, Map<Class<?>, Method>> transforms = new HashMap();

    public void executeWorkItem(WorkItem inputItem, WorkItemManager itemMgr) {
        try {
            Object in = inputItem.getParameter(INPUT_KEY);
            String outputType = (String)inputItem.getParameter(OUTPUT_TYPE_KEY);
            Object output = Class.forName(outputType).newInstance();
            Method txMethod = this.findTransform(output.getClass(), in.getClass());
            if (txMethod != null) {
                Object out = txMethod.invoke(null, in);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(VARIABLE_OUTPUT_NAME, out);
                itemMgr.completeWorkItem(inputItem.getId(), result);
            } else {
                System.err.println("Failed to find a transform ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerTransformer(Class<?> transformer) {
        Method[] methods = transformer.getMethods();
        if (methods == null) {
            return;
        }
        for (Method meth : methods) {
            if (meth.getAnnotation(Transformer.class) == null) continue;
            Class<?> returnType = meth.getReturnType();
            Class<?> paramType = meth.getParameterTypes()[0];
            Map<Class<?>, Method> index = this.transforms.get(returnType);
            if (index == null) {
                index = new HashMap();
                this.transforms.put(returnType, index);
            }
            index.put(paramType, meth);
        }
    }

    private Method findTransform(Class<?> returnClass, Class<?> paramClass) {
        Map<Class<?>, Method> indexedTxForm = this.transforms.get(returnClass);
        if (indexedTxForm == null) {
            return null;
        }
        return indexedTxForm.get(paramClass);
    }

    public void abortWorkItem(WorkItem arg0, WorkItemManager arg1) {
    }
}

