/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.core.Bpmn2Import;
import org.jbpm.process.workitem.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    public static final String WSDL_IMPORT_TYPE = "http://schemas.xmlsoap.org/wsdl/";
    private static Logger logger = LoggerFactory.getLogger(WebServiceWorkItemHandler.class);
    private ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    private JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
    private KieSession ksession;
    private int asyncTimeout = 10;
    private ClassLoader classLoader;

    public WebServiceWorkItemHandler(KieSession ksession) {
        this.ksession = ksession;
    }

    public WebServiceWorkItemHandler(KieSession ksession, ClassLoader classloader) {
        this.ksession = ksession;
        this.classLoader = classloader;
    }

    public WebServiceWorkItemHandler(KieSession ksession, int timeout) {
        this.ksession = ksession;
        this.asyncTimeout = timeout;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Object[] parameters = null;
        String interfaceRef = (String)workItem.getParameter("Interface");
        String operationRef = (String)workItem.getParameter("Operation");
        String endpointAddress = (String)workItem.getParameter("Endpoint");
        if (workItem.getParameter("Parameter") instanceof Object[]) {
            parameters = (Object[])workItem.getParameter("Parameter");
        } else if (workItem.getParameter("Parameter") != null && workItem.getParameter("Parameter").getClass().isArray()) {
            int length = Array.getLength(workItem.getParameter("Parameter"));
            parameters = new Object[length];
            for (int i = 0; i < length; ++i) {
                parameters[i] = Array.get(workItem.getParameter("Parameter"), i);
            }
        } else {
            parameters = new Object[]{workItem.getParameter("Parameter")};
        }
        String modeParam = (String)workItem.getParameter("Mode");
        WSMode mode = WSMode.valueOf(modeParam == null ? "SYNC" : modeParam.toUpperCase());
        try {
            Client client = this.getWSClient(workItem, interfaceRef);
            if (client == null) {
                throw new IllegalStateException("Unable to create client for web service " + interfaceRef + " - " + operationRef);
            }
            if (endpointAddress != null && !"".equals(endpointAddress)) {
                client.getRequestContext().put(Message.ENDPOINT_ADDRESS, endpointAddress);
            }
            switch (mode) {
                case SYNC: {
                    Object[] result = client.invoke(operationRef, parameters);
                    HashMap<String, Object> output = new HashMap<String, Object>();
                    if (result == null || result.length == 0) {
                        output.put("Result", null);
                    } else {
                        output.put("Result", result[0]);
                    }
                    logger.debug("Received sync response {} completeing work item {}", (Object)result, (Object)workItem.getId());
                    manager.completeWorkItem(workItem.getId(), output);
                    break;
                }
                case ASYNC: {
                    final ClientCallback callback = new ClientCallback();
                    final long workItemId = workItem.getId();
                    client.invoke(callback, operationRef, parameters);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Object[] result = callback.get((long)WebServiceWorkItemHandler.this.asyncTimeout, TimeUnit.SECONDS);
                                HashMap<String, Object> output = new HashMap<String, Object>();
                                if (callback.isDone()) {
                                    if (result == null) {
                                        output.put("Result", null);
                                    } else {
                                        output.put("Result", result[0]);
                                    }
                                }
                                logger.debug("Received async response {} completeing work item {}", (Object)result, (Object)workItemId);
                                WebServiceWorkItemHandler.this.ksession.getWorkItemManager().completeWorkItem(workItemId, output);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new RuntimeException("Error encountered while invoking ws operation asynchronously", e);
                            }
                        }
                    }).start();
                    break;
                }
                case ONEWAY: {
                    ClientCallback callbackFF = new ClientCallback();
                    client.invoke(callbackFF, operationRef, parameters);
                    logger.debug("One way operation, not going to wait for response, completing work item {}", (Object)workItem.getId());
                    manager.completeWorkItem(workItem.getId(), new HashMap());
                    break;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected synchronized Client getWSClient(WorkItem workItem, String interfaceRef) {
        if (this.clients.containsKey(interfaceRef)) {
            return this.clients.get(interfaceRef);
        }
        String importLocation = (String)workItem.getParameter("Url");
        String importNamespace = (String)workItem.getParameter("Namespace");
        if (importLocation != null && importLocation.trim().length() > 0 && importNamespace != null && importNamespace.trim().length() > 0) {
            Client client = this.dcf.createClient(importLocation, new QName(importNamespace, interfaceRef), this.getInternalClassLoader(), null);
            this.clients.put(interfaceRef, client);
            return client;
        }
        long processInstanceId = ((WorkItemImpl)workItem).getProcessInstanceId();
        WorkflowProcessImpl process = (WorkflowProcessImpl)this.ksession.getProcessInstance(processInstanceId).getProcess();
        List typedImports = (List)process.getMetaData("Bpmn2Imports");
        if (typedImports != null) {
            Client client = null;
            for (Bpmn2Import importObj : typedImports) {
                if (!WSDL_IMPORT_TYPE.equalsIgnoreCase(importObj.getType())) continue;
                try {
                    client = this.dcf.createClient(importObj.getLocation(), new QName(importObj.getNamespace(), interfaceRef), this.getInternalClassLoader(), null);
                    this.clients.put(interfaceRef, client);
                    return client;
                }
                catch (Exception e) {
                    logger.error("Error when creating WS Client", (Throwable)e);
                }
            }
        }
        return null;
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    private ClassLoader getInternalClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    static enum WSMode {
        SYNC,
        ASYNC,
        ONEWAY;

    }
}

