/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.rest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jbpm.process.workitem.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.rest.RESTServiceException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTWorkItemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(RESTWorkItemHandler.class);
    private String username;
    private String password;
    private AuthenticationType type;
    private String authUrl;
    protected static boolean HTTP_CLIENT_API_43 = true;

    public RESTWorkItemHandler() {
        logger.debug("REST work item handler will use http client 4.3 api " + HTTP_CLIENT_API_43);
        this.type = AuthenticationType.NONE;
    }

    public RESTWorkItemHandler(String username, String password) {
        this();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.BASIC;
    }

    public RESTWorkItemHandler(String username, String password, String authUrl) {
        this();
        this.username = username;
        this.password = password;
        this.type = AuthenticationType.FORM_BASED;
        this.authUrl = authUrl;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Integer readTimeout;
        Integer connectTimeout;
        boolean handleException = false;
        String urlStr = (String)workItem.getParameter("Url");
        String method = (String)workItem.getParameter("Method");
        String handleExceptionStr = (String)workItem.getParameter("HandleResponseErrors");
        if (urlStr == null) {
            throw new IllegalArgumentException("Url is a required parameter");
        }
        if (method == null || method.trim().length() == 0) {
            method = "GET";
        }
        if (handleExceptionStr != null) {
            handleException = Boolean.parseBoolean(handleExceptionStr);
        }
        Map params = workItem.getParameters();
        AuthenticationType authType = this.type;
        if (params.get("AuthType") != null) {
            authType = AuthenticationType.valueOf((String)params.get("AuthType"));
        }
        if ((connectTimeout = this.getParamAsInt(params.get("ConnectTimeout"))) == null) {
            connectTimeout = 60000;
        }
        if ((readTimeout = this.getParamAsInt(params.get("ReadTimeout"))) == null) {
            readTimeout = 60000;
        }
        HttpClient httpClient = this.getHttpClient(readTimeout, connectTimeout);
        Object methodObject = this.configureRequest(method, urlStr, params);
        try {
            HttpResponse response = this.doRequestWithAuthorization(httpClient, methodObject, (Map<String, Object>)params, authType);
            StatusLine statusLine = response.getStatusLine();
            int responseCode = statusLine.getStatusCode();
            HashMap<String, Object> results = new HashMap<String, Object>();
            HttpEntity respEntity = response.getEntity();
            String responseBody = null;
            if (respEntity != null) {
                responseBody = EntityUtils.toString((HttpEntity)respEntity);
            }
            if (responseCode >= 200 && responseCode < 300) {
                this.postProcessResult(responseBody, results);
                results.put("StatusMsg", "request to endpoint " + urlStr + " successfully completed " + statusLine.getReasonPhrase());
            } else if (handleException) {
                this.handleException(new RESTServiceException(responseCode, responseBody, urlStr));
            } else {
                logger.warn("Unsuccessful response from REST server (status: {}, endpoint: {}, response: {}", new Object[]{responseCode, urlStr, responseBody});
                results.put("StatusMsg", "endpoint " + urlStr + " could not be reached: " + responseBody);
            }
            results.put("Status", responseCode);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            try {
                this.close(httpClient, methodObject);
            }
            catch (Exception e) {}
        }
    }

    protected Integer getParamAsInt(Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof String && !((String)param).isEmpty()) {
            return Integer.parseInt((String)param);
        }
        if (param instanceof Number) {
            return ((Number)param).intValue();
        }
        return null;
    }

    protected void setBody(RequestBuilder builder, Map<String, Object> params) {
        if (params.containsKey("Content")) {
            try {
                String content = (String)params.get("Content");
                StringEntity entity = new StringEntity(content);
                String contentType = (String)params.get("ContentType");
                entity.setContentType(contentType);
                builder.setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Cannot set body for REST request [" + builder.getMethod() + "] " + builder.getUri(), e);
            }
        }
    }

    protected void setBody(HttpRequestBase theMethod, Map<String, Object> params) {
        if (params.containsKey("Content")) {
            ((HttpEntityEnclosingRequestBase)theMethod).setEntity((HttpEntity)new StringEntity((String)params.get("Content"), ContentType.create((String)((String)params.get("ContentType")))));
        }
    }

    protected void postProcessResult(String result, Map<String, Object> results) {
        results.put("Result", result);
    }

    protected HttpResponse doRequestWithAuthorization(HttpClient httpclient, Object method, Map<String, Object> params, AuthenticationType authType) {
        if (HTTP_CLIENT_API_43) {
            return this.doRequestWithAuthorization(httpclient, (RequestBuilder)method, params, authType);
        }
        return this.doRequestWithAuthorization(httpclient, (HttpRequestBase)method, params, authType);
    }

    protected HttpResponse doRequestWithAuthorization(HttpClient httpclient, RequestBuilder requestBuilder, Map<String, Object> params, AuthenticationType type) {
        if (type == null || type == AuthenticationType.NONE) {
            HttpUriRequest request = requestBuilder.build();
            try {
                return httpclient.execute(request);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + request.getMethod() + "] " + request.getURI(), e);
            }
        }
        String u = (String)params.get("Username");
        String p = (String)params.get("Password");
        if (u == null || p == null) {
            u = this.username;
            p = this.password;
        }
        if (u == null) {
            throw new IllegalArgumentException("Could not find username");
        }
        if (p == null) {
            throw new IllegalArgumentException("Could not find password");
        }
        if (type == AuthenticationType.BASIC) {
            URI requestUri = requestBuilder.getUri();
            HttpHost targetHost = new HttpHost(requestUri.getHost(), requestUri.getPort(), requestUri.getScheme());
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            HttpClientContext clientContext = HttpClientContext.create();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(requestUri.getHost(), requestUri.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(u, p));
            clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
            clientContext.setAuthCache((AuthCache)authCache);
            HttpUriRequest request = requestBuilder.build();
            try {
                return httpclient.execute(targetHost, (HttpRequest)request, (HttpContext)clientContext);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request with preemptive authentication [" + request.getMethod() + "] " + request.getURI(), e);
            }
        }
        if (type == AuthenticationType.FORM_BASED) {
            UrlEncodedFormEntity formEntity;
            String authUrlStr;
            HttpUriRequest request = requestBuilder.build();
            int statusCode = -1;
            try {
                HttpResponse initialResponse = httpclient.execute(request);
                statusCode = initialResponse.getStatusLine().getStatusCode();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not execute request for form-based authentication", e);
            }
            finally {
                request.abort();
            }
            if (statusCode != 401) {
                logger.error("Expected form authentication request with status {} but status on response is {}: proceeding anyways", (Object)401, (Object)statusCode);
            }
            if ((authUrlStr = (String)params.get("AuthUrl")) == null) {
                authUrlStr = this.authUrl;
            }
            if (authUrlStr == null) {
                throw new IllegalArgumentException("Could not find authentication url");
            }
            HttpPost authMethod = new HttpPost(authUrlStr);
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>(2);
            formParams.add(new BasicNameValuePair("j_username", u));
            formParams.add(new BasicNameValuePair("j_password", p));
            try {
                formEntity = new UrlEncodedFormEntity(formParams);
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("Could not encode authentication parameters into request body", uee);
            }
            authMethod.setEntity((HttpEntity)formEntity);
            try {
                httpclient.execute((HttpUriRequest)authMethod);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize form-based authentication", e);
            }
            finally {
                authMethod.releaseConnection();
            }
            request = requestBuilder.build();
            try {
                return httpclient.execute(request);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + request.getMethod() + "] " + request.getURI(), e);
            }
        }
        throw new RuntimeException("Unknown AuthenticationType " + (Object)((Object)type));
    }

    protected HttpResponse doRequestWithAuthorization(HttpClient httpclient, HttpRequestBase httpMethod, Map<String, Object> params, AuthenticationType type) {
        if (type == null || type == AuthenticationType.NONE) {
            try {
                return httpclient.execute((HttpUriRequest)httpMethod);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + httpMethod.getMethod() + "] " + httpMethod.getURI(), e);
            }
        }
        String u = (String)params.get("Username");
        String p = (String)params.get("Password");
        if (u == null || p == null) {
            u = this.username;
            p = this.password;
        }
        if (u == null) {
            throw new IllegalArgumentException("Could not find username");
        }
        if (p == null) {
            throw new IllegalArgumentException("Could not find password");
        }
        if (type == AuthenticationType.BASIC) {
            HttpHost targetHost = new HttpHost(httpMethod.getURI().getHost(), httpMethod.getURI().getPort(), httpMethod.getURI().getScheme());
            ((DefaultHttpClient)httpclient).getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(u, p));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            BasicHttpContext localcontext = new BasicHttpContext();
            localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            try {
                return httpclient.execute(targetHost, (HttpRequest)httpMethod, (HttpContext)localcontext);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + httpMethod.getMethod() + "] " + httpMethod.getURI(), e);
            }
        }
        if (type == AuthenticationType.FORM_BASED) {
            String authUrlStr = (String)params.get("AuthUrl");
            if (authUrlStr == null) {
                authUrlStr = this.authUrl;
            }
            if (authUrlStr == null) {
                throw new IllegalArgumentException("Could not find authentication url");
            }
            try {
                httpclient.execute((HttpUriRequest)httpMethod);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not execute request for form-based authentication", e);
            }
            finally {
                httpMethod.releaseConnection();
            }
            HttpPost authMethod = new HttpPost(authUrlStr);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("j_username", u));
            nvps.add(new BasicNameValuePair("j_password", p));
            authMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, Consts.UTF_8));
            try {
                httpclient.execute((HttpUriRequest)authMethod);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize form-based authentication", e);
            }
            finally {
                authMethod.releaseConnection();
            }
            try {
                return httpclient.execute((HttpUriRequest)httpMethod);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not execute request [" + httpMethod.getMethod() + "] " + httpMethod.getURI(), e);
            }
        }
        throw new RuntimeException("Unknown AuthenticationType " + (Object)((Object)type));
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    protected HttpClient getHttpClient(Integer readTimeout, Integer connectTimeout) {
        if (HTTP_CLIENT_API_43) {
            RequestConfig config = RequestConfig.custom().setSocketTimeout(readTimeout.intValue()).setConnectTimeout(connectTimeout.intValue()).setConnectionRequestTimeout(connectTimeout.intValue()).build();
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(config);
            CloseableHttpClient httpClient = clientBuilder.build();
            return httpClient;
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setIntParameter("http.socket.timeout", readTimeout.intValue());
        httpClient.getParams().setIntParameter("http.connection.timeout", connectTimeout.intValue());
        return httpClient;
    }

    protected void close(HttpClient httpClient, Object httpMethod) throws IOException {
        if (HTTP_CLIENT_API_43) {
            ((CloseableHttpClient)httpClient).close();
        } else {
            ((HttpRequestBase)httpMethod).releaseConnection();
        }
    }

    protected Object configureRequest(String method, String urlStr, Map<String, Object> params) {
        if (HTTP_CLIENT_API_43) {
            RequestBuilder builder = null;
            if ("GET".equals(method)) {
                builder = RequestBuilder.get().setUri(urlStr);
            } else if ("POST".equals(method)) {
                builder = RequestBuilder.post().setUri(urlStr);
                this.setBody(builder, params);
            } else if ("PUT".equals(method)) {
                builder = RequestBuilder.put().setUri(urlStr);
                this.setBody(builder, params);
            } else if ("DELETE".equals(method)) {
                builder = RequestBuilder.delete().setUri(urlStr);
            } else {
                throw new IllegalArgumentException("Method " + method + " is not supported");
            }
            return builder;
        }
        HttpGet theMethod = null;
        if ("GET".equals(method)) {
            theMethod = new HttpGet(urlStr);
        } else if ("POST".equals(method)) {
            theMethod = new HttpPost(urlStr);
            this.setBody((HttpRequestBase)theMethod, params);
        } else if ("PUT".equals(method)) {
            theMethod = new HttpPut(urlStr);
            this.setBody((HttpRequestBase)theMethod, params);
        } else if ("DELETE".equals(method)) {
            theMethod = new HttpDelete(urlStr);
        } else {
            throw new IllegalArgumentException("Method " + method + " is not supported");
        }
        return theMethod;
    }

    static {
        try {
            Class.forName("org.apache.http.client.methods.RequestBuilder");
            HTTP_CLIENT_API_43 = true;
        }
        catch (ClassNotFoundException e) {
            HTTP_CLIENT_API_43 = false;
        }
    }

    public static enum AuthenticationType {
        NONE,
        BASIC,
        FORM_BASED;

    }
}

