/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem;

import java.util.Collection;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public abstract class AbstractWorkItemHandler
implements WorkItemHandler {
    private StatefulKnowledgeSession ksession;

    public AbstractWorkItemHandler(StatefulKnowledgeSession ksession) {
        if (ksession == null) {
            throw new IllegalArgumentException("ksession cannot be null");
        }
        this.ksession = ksession;
    }

    public StatefulKnowledgeSession getSession() {
        return this.ksession;
    }

    public long getProcessInstanceId(WorkItem workItem) {
        return ((WorkItemImpl)workItem).getProcessInstanceId();
    }

    public ProcessInstance getProcessInstance(WorkItem workItem) {
        ProcessInstance processInstance = this.ksession.getProcessInstance(this.getProcessInstanceId(workItem));
        return processInstance;
    }

    public NodeInstance getNodeInstance(WorkItem workItem) {
        ProcessInstance processInstance = this.getProcessInstance(workItem);
        if (!(processInstance instanceof WorkflowProcessInstance)) {
            return null;
        }
        return this.findWorkItemNodeInstance(workItem.getId(), ((WorkflowProcessInstance)processInstance).getNodeInstances());
    }

    private WorkItemNodeInstance findWorkItemNodeInstance(long workItemId, Collection<NodeInstance> nodeInstances) {
        for (NodeInstance nodeInstance : nodeInstances) {
            WorkItemNodeInstance result;
            WorkItemNodeInstance workItemNodeInstance;
            org.drools.core.process.instance.WorkItem workItem;
            if (nodeInstance instanceof WorkItemNodeInstance && (workItem = (workItemNodeInstance = (WorkItemNodeInstance)nodeInstance).getWorkItem()) != null && workItemId == workItem.getId()) {
                return workItemNodeInstance;
            }
            if (!(nodeInstance instanceof NodeInstanceContainer) || (result = this.findWorkItemNodeInstance(workItemId, ((NodeInstanceContainer)nodeInstance).getNodeInstances())) == null) continue;
            return result;
        }
        return null;
    }
}

