/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.webservice;

import java.lang.reflect.Array;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.message.Message;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.process.WorkItem;
import org.kie.internal.runtime.Cacheable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceCommand
implements Command,
Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceCommand.class);
    private static volatile ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    private DynamicClientFactory dcf = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResults execute(CommandContext ctx) throws Exception {
        ClassLoader origClassloader = Thread.currentThread().getContextClassLoader();
        try {
            Object[] parameters = null;
            WorkItem workItem = (WorkItem)ctx.getData("workItem");
            String interfaceRef = (String)workItem.getParameter("Interface");
            String operationRef = (String)workItem.getParameter("Operation");
            String endpointAddress = (String)workItem.getParameter("Endpoint");
            if (workItem.getParameter("Parameter") instanceof Object[]) {
                parameters = (Object[])workItem.getParameter("Parameter");
            } else if (workItem.getParameter("Parameter") != null && workItem.getParameter("Parameter").getClass().isArray()) {
                int length = Array.getLength(workItem.getParameter("Parameter"));
                parameters = new Object[length];
                for (int i = 0; i < length; ++i) {
                    parameters[i] = Array.get(workItem.getParameter("Parameter"), i);
                }
            } else {
                parameters = new Object[]{workItem.getParameter("Parameter")};
            }
            Client client = this.getWSClient(workItem, interfaceRef, ctx);
            if (endpointAddress != null && !"".equals(endpointAddress)) {
                client.getRequestContext().put(Message.ENDPOINT_ADDRESS, endpointAddress);
            }
            Object[] result = client.invoke(operationRef, parameters);
            ExecutionResults results = new ExecutionResults();
            if (result == null || result.length == 0) {
                results.setData("Result", null);
            } else {
                results.setData("Result", result[0]);
            }
            logger.debug("Received sync response {}", result);
            ExecutionResults executionResults = results;
            return executionResults;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassloader);
        }
    }

    protected synchronized Client getWSClient(WorkItem workItem, String interfaceRef, CommandContext ctx) {
        if (clients.containsKey(interfaceRef)) {
            return clients.get(interfaceRef);
        }
        String importLocation = (String)workItem.getParameter("Url");
        String importNamespace = (String)workItem.getParameter("Namespace");
        if (importLocation != null && importLocation.trim().length() > 0 && importNamespace != null && importNamespace.trim().length() > 0) {
            Client client = this.getDynamicClientFactory(ctx).createClient(importLocation, new QName(importNamespace, interfaceRef), Thread.currentThread().getContextClassLoader(), null);
            clients.put(interfaceRef, client);
            return client;
        }
        return null;
    }

    protected synchronized DynamicClientFactory getDynamicClientFactory(CommandContext ctx) {
        if (this.dcf == null) {
            this.dcf = JaxWsDynamicClientFactory.newInstance();
        }
        return this.dcf;
    }

    public void close() {
        if (clients != null) {
            for (Client client : clients.values()) {
                client.destroy();
            }
        }
    }
}

