/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.bpmn2;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.KnowledgeBaseFactoryServiceImpl;
import org.jbpm.process.workitem.bpmn2.ServiceTaskHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.KnowledgeBaseFactoryService;

public class ServiceTaskTest
extends AbstractBaseTest {
    @Test
    public void testServiceTaskWithClassInKjar() throws Exception {
        String javaSrc = "package org.jbpm.workitems;  public class HelloService {      public String hello(String name) {          return \"Hello \" + name + \"!\";      }  }";
        KnowledgeBaseFactory.setKnowledgeBaseServiceFactory((KnowledgeBaseFactoryService)new KnowledgeBaseFactoryServiceImpl());
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(ks.newKieModuleModel().toXML()).write("src/main/resources/BPMN2-ServiceProcess.bpmn2", IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/BPMN2-ServiceProcess.bpmn2"))).write("src/main/java/org/jbpm/workitems/HelloService.java", javaSrc);
        ks.newKieBuilder(kfs).buildAll();
        KieContainer kcontainer = ks.newKieContainer(ks.getRepository().getDefaultReleaseId());
        KieSession ksession = ServiceTaskTest.createSession(kcontainer.getKieBase());
        ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler(ksession, kcontainer.getClassLoader()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("ServiceProcess", params);
        String variable = (String)processInstance.getVariable("s");
        Assert.assertEquals((Object)"Hello john!", (Object)variable);
        Assert.assertEquals((long)2L, (long)processInstance.getState());
    }

    private static KieSession createSession(KieBase kbase) {
        Properties properties = new Properties();
        properties.put("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
        properties.put("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
        KieSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)properties);
        return kbase.newKieSession(config, EnvironmentFactory.newEnvironment());
    }
}

