/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.parser;

import java.util.Map;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.parser.ParserWorkItemHandler;
import org.jbpm.process.workitem.parser.Person;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class ParserWorkItemHandlerTest {
    final int AGE = 27;
    final String NAME = "William";
    final String PERSON_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>27</age><name>William</name></person>";
    final String PERSON_JSON = "{\"name\":\"William\",\"age\":27}";
    ParserWorkItemHandler handler;

    @Before
    public void init() {
        this.handler = new ParserWorkItemHandler();
    }

    @Test
    public void testXmlToObject() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>27</age><name>William</name></person>");
        workItem.setParameter("Format", (Object)"XML");
        workItem.setParameter("Type", (Object)"org.jbpm.process.workitem.parser.Person");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)new TestWorkItemManager((WorkItem)workItem));
        Person result = (Person)workItem.getResult("Result");
        Assert.assertEquals((long)27L, (long)result.getAge());
        Assert.assertEquals((Object)"William", (Object)result.getName());
    }

    @Test
    public void testObjectToXml() {
        Person p = new Person("William", 27);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)p);
        workItem.setParameter("Format", (Object)"XML");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)new TestWorkItemManager((WorkItem)workItem));
        String result = (String)workItem.getResult("Result");
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><age>27</age><name>William</name></person>", (Object)result);
    }

    @Test
    public void testJsonToObject() {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)"{\"name\":\"William\",\"age\":27}");
        workItem.setParameter("Format", (Object)"JSON");
        workItem.setParameter("Type", (Object)"org.jbpm.process.workitem.parser.Person");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)new TestWorkItemManager((WorkItem)workItem));
        Person result = (Person)workItem.getResult("Result");
        Assert.assertEquals((long)27L, (long)result.getAge());
        Assert.assertEquals((Object)"William", (Object)result.getName());
    }

    @Test
    public void testObjectToJson() {
        Person p = new Person("William", 27);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("Input", (Object)p);
        workItem.setParameter("Format", (Object)"JSON");
        this.handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)new TestWorkItemManager((WorkItem)workItem));
        String result = (String)workItem.getResult("Result");
        Assert.assertEquals((Object)"{\"name\":\"William\",\"age\":27}", (Object)result);
    }

    private class TestWorkItemManager
    implements WorkItemManager {
        private WorkItem workItem;

        TestWorkItemManager(WorkItem workItem) {
            this.workItem = workItem;
        }

        public void completeWorkItem(long id, Map<String, Object> results) {
            ((WorkItemImpl)this.workItem).setResults(results);
        }

        public void abortWorkItem(long id) {
        }

        public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        }
    }
}

