/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.email;

import java.util.ArrayList;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.drools.core.process.instance.impl.DefaultWorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.process.workitem.email.EmailWorkItemHandler;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.utils.ChainedProperties;
import org.kie.internal.utils.ClassLoaderUtil;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class EmailWorkItemHandlerTest
extends AbstractBaseTest {
    private Wiser wiser;
    private String emailHost;
    private String emailPort;

    @Before
    public void setUp() throws Exception {
        ChainedProperties props = ChainedProperties.getChainedProperties((String)"email.conf", (ClassLoader)ClassLoaderUtil.getClassLoader(null, this.getClass(), (boolean)false));
        this.emailHost = props.getProperty("mail.smtp.host", "localhost");
        this.emailPort = props.getProperty("mail.smtp.port", "2345");
        this.wiser = new Wiser();
        this.wiser.setHostname(this.emailHost);
        this.wiser.setPort(Integer.parseInt(this.emailPort));
        this.wiser.start();
        Thread.sleep(200L);
    }

    @After
    public void tearDown() throws Exception {
        if (this.wiser != null) {
            this.wiser.getMessages().clear();
            this.wiser.stop();
            this.wiser = null;
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testSingleTo() throws Exception {
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, this.emailPort, null, null);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"person1@domain.com");
        workItem.setParameter("From", (Object)"person2@domain.com");
        workItem.setParameter("Reply-To", (Object)"person3@domain.com");
        workItem.setParameter("Subject", (Object)"Subject 1");
        workItem.setParameter("Body", (Object)"Body 1");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertEquals((long)1L, (long)this.wiser.getMessages().size());
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        String content = ((String)msg.getContent()).replace("\r\n", "");
        Assert.assertEquals((Object)workItem.getParameter("Body"), (Object)content);
        Assert.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
        Assert.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        Assert.assertEquals((Object)workItem.getParameter("To"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.CC));
        Assert.assertNull((Object)msg.getRecipients(MimeMessage.RecipientType.BCC));
    }

    @Test
    public void testSingleToWithSingleCCAndBCC() throws Exception {
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, this.emailPort, null, null);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"person1@domain.com");
        workItem.setParameter("Cc", (Object)"person2@domain.com");
        workItem.setParameter("Bcc", (Object)"person3@domain.com");
        workItem.setParameter("From", (Object)"person4@domain.com");
        workItem.setParameter("Reply-To", (Object)"person5@domain.com");
        workItem.setParameter("Subject", (Object)"Subject 1");
        workItem.setParameter("Body", (Object)"Body 1");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertEquals((long)3L, (long)this.wiser.getMessages().size());
        ArrayList<String> list = new ArrayList<String>(3);
        list.add(((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(1)).getEnvelopeReceiver());
        list.add(((WiserMessage)this.wiser.getMessages().get(2)).getEnvelopeReceiver());
        Assert.assertTrue((boolean)list.contains("person1@domain.com"));
        Assert.assertTrue((boolean)list.contains("person2@domain.com"));
        Assert.assertTrue((boolean)list.contains("person3@domain.com"));
        for (int i = 0; i < this.wiser.getMessages().size(); ++i) {
            MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(i)).getMimeMessage();
            Assert.assertEquals((Object)workItem.getParameter("From"), (Object)((WiserMessage)this.wiser.getMessages().get(i)).getEnvelopeSender());
            String content = ((String)msg.getContent()).replace("\r\n", "");
            Assert.assertEquals((Object)workItem.getParameter("Body"), (Object)content);
            Assert.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
            Assert.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
            Assert.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
            Assert.assertEquals((Object)workItem.getParameter("To"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress());
            Assert.assertEquals((Object)workItem.getParameter("Cc"), (Object)((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[0]).getAddress());
        }
    }

    @Test
    public void testMultipleToWithSingleCCAndBCC() throws Exception {
        int i;
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, this.emailPort, null, null);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"person1@domain.com; person2@domain.com");
        workItem.setParameter("Cc", (Object)"person3@domain.com; person4@domain.com");
        workItem.setParameter("Bcc", (Object)"person5@domain.com; person6@domain.com");
        workItem.setParameter("From", (Object)"person4@domain.com");
        workItem.setParameter("Reply-To", (Object)"person5@domain.com");
        workItem.setParameter("Subject", (Object)"Subject 1");
        workItem.setParameter("Body", (Object)"Body 1");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
        Assert.assertEquals((long)6L, (long)this.wiser.getMessages().size());
        ArrayList<String> list = new ArrayList<String>(6);
        for (i = 0; i < 6; ++i) {
            list.add(((WiserMessage)this.wiser.getMessages().get(i)).getEnvelopeReceiver());
        }
        for (i = 1; i < 7; ++i) {
            Assert.assertTrue((boolean)list.contains("person" + i + "@domain.com"));
        }
        MimeMessage msg = ((WiserMessage)this.wiser.getMessages().get(0)).getMimeMessage();
        Assert.assertEquals((Object)workItem.getParameter("From"), (Object)((WiserMessage)this.wiser.getMessages().get(0)).getEnvelopeSender());
        String content = ((String)msg.getContent()).replace("\r\n", "");
        Assert.assertEquals((Object)workItem.getParameter("Body"), (Object)content);
        Assert.assertEquals((Object)workItem.getParameter("Subject"), (Object)msg.getSubject());
        Assert.assertEquals((Object)workItem.getParameter("From"), (Object)((InternetAddress)msg.getFrom()[0]).getAddress());
        Assert.assertEquals((Object)workItem.getParameter("Reply-To"), (Object)((InternetAddress)msg.getReplyTo()[0]).getAddress());
        Assert.assertEquals((Object)workItem.getParameter("To"), (Object)(((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[0]).getAddress() + "; " + ((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.TO)[1]).getAddress()));
        Assert.assertEquals((Object)workItem.getParameter("Cc"), (Object)(((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[0]).getAddress() + "; " + ((InternetAddress)msg.getRecipients(MimeMessage.RecipientType.CC)[1]).getAddress()));
    }

    @Test(expected=WorkItemHandlerRuntimeException.class)
    public void testFailedExecuteToHandleException() throws Exception {
        EmailWorkItemHandler handler = new EmailWorkItemHandler();
        handler.setConnection(this.emailHost, "123", null, null);
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setParameter("To", (Object)"person1@domain.com");
        workItem.setParameter("From", (Object)"person2@domain.com");
        workItem.setParameter("Reply-To", (Object)"person3@domain.com");
        workItem.setParameter("Subject", (Object)"Subject 1");
        workItem.setParameter("Body", (Object)"Body 1");
        DefaultWorkItemManager manager = new DefaultWorkItemManager(null);
        handler.executeWorkItem((WorkItem)workItem, (WorkItemManager)manager);
    }
}

