/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.gui.TwoColumnLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.TextInputField;
import com.izforge.izpack.panels.UserInputFileFilter;
import com.izforge.izpack.panels.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257850965439886129L;
    private static final int POS_DISPLAYED = 0;
    private static final int POS_TYPE = 1;
    private static final int POS_VARIABLE = 2;
    private static final int POS_CONSTRAINTS = 3;
    private static final int POS_FIELD = 4;
    private static final int POS_PACKS = 5;
    private static final int POS_OS = 6;
    private static final int POS_TRUE = 7;
    private static final int POS_FALSE = 8;
    private static final int POS_MESSAGE = 9;
    private static final int POS_GROUP = 10;
    protected static final String ICON_KEY = "icon";
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String LANG_FILE_NAME = "userInputLang.xml";
    private static final String NODE_ID = "panel";
    private static final String FIELD_NODE_ID = "field";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String VARIABLE = "variable";
    private static final String TEXT = "txt";
    private static final String KEY = "id";
    private static final String SPEC = "spec";
    private static final String SET = "set";
    private static final String REVALIDATE = "revalidate";
    private static final String TOPBUFFER = "topBuffer";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ALIGNMENT = "align";
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String ITALICS = "italic";
    private static final String BOLD = "bold";
    private static final String SIZE = "size";
    private static final String VALIDATOR = "validator";
    private static final String PROCESSOR = "processor";
    private static final String CLASS = "class";
    private static final String FIELD_LABEL = "label";
    private static final String TITLE_FIELD = "title";
    private static final String TEXT_FIELD = "text";
    private static final String TEXT_SIZE = "size";
    private static final String STATIC_TEXT = "staticText";
    private static final String COMBO_FIELD = "combo";
    private static final String COMBO_CHOICE = "choice";
    private static final String COMBO_VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String RADIO_CHOICE = "choice";
    private static final String RADIO_VALUE = "value";
    private static final String SPACE_FIELD = "space";
    private static final String DIVIDER_FIELD = "divider";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String RULE_LAYOUT = "layout";
    private static final String RULE_SEPARATOR = "separator";
    private static final String RULE_RESULT_FORMAT = "resultFormat";
    private static final String RULE_PLAIN_STRING = "plainString";
    private static final String RULE_DISPLAY_FORMAT = "displayFormat";
    private static final String RULE_SPECIAL_SEPARATOR = "specialSeparator";
    private static final String RULE_ENCRYPTED = "processed";
    private static final String RULE_PARAM_NAME = "name";
    private static final String RULE_PARAM_VALUE = "value";
    private static final String RULE_PARAM = "param";
    private static final String PWD_FIELD = "password";
    private static final String PWD_INPUT = "pwd";
    private static final String PWD_SIZE = "size";
    private static final String SEARCH_FIELD = "search";
    private static final String FILE_FIELD = "file";
    private static final String DIR_FIELD = "dir";
    private static final String SEARCH_BUTTON_FIELD = "autodetect";
    private static final String SEARCH_CHOICE = "choice";
    private static final String SEARCH_FILENAME = "filename";
    private static final String SEARCH_RESULT = "result";
    private static final String SEARCH_VALUE = "value";
    private static final String SEARCH_TYPE = "type";
    private static final String SEARCH_FILE = "file";
    private static final String SEARCH_DIRECTORY = "directory";
    private static final String SEARCH_PARENTDIR = "parentdir";
    private static final String SEARCH_CHECKFILENAME = "checkfilename";
    private static final String SELECTEDPACKS = "createForPack";
    private static final String UNSELECTEDPACKS = "createForUnselectedPack";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    protected static final String VARIABLE_NODE = "variable";
    protected static final String ATTRIBUTE_VARIABLE_NAME = "name";
    protected static final String ATTRIBUTE_VARIABLE_VALUE = "value";
    private static final String NAME = "name";
    private static final String OS = "os";
    private static final String FAMILY = "family";
    private static final String FIELD_BUTTON = "button";
    private static int instanceCount = 0;
    protected int instanceNumber = 0;
    private boolean packsDefined = false;
    private InstallerFrame parentFrame;
    private XMLElement spec;
    private boolean haveSpec = false;
    private Vector<Object[]> uiElements = new Vector();
    private Vector<ButtonGroup> buttonGroups = new Vector();
    private Vector<PasswordGroup> passwordGroups = new Vector();
    private Vector passwordGroupsRead = new Vector();
    private Vector<SearchField> searchFields = new Vector();
    private Vector<TextValuePair> entries = new Vector();
    private LocaleDatabase langpack = null;
    private boolean validating = true;
    private String currentDirectoryPath = null;

    public UserInputPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.instanceNumber = instanceCount++;
        this.parentFrame = installerFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        TwoColumnLayout twoColumnLayout;
        super.removeAll();
        this.uiElements.clear();
        try {
            this.langpack = (LocaleDatabase)this.parent.langpack.clone();
            String string = "userInputLang.xml_" + this.idata.localeISO3;
            this.langpack.add(ResourceManager.getInstance().getInputStream(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.readSpec();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        int n = 25;
        try {
            n = Integer.parseInt(this.spec.getAttribute(TOPBUFFER));
        }
        catch (Exception exception) {
        }
        finally {
            twoColumnLayout = new TwoColumnLayout(10, 5, 30, n, 0);
        }
        this.setLayout(twoColumnLayout);
        if (!this.haveSpec) {
            return;
        }
        this.updateVariables();
        Vector<XMLElement> vector = this.spec.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < vector.size(); ++i) {
            XMLElement xMLElement = vector.elementAt(i);
            String string = xMLElement.getAttribute("type");
            String string2 = xMLElement.getAttribute(ATTRIBUTE_CONDITIONID_NAME);
            if (string2 != null && !this.parent.getRules().isConditionTrue(string2, this.idata.getVariables()) || string == null) continue;
            if (string.equals(RULE_FIELD)) {
                this.addRuleField(xMLElement);
                continue;
            }
            if (string.equals(TEXT_FIELD)) {
                this.addTextField(xMLElement);
                continue;
            }
            if (string.equals(COMBO_FIELD)) {
                this.addComboBox(xMLElement);
                continue;
            }
            if (string.equals(RADIO_FIELD)) {
                this.addRadioButton(xMLElement);
                continue;
            }
            if (string.equals(PWD_FIELD)) {
                this.addPasswordField(xMLElement);
                continue;
            }
            if (string.equals(SPACE_FIELD)) {
                this.addSpace(xMLElement);
                continue;
            }
            if (string.equals(DIVIDER_FIELD)) {
                this.addDivider(xMLElement);
                continue;
            }
            if (string.equals(CHECK_FIELD)) {
                this.addCheckBox(xMLElement);
                continue;
            }
            if (string.equals(STATIC_TEXT)) {
                this.addText(xMLElement);
                continue;
            }
            if (string.equals(TITLE_FIELD)) {
                this.addTitle(xMLElement);
                continue;
            }
            if (string.equals(SEARCH_FIELD)) {
                this.addSearch(xMLElement);
                continue;
            }
            if (string.equals("file")) {
                this.addFileField(xMLElement);
                continue;
            }
            if (!string.equals(DIR_FIELD)) continue;
            this.addDirectoryField(xMLElement);
        }
    }

    private void addDirectoryField(XMLElement xMLElement) {
        int n;
        Serializable serializable;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        String string = null;
        String string2 = null;
        String string3 = xMLElement.getAttribute("variable");
        if (string3 == null || string3.length() == 0) {
            return;
        }
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        if (xMLElement2 == null) {
            Debug.trace("Error: no spec element defined in file field");
            return;
        }
        JLabel jLabel = new JLabel(this.getText(xMLElement2));
        String string4 = xMLElement2.getAttribute(SET);
        if (string4 == null) {
            string4 = this.idata.getVariable(string3);
            if (string4 == null) {
                string4 = "";
            }
        } else if (string4 != null && !"".equals(string4)) {
            serializable = new VariableSubstitutor(this.idata.getVariables());
            string4 = ((VariableSubstitutor)serializable).substitute(string4, null);
        }
        try {
            n = Integer.parseInt(xMLElement2.getAttribute("size"));
        }
        catch (Throwable throwable) {
            n = 1;
        }
        string = xMLElement2.getAttribute("fileext");
        if (string == null) {
            string = "";
        }
        if ((string2 = xMLElement2.getAttribute("fileextdesc")) == null) {
            string2 = "";
        }
        string2 = this.idata.langpack.getString(string2);
        serializable = new JTextField(string4, n);
        ((JTextComponent)serializable).setCaretPosition(0);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, twoColumnConstraints, jLabel, vector, vector2});
        TwoColumnConstraints twoColumnConstraints2 = new TwoColumnConstraints();
        twoColumnConstraints2.position = 26;
        JButton jButton = ButtonFactory.createButton(this.idata.langpack.getString("UserInputPanel.search.browse"), this.idata.buttonsHColor);
        jButton.addActionListener(new ActionListener((JTextField)serializable){
            final /* synthetic */ JTextField val$filetxt;
            {
                this.val$filetxt = jTextField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Show dirchooser");
                JFileChooser jFileChooser = new JFileChooser(UserInputPanel.this.currentDirectoryPath);
                jFileChooser.setFileSelectionMode(1);
                if (jFileChooser.showOpenDialog(UserInputPanel.this.parentFrame) == 0) {
                    this.val$filetxt.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    UserInputPanel.this.currentDirectoryPath = jFileChooser.getSelectedFile().getAbsolutePath();
                    Debug.trace("Setting current file chooser directory to: " + UserInputPanel.this.currentDirectoryPath);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add((Component)serializable);
        jPanel.add(jButton);
        this.uiElements.add(new Object[]{null, DIR_FIELD, string3, twoColumnConstraints2, jPanel, vector, vector2});
    }

    private void addFileField(XMLElement xMLElement) {
        int n;
        Serializable serializable;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        String string = null;
        String string2 = null;
        String string3 = xMLElement.getAttribute("variable");
        if (string3 == null || string3.length() == 0) {
            return;
        }
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        if (xMLElement2 == null) {
            Debug.trace("Error: no spec element defined in file field");
            return;
        }
        JLabel jLabel = new JLabel(this.getText(xMLElement2));
        String string4 = xMLElement2.getAttribute(SET);
        if (string4 == null) {
            string4 = this.idata.getVariable(string3);
            if (string4 == null) {
                string4 = "";
            }
        } else if (string4 != null && !"".equals(string4)) {
            serializable = new VariableSubstitutor(this.idata.getVariables());
            string4 = ((VariableSubstitutor)serializable).substitute(string4, null);
        }
        try {
            n = Integer.parseInt(xMLElement2.getAttribute("size"));
        }
        catch (Throwable throwable) {
            n = 1;
        }
        string = xMLElement2.getAttribute("fileext");
        if (string == null) {
            string = "";
        }
        if ((string2 = xMLElement2.getAttribute("fileextdesc")) == null) {
            string2 = "";
        }
        string2 = this.idata.langpack.getString(string2);
        serializable = new JTextField(string4, n);
        ((JTextComponent)serializable).setCaretPosition(0);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, twoColumnConstraints, jLabel, vector, vector2});
        TwoColumnConstraints twoColumnConstraints2 = new TwoColumnConstraints();
        twoColumnConstraints2.position = 26;
        final UserInputFileFilter userInputFileFilter = new UserInputFileFilter();
        userInputFileFilter.setFileExt(string);
        userInputFileFilter.setFileExtDesc(string2);
        JButton jButton = ButtonFactory.createButton(this.idata.langpack.getString("UserInputPanel.search.browse"), this.idata.buttonsHColor);
        jButton.addActionListener(new ActionListener((JTextField)serializable){
            final /* synthetic */ JTextField val$filetxt;
            {
                this.val$filetxt = jTextField;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Show filechooser");
                JFileChooser jFileChooser = new JFileChooser(UserInputPanel.this.currentDirectoryPath);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(userInputFileFilter);
                if (jFileChooser.showOpenDialog(UserInputPanel.this.parentFrame) == 0) {
                    this.val$filetxt.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    UserInputPanel.this.currentDirectoryPath = jFileChooser.getSelectedFile().getParent();
                    Debug.trace("Setting current file chooser directory to: " + UserInputPanel.this.currentDirectoryPath);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add((Component)serializable);
        jPanel.add(jButton);
        this.uiElements.add(new Object[]{null, "file", string3, twoColumnConstraints2, jPanel, vector, vector2});
    }

    protected void updateUIElements() {
        boolean bl = false;
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        for (int i = 0; i < this.uiElements.size(); ++i) {
            JComponent jComponent;
            Object[] objectArray = this.uiElements.get(i);
            if (objectArray[2] == null) continue;
            String string = this.idata.getVariable((String)objectArray[2]);
            if (RADIO_FIELD.equals(objectArray[1])) {
                jComponent = (JRadioButton)objectArray[4];
                if (string == null) continue;
                if (string.equals(objectArray[7])) {
                    ((AbstractButton)jComponent).setSelected(true);
                } else {
                    ((AbstractButton)jComponent).setSelected(false);
                }
                objectArray[4] = jComponent;
            } else if (TEXT_FIELD.equals(objectArray[1])) {
                jComponent = (TextInputField)objectArray[4];
                if (string == null) {
                    string = ((TextInputField)jComponent).getText();
                }
                ((TextInputField)jComponent).setText(variableSubstitutor.substitute(string, null));
                objectArray[4] = jComponent;
            } else if (!CHECK_FIELD.equals(objectArray[1]) && !SEARCH_FIELD.equals(objectArray[1])) {
                if (RULE_FIELD.equals(objectArray[1])) {
                    jComponent = (RuleInputField)objectArray[4];
                    if (string == null) {
                        string = ((RuleInputField)jComponent).getText();
                    }
                } else if (FIELD_BUTTON.equals(objectArray[1])) {
                    // empty if block
                }
            }
            this.uiElements.set(i, objectArray);
            bl = true;
        }
        if (bl) {
            super.invalidate();
        }
    }

    @Override
    public boolean isValidated() {
        return this.readInput();
    }

    @Override
    public void panelActivate() {
        this.init();
        if (this.spec == null) {
            this.emitError("User input specification could not be found.", "The specification for the user input panel could not be found. Please contact the packager.");
            this.parentFrame.skipPanel();
        }
        this.updateUIElements();
        Vector<XMLElement> vector = this.spec.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = this.spec.getChildrenNamed(UNSELECTEDPACKS);
        Vector<XMLElement> vector3 = this.spec.getChildrenNamed(OS);
        if (!(this.itemRequiredFor(vector) && this.itemRequiredForUnselected(vector2) && this.itemRequiredForOs(vector3))) {
            this.parentFrame.skipPanel();
            return;
        }
        if (!this.haveSpec) {
            this.parentFrame.skipPanel();
            return;
        }
        this.buildUI();
        this.setSize(this.getMaximumSize().width, this.getMaximumSize().height);
        this.validate();
        if (this.packsDefined) {
            this.parentFrame.lockPrevButton();
        }
    }

    @Override
    public void makeXMLData(XMLElement xMLElement) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.entries.size(); ++i) {
            TextValuePair textValuePair = this.entries.elementAt(i);
            String string = textValuePair.toString();
            hashMap.put(string, this.idata.getVariable(string));
        }
        new UserInputPanelAutomationHelper(hashMap).makeXMLData(this.idata, xMLElement);
    }

    private void buildUI() {
        for (int i = 0; i < this.uiElements.size(); ++i) {
            Object[] objectArray = this.uiElements.elementAt(i);
            if (this.itemRequiredFor((Vector)objectArray[5]) && this.itemRequiredForOs((Vector)objectArray[6])) {
                try {
                    if (objectArray[0] == null || FALSE.equals(objectArray[0].toString())) {
                        this.add((Component)((JComponent)objectArray[4]), objectArray[3]);
                    }
                    objectArray[0] = true;
                    this.uiElements.remove(i);
                    this.uiElements.add(i, objectArray);
                }
                catch (Throwable throwable) {
                    System.out.println("Internal format error in field: " + objectArray[1].toString());
                }
                continue;
            }
            try {
                if (objectArray[0] != null && TRUE.equals(objectArray[0].toString())) {
                    this.remove((JComponent)objectArray[4]);
                }
            }
            catch (Throwable throwable) {
                System.out.println("Internal format error in field: " + objectArray[1].toString());
            }
            objectArray[0] = false;
            this.uiElements.remove(i);
            this.uiElements.add(i, objectArray);
        }
    }

    private boolean readInput() {
        String string = null;
        Object[] objectArray = null;
        this.passwordGroupsRead.clear();
        for (int i = 0; i < this.uiElements.size(); ++i) {
            boolean bl;
            objectArray = this.uiElements.elementAt(i);
            if (objectArray == null || !((Boolean)objectArray[0]).booleanValue()) continue;
            string = (String)objectArray[1];
            if (string.equals(RULE_FIELD) && !(bl = this.readRuleField(objectArray))) {
                return false;
            }
            if (!(string.equals(PWD_FIELD) ? !(bl = this.readPasswordField(objectArray)) : (string.equals(TEXT_FIELD) ? !(bl = this.readTextField(objectArray)) : (string.equals(COMBO_FIELD) ? !(bl = this.readComboBox(objectArray)) : (string.equals(RADIO_FIELD) ? !(bl = this.readRadioButton(objectArray)) : (string.equals(CHECK_FIELD) ? !(bl = this.readCheckBox(objectArray)) : (string.equals(SEARCH_FIELD) ? !(bl = this.readSearch(objectArray)) : (string.equals("file") ? !(bl = this.readFileField(objectArray)) : string.equals(DIR_FIELD) && !(bl = this.readDirectoryField(objectArray)))))))))) continue;
            return false;
        }
        return true;
    }

    private boolean readDirectoryField(Object[] objectArray) {
        try {
            JPanel jPanel = (JPanel)objectArray[4];
            JTextField jTextField = (JTextField)jPanel.getComponent(0);
            String string = jTextField.getText();
            if (string != null) {
                File file = new File(string);
                if (file.isDirectory()) {
                    this.idata.setVariable((String)objectArray[2], string);
                    this.entries.add(new TextValuePair((String)objectArray[2], string));
                    return true;
                }
                this.showMessage("dir.notdirectory");
                return false;
            }
            this.showMessage("dir.nodirectory");
            return false;
        }
        catch (Exception exception) {
            if (Debug.stackTracing()) {
                Debug.trace(exception);
            }
            return false;
        }
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this.parent, this.parent.langpack.getString("UserInputPanel." + string + ".message"), this.parent.langpack.getString("UserInputPanel." + string + ".caption"), 2);
    }

    private boolean readFileField(Object[] objectArray) {
        try {
            JPanel jPanel = (JPanel)objectArray[4];
            JTextField jTextField = (JTextField)jPanel.getComponent(0);
            String string = jTextField.getText();
            if (string != null) {
                File file = new File(string);
                if (file.isFile()) {
                    this.idata.setVariable((String)objectArray[2], string);
                    this.entries.add(new TextValuePair((String)objectArray[2], string));
                    return true;
                }
                this.showMessage("file.notfile");
                return false;
            }
            this.showMessage("file.nofile");
            return false;
        }
        catch (Exception exception) {
            if (Debug.stackTracing()) {
                Debug.trace(exception);
            }
            return false;
        }
    }

    private void readSpec() throws Exception {
        InputStream inputStream = null;
        String string = Integer.toString(this.instanceNumber);
        String string2 = null;
        Panel panel = this.getMetadata();
        if (panel != null) {
            string2 = panel.getPanelid();
        }
        try {
            inputStream = this.parentFrame.getResource(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            this.haveSpec = false;
            return;
        }
        if (inputStream == null) {
            this.haveSpec = false;
            return;
        }
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        stdXMLParser.setValidator(new NonValidator());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        XMLElement xMLElement = (XMLElement)stdXMLParser.parse();
        if (xMLElement.hasChildren()) {
            Vector<XMLElement> vector = xMLElement.getChildrenNamed(NODE_ID);
            for (int i = 0; i < vector.size(); ++i) {
                xMLElement = vector.elementAt(i);
                String string3 = xMLElement.getAttribute(INSTANCE_IDENTIFIER);
                String string4 = xMLElement.getAttribute("id");
                if ((string3 == null || !string.equals(string3)) && (string4 == null || string2 == null || !string2.equals(string4))) continue;
                this.spec = xMLElement;
                inputStream.close();
                this.haveSpec = true;
                return;
            }
            this.haveSpec = false;
            return;
        }
        this.haveSpec = false;
    }

    private void addTitle(XMLElement xMLElement) {
        String string = this.getText(xMLElement);
        boolean bl = this.getBoolean(xMLElement, ITALICS, false);
        boolean bl2 = this.getBoolean(xMLElement, BOLD, false);
        float f = this.getFloat(xMLElement, "size", 2.0f);
        int n = this.getAlignment(xMLElement);
        String string2 = this.getIconName(xMLElement);
        if (string != null) {
            JLabel jLabel = null;
            ImageIcon imageIcon = null;
            try {
                imageIcon = this.parent.icons.getImageIcon(string2);
                jLabel = LabelFactory.create(string, imageIcon, 11, true);
            }
            catch (Exception exception) {
                Debug.trace("Icon " + string2 + " not found in icon list. " + exception.getMessage());
                jLabel = LabelFactory.create(string);
            }
            Font font = jLabel.getFont();
            float f2 = font.getSize();
            int n2 = 0;
            if (bl2) {
                ++n2;
            }
            if (bl) {
                n2 += 2;
            }
            font = font.deriveFont(n2, f2 * f);
            jLabel.setFont(font);
            jLabel.setAlignmentX(0.0f);
            TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
            twoColumnConstraints.align = n;
            twoColumnConstraints.position = 9;
            this.add((Component)jLabel, twoColumnConstraints);
        }
    }

    protected String getIconName(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        String string = xMLElement.getAttribute(ICON_KEY);
        String string2 = null;
        if (string != null && this.langpack != null) {
            try {
                string2 = this.langpack.getString(string);
            }
            catch (Throwable throwable) {
                string2 = null;
            }
        }
        return string2;
    }

    private void addRuleField(XMLElement xMLElement) {
        Object twoColumnConstraints;
        String string;
        String string2;
        String string3;
        JLabel jLabel;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        String string4 = xMLElement.getAttribute("variable");
        RuleInputField ruleInputField = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        String string7 = null;
        String string8 = null;
        HashMap<String, String> hashMap = null;
        Vector<XMLElement> vector3 = null;
        String string9 = null;
        int n = 2;
        if (xMLElement2 != null) {
            jLabel = new JLabel(this.getText(xMLElement2));
            string3 = xMLElement2.getAttribute(RULE_LAYOUT);
            string2 = xMLElement2.getAttribute(SET);
            string = xMLElement2.getAttribute(RULE_SEPARATOR);
            String string10 = xMLElement2.getAttribute(RULE_RESULT_FORMAT);
            if (string10 != null) {
                if (string10.equals(RULE_PLAIN_STRING)) {
                    n = 1;
                } else if (string10.equals(RULE_DISPLAY_FORMAT)) {
                    n = 2;
                } else if (string10.equals(RULE_SPECIAL_SEPARATOR)) {
                    n = 3;
                } else if (string10.equals(RULE_ENCRYPTED)) {
                    n = 4;
                }
            }
        } else {
            return;
        }
        xMLElement2 = xMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(xMLElement2, vector, vector2);
        xMLElement2 = xMLElement.getFirstChildNamed(VALIDATOR);
        if (xMLElement2 != null) {
            string5 = xMLElement2.getAttribute(CLASS);
            string6 = this.getText(xMLElement2);
            vector3 = xMLElement2.getChildrenNamed(RULE_PARAM);
            if (vector3 != null && vector3.size() > 0) {
                bl = true;
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                twoColumnConstraints = vector3.iterator();
                while (twoColumnConstraints.hasNext()) {
                    XMLElement object2;
                    xMLElement2 = object2 = (XMLElement)twoColumnConstraints.next();
                    string7 = xMLElement2.getAttribute("name");
                    string8 = xMLElement2.getAttribute("value");
                    hashMap.put(string7, string8);
                }
            }
        }
        if ((xMLElement2 = xMLElement.getFirstChildNamed(PROCESSOR)) != null) {
            string9 = xMLElement2.getAttribute(CLASS);
        }
        ruleInputField = bl ? new RuleInputField(string3, string2, string, string5, hashMap, string9, n, this.getToolkit(), this.idata) : new RuleInputField(string3, string2, string, string5, string9, n, this.getToolkit(), this.idata);
        twoColumnConstraints = new TwoColumnConstraints();
        ((TwoColumnConstraints)twoColumnConstraints).position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, twoColumnConstraints, jLabel, vector, vector2});
        TwoColumnConstraints twoColumnConstraints2 = new TwoColumnConstraints();
        twoColumnConstraints2.position = 26;
        this.uiElements.add(new Object[]{null, RULE_FIELD, string4, twoColumnConstraints2, ruleInputField, vector, vector2, null, null, string6});
    }

    private boolean readRuleField(Object[] objectArray) {
        boolean bl;
        RuleInputField ruleInputField = null;
        String string = null;
        String string2 = null;
        try {
            ruleInputField = (RuleInputField)objectArray[4];
            string = (String)objectArray[2];
            string2 = (String)objectArray[9];
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || ruleInputField == null) {
            return true;
        }
        boolean bl2 = bl = !this.validating || ruleInputField.validateContents();
        if (!bl) {
            this.showWarningMessageDialog(this.parentFrame, string2);
            return false;
        }
        this.idata.setVariable(string, ruleInputField.getText());
        this.entries.add(new TextValuePair(string, ruleInputField.getText()));
        return true;
    }

    private void addTextField(XMLElement xMLElement) {
        int n;
        Iterator<XMLElement> iterator;
        String string;
        JLabel jLabel;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        HashMap<String, String> hashMap = null;
        Vector<XMLElement> vector3 = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = xMLElement.getAttribute("variable");
        if (string4 == null || string4.length() == 0) {
            return;
        }
        if (xMLElement2 != null) {
            jLabel = new JLabel(this.getText(xMLElement2));
            string = xMLElement2.getAttribute(SET);
            if (string == null) {
                string = this.idata.getVariable(string4);
                if (string == null) {
                    string = "";
                }
            } else if (string != null && !"".equals(string)) {
                iterator = new VariableSubstitutor(this.idata.getVariables());
                string = ((VariableSubstitutor)((Object)iterator)).substitute(string, null);
            }
            try {
                n = Integer.parseInt(xMLElement2.getAttribute("size"));
            }
            catch (Throwable throwable) {
                n = 1;
            }
        } else {
            Debug.trace("No specification element, returning.");
            return;
        }
        xMLElement2 = xMLElement.getFirstChildNamed(VALIDATOR);
        if (xMLElement2 != null) {
            string2 = xMLElement2.getAttribute(CLASS);
            Debug.trace("Validator found for text field: " + string2);
            string3 = this.getText(xMLElement2);
            vector3 = xMLElement2.getChildrenNamed(RULE_PARAM);
            if (vector3 != null && vector3.size() > 0) {
                Debug.trace("Validator has " + vector3.size() + " parameters.");
                bl = true;
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                iterator = vector3.iterator();
                while (iterator.hasNext()) {
                    XMLElement object2;
                    xMLElement2 = object2 = iterator.next();
                    String string5 = xMLElement2.getAttribute("name");
                    String string6 = xMLElement2.getAttribute("value");
                    hashMap.put(string5, string6);
                }
            }
        }
        xMLElement2 = xMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(xMLElement2, vector, vector2);
        TextInputField textInputField = bl ? new TextInputField(string, n, string2, hashMap) : new TextInputField(string, n, string2);
        iterator = new TwoColumnConstraints();
        ((TwoColumnConstraints)((Object)iterator)).position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, iterator, jLabel, vector, vector2});
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 26;
        this.uiElements.add(new Object[]{null, TEXT_FIELD, string4, twoColumnConstraints, textInputField, vector, vector2, null, null, string3});
    }

    private boolean readTextField(Object[] objectArray) {
        TextInputField textInputField = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            textInputField = (TextInputField)objectArray[4];
            string = (String)objectArray[2];
            string3 = (String)objectArray[9];
            string2 = textInputField.getText();
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || string2 == null) {
            return true;
        }
        Debug.trace("Validating text field");
        boolean bl = textInputField.validateContents();
        if (!bl) {
            Debug.trace("Validation did not pass, message: " + string3);
            if (string3 == null) {
                string3 = "Text entered did not pass validation.";
            }
            this.showWarningMessageDialog(this.parentFrame, string3);
            return false;
        }
        Debug.trace("Field validated");
        this.idata.setVariable(string, string2);
        this.entries.add(new TextValuePair(string, string2));
        return true;
    }

    private void addComboBox(XMLElement xMLElement) {
        Object object;
        Cloneable cloneable;
        JLabel jLabel;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        String string = xMLElement.getAttribute("variable");
        TextValuePair textValuePair = null;
        JComboBox<TextValuePair> jComboBox = new JComboBox<TextValuePair>();
        boolean bl = false;
        if (xMLElement2 != null) {
            jLabel = new JLabel(this.getText(xMLElement2));
            cloneable = xMLElement2.getChildrenNamed("choice");
            if (cloneable == null) {
                return;
            }
            object = this.idata.getVariable(string);
            if (object != null) {
                bl = true;
            }
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                Object object2;
                String string2;
                String string3;
                String string4 = ((Vector)cloneable).elementAt(i).getAttribute(PROCESSOR);
                if (string4 != null && !"".equals(string4)) {
                    string3 = "";
                    try {
                        string3 = ((Processor)Class.forName(string4).newInstance()).process(null);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    string2 = ((XMLElement)((Vector)cloneable).elementAt(i)).getAttribute(SET);
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (string2 != null && !"".equals(string2)) {
                        object2 = new VariableSubstitutor(this.idata.getVariables());
                        string2 = ((VariableSubstitutor)object2).substitute(string2, null);
                    }
                    object2 = new StringTokenizer(string3, ":");
                    int n = 0;
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        String string5 = ((StringTokenizer)object2).nextToken();
                        textValuePair = new TextValuePair(string5, string5);
                        jComboBox.addItem(textValuePair);
                        if (string2.equals(string5)) {
                            jComboBox.setSelectedIndex(jComboBox.getItemCount() - 1);
                        }
                        ++n;
                    }
                    continue;
                }
                string3 = ((Vector)cloneable).elementAt(i).getAttribute("value");
                textValuePair = new TextValuePair(this.getText((XMLElement)((Vector)cloneable).elementAt(i)), string3);
                jComboBox.addItem(textValuePair);
                if (bl) {
                    if (string3 == null || string3.length() <= 0 || !((String)object).equals(string3)) continue;
                    jComboBox.setSelectedIndex(i);
                    continue;
                }
                string2 = ((XMLElement)((Vector)cloneable).elementAt(i)).getAttribute(SET);
                if (string2 == null) continue;
                if (string2 != null && !"".equals(string2)) {
                    object2 = new VariableSubstitutor(this.idata.getVariables());
                    string2 = ((VariableSubstitutor)object2).substitute(string2, null);
                }
                if (!string2.equals(TRUE)) continue;
                jComboBox.setSelectedIndex(i);
            }
        } else {
            return;
        }
        xMLElement2 = xMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(xMLElement2, vector, vector2);
        cloneable = new TwoColumnConstraints();
        ((TwoColumnConstraints)cloneable).position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, cloneable, jLabel, vector, vector2});
        object = new TwoColumnConstraints();
        ((TwoColumnConstraints)object).position = 26;
        this.uiElements.add(new Object[]{null, COMBO_FIELD, string, object, jComboBox, vector, vector2});
    }

    private boolean readComboBox(Object[] objectArray) {
        String string;
        String string2;
        try {
            string2 = (String)objectArray[2];
            JComboBox jComboBox = (JComboBox)objectArray[4];
            string = ((TextValuePair)jComboBox.getSelectedItem()).getValue();
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string2 == null || string == null) {
            return true;
        }
        this.idata.setVariable(string2, string);
        this.entries.add(new TextValuePair(string2, string));
        return true;
    }

    private void addRadioButton(XMLElement xMLElement) {
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        String string = xMLElement.getAttribute("variable");
        String string2 = null;
        XMLElement xMLElement2 = null;
        ButtonGroup buttonGroup = new ButtonGroup();
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.indent = true;
        twoColumnConstraints.stretch = true;
        xMLElement2 = xMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(xMLElement2, vector, vector2);
        xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        if (xMLElement2 != null) {
            Vector<XMLElement> vector3 = xMLElement2.getChildrenNamed("choice");
            if (vector3 == null) {
                return;
            }
            for (int i = 0; i < vector3.size(); ++i) {
                JRadioButton jRadioButton = new JRadioButton();
                jRadioButton.setText(this.getText(vector3.elementAt(i)));
                String string3 = vector3.elementAt(i).getAttribute(REVALIDATE);
                if (string3 != null && string3.equals("yes")) {
                    jRadioButton.addActionListener(this);
                }
                string2 = vector3.elementAt(i).getAttribute("value");
                buttonGroup.add(jRadioButton);
                String string4 = vector3.elementAt(i).getAttribute(SET);
                if (this.idata.getVariable(string) == null && string4 != null) {
                    this.idata.setVariable(string, string2);
                }
                if (string4 != null) {
                    if (string4 != null && !"".equals(string4)) {
                        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
                        string4 = variableSubstitutor.substitute(string4, null);
                    }
                    if (string4.equals(TRUE)) {
                        jRadioButton.setSelected(true);
                    }
                }
                this.buttonGroups.add(buttonGroup);
                this.uiElements.add(new Object[]{null, RADIO_FIELD, string, twoColumnConstraints, jRadioButton, vector, vector2, string2, null, null, buttonGroup});
            }
        }
    }

    private boolean readRadioButton(Object[] objectArray) {
        String string = null;
        String string2 = null;
        JRadioButton jRadioButton = null;
        try {
            jRadioButton = (JRadioButton)objectArray[4];
            if (!jRadioButton.isSelected()) {
                return true;
            }
            string = (String)objectArray[2];
            string2 = (String)objectArray[7];
        }
        catch (Throwable throwable) {
            return true;
        }
        this.idata.setVariable(string, string2);
        this.entries.add(new TextValuePair(string, string2));
        return true;
    }

    private void addPasswordField(XMLElement xMLElement) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        String string = xMLElement.getAttribute("variable");
        String string2 = null;
        String string3 = null;
        XMLElement xMLElement2 = null;
        PasswordGroup passwordGroup = null;
        int n = 0;
        Vector<XMLElement> vector3 = null;
        ArrayList<ValidatorContainer> arrayList = new ArrayList<ValidatorContainer>();
        int n2 = 0;
        xMLElement2 = xMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(xMLElement2, vector, vector2);
        vector3 = xMLElement.getChildrenNamed(VALIDATOR);
        if (vector3 != null && vector3.size() > 0) {
            n2 = vector3.size();
            for (int i = 0; i < n2; ++i) {
                xMLElement2 = vector3.get(i);
                object5 = xMLElement2.getAttribute(CLASS);
                string2 = this.getText(xMLElement2);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                object4 = xMLElement2.getChildrenNamed(RULE_PARAM);
                if (object4 != null && ((Vector)object4).size() > 0) {
                    object3 = ((Vector)object4).iterator();
                    while (object3.hasNext()) {
                        xMLElement2 = object3.next();
                        object2 = xMLElement2.getAttribute("name");
                        object = xMLElement2.getAttribute("value");
                        hashMap.put((String)object2, (String)object);
                    }
                }
                arrayList.add(new ValidatorContainer((String)object5, string2, hashMap));
            }
        }
        if ((xMLElement2 = xMLElement.getFirstChildNamed(PROCESSOR)) != null) {
            string3 = xMLElement2.getAttribute(CLASS);
        }
        passwordGroup = new PasswordGroup(this.idata, arrayList, string3);
        xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        if (xMLElement2 != null) {
            Vector<XMLElement> vector4 = xMLElement2.getChildrenNamed(PWD_INPUT);
            if (vector4 == null) {
                return;
            }
            for (int i = 0; i < vector4.size(); ++i) {
                object5 = vector4.elementAt(i);
                object4 = ((XMLElement)object5).getAttribute(SET);
                if (object4 != null && !"".equals(object4)) {
                    object3 = new VariableSubstitutor(this.idata.getVariables());
                    object4 = ((VariableSubstitutor)object3).substitute((String)object4, null);
                }
                object3 = new JLabel(this.getText((XMLElement)object5));
                try {
                    n = Integer.parseInt(((XMLElement)object5).getAttribute("size"));
                }
                catch (Throwable throwable) {
                    n = 1;
                }
                object2 = new JPasswordField((String)object4, n);
                ((JTextComponent)object2).setCaretPosition(0);
                object = new TwoColumnConstraints();
                ((TwoColumnConstraints)object).position = 15;
                this.uiElements.add(new Object[]{null, FIELD_LABEL, null, object, object3, vector, vector2});
                TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
                twoColumnConstraints.position = 26;
                this.uiElements.add(new Object[]{null, PWD_FIELD, string, twoColumnConstraints, object2, vector, vector2, null, null, null, passwordGroup});
                passwordGroup.addField((JPasswordField)object2);
            }
        }
        this.passwordGroups.add(passwordGroup);
    }

    private boolean readPasswordField(Object[] objectArray) {
        boolean bl;
        PasswordGroup passwordGroup = null;
        String string = null;
        Object var4_4 = null;
        try {
            passwordGroup = (PasswordGroup)objectArray[10];
            string = (String)objectArray[2];
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || this.passwordGroupsRead.contains(passwordGroup)) {
            return true;
        }
        this.passwordGroups.add(passwordGroup);
        boolean bl2 = bl = !this.validating;
        if (!bl) {
            int n = passwordGroup.validatorSize();
            for (int i = 0; i < n; ++i) {
                bl = passwordGroup.validateContents(i);
                if (bl) continue;
                JOptionPane.showMessageDialog(this.parentFrame, passwordGroup.getValidatorMessage(i), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
                break;
            }
        }
        if (bl) {
            this.idata.setVariable(string, passwordGroup.getPassword());
            this.entries.add(new TextValuePair(string, passwordGroup.getPassword()));
        }
        return bl;
    }

    private void addCheckBox(XMLElement xMLElement) {
        Serializable serializable;
        Object object;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = xMLElement.getAttribute("variable");
        String string6 = null;
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        if (string5 == null) {
            return;
        }
        if (xMLElement2 != null) {
            string = this.getText(xMLElement2);
            string2 = xMLElement2.getAttribute(SET);
            string3 = xMLElement2.getAttribute(TRUE);
            string4 = xMLElement2.getAttribute(FALSE);
            string6 = xMLElement2.getAttribute(REVALIDATE);
            object = this.idata.getVariable(string5);
            Debug.trace("check: value: " + (String)object + ", set: " + string2);
            if (object != null && ((String)object).equals(string3)) {
                string2 = TRUE;
            }
        }
        object = new JCheckBox(string);
        if (string6 != null && string6.equals("yes")) {
            ((AbstractButton)object).addActionListener(this);
        }
        if (string2 != null) {
            if (string2 != null && !"".equals(string2)) {
                serializable = new VariableSubstitutor(this.idata.getVariables());
                string2 = ((VariableSubstitutor)serializable).substitute(string2, null);
            }
            if (string2.equals(FALSE)) {
                ((AbstractButton)object).setSelected(false);
            }
            if (string2.equals(TRUE)) {
                ((AbstractButton)object).setSelected(true);
            }
        }
        serializable = xMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription((XMLElement)serializable, vector, vector2);
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        twoColumnConstraints.indent = true;
        this.uiElements.add(new Object[]{null, CHECK_FIELD, string5, twoColumnConstraints, object, vector, vector2, string3, string4});
    }

    private boolean readCheckBox(Object[] objectArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        JCheckBox jCheckBox = null;
        try {
            jCheckBox = (JCheckBox)objectArray[4];
            string = (String)objectArray[2];
            string2 = (String)objectArray[7];
            if (string2 == null) {
                string2 = "";
            }
            if ((string3 = (String)objectArray[8]) == null) {
                string3 = "";
            }
        }
        catch (Throwable throwable) {
            Debug.trace("readCheckBox(): failed: " + throwable);
            return true;
        }
        if (jCheckBox.isSelected()) {
            Debug.trace("readCheckBox(): selected, setting " + string + " to " + string2);
            this.idata.setVariable(string, string2);
            this.entries.add(new TextValuePair(string, string2));
        } else {
            Debug.trace("readCheckBox(): not selected, setting " + string + " to " + string3);
            this.idata.setVariable(string, string3);
            this.entries.add(new TextValuePair(string, string3));
        }
        return true;
    }

    private void addSearch(XMLElement xMLElement) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        int n;
        Serializable serializable2;
        Object object4;
        Object object5;
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(SPEC);
        String string = xMLElement.getAttribute("variable");
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        int n3 = 0;
        JComboBox<String> jComboBox = new JComboBox<String>();
        JLabel jLabel = null;
        jComboBox.setEditable(true);
        if (xMLElement2 != null) {
            jLabel = new JLabel(this.getText(xMLElement2));
            n2 = 2;
            object5 = xMLElement2.getAttribute("type");
            if (object5 != null) {
                if (((String)object5).equals("file")) {
                    n2 = 2;
                } else if (((String)object5).equals(SEARCH_DIRECTORY)) {
                    n2 = 1;
                }
            }
            if ((object4 = xMLElement2.getAttribute(SEARCH_RESULT)) == null) {
                return;
            }
            if (((String)object4).equals("file")) {
                n3 = 2;
            } else if (((String)object4).equals(SEARCH_DIRECTORY)) {
                n3 = 1;
            } else if (((String)object4).equals(SEARCH_PARENTDIR)) {
                n3 = 3;
            } else {
                return;
            }
            string2 = xMLElement2.getAttribute(SEARCH_FILENAME);
            string3 = xMLElement2.getAttribute(SEARCH_CHECKFILENAME);
            serializable2 = xMLElement2.getChildrenNamed("choice");
            if (serializable2 == null) {
                return;
            }
            for (n = 0; n < ((Vector)serializable2).size(); n += 1) {
                serializable = ((Vector)serializable2).elementAt(n);
                if (!OsConstraint.oneMatchesCurrentSystem((XMLElement)serializable)) continue;
                object3 = ((XMLElement)serializable).getAttribute("value");
                jComboBox.addItem((String)object3);
                object2 = ((Vector)serializable2).elementAt(n).getAttribute(SET);
                if (object2 == null) continue;
                if (object2 != null && !"".equals(object2)) {
                    object = new VariableSubstitutor(this.idata.getVariables());
                    object2 = ((VariableSubstitutor)object).substitute((String)object2, null);
                }
                if (!((String)object2).equals(TRUE)) continue;
                jComboBox.setSelectedIndex(n);
            }
        } else {
            return;
        }
        xMLElement2 = xMLElement.getFirstChildNamed(DESCRIPTION);
        this.addDescription(xMLElement2, vector, vector2);
        object5 = new TwoColumnConstraints();
        ((TwoColumnConstraints)object5).position = 15;
        this.uiElements.add(new Object[]{null, FIELD_LABEL, null, object5, jLabel, vector, vector2});
        object4 = new TwoColumnConstraints();
        ((TwoColumnConstraints)object4).position = 26;
        serializable2 = new StringBuffer();
        if (string2 != null && string2.length() > 0) {
            ((StringBuffer)serializable2).append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location"), new Object[]{new String[]{string2}}));
        }
        int n4 = n = string3 != null && string3.length() > 0 ? 1 : 0;
        if (n) {
            ((StringBuffer)serializable2).append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location.checkedfile"), new Object[]{new String[]{string3}}));
        }
        if (((StringBuffer)serializable2).length() > 0) {
            jComboBox.setToolTipText(((StringBuffer)serializable2).toString());
        }
        this.uiElements.add(new Object[]{null, SEARCH_FIELD, string, object4, jComboBox, vector, vector2});
        serializable = new JPanel();
        ((Container)serializable).setLayout(new FlowLayout(3));
        object3 = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect"), this.idata.buttonsHColor);
        ((JComponent)object3).setVisible(n != 0);
        ((JComponent)object3).setToolTipText(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect.tooltip"));
        ((Container)serializable).add((Component)object3);
        object2 = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.browse"), this.idata.buttonsHColor);
        ((Container)serializable).add((Component)object2);
        object = new TwoColumnConstraints();
        ((TwoColumnConstraints)object).position = 27;
        this.uiElements.add(new Object[]{null, SEARCH_BUTTON_FIELD, null, object, serializable, vector, vector2});
        this.searchFields.add(new SearchField(string2, string3, this.parentFrame, jComboBox, (JButton)object3, (JButton)object2, n2, n3));
    }

    private boolean readSearch(Object[] objectArray) {
        String string = null;
        String string2 = null;
        JComboBox jComboBox = null;
        try {
            string = (String)objectArray[2];
            jComboBox = (JComboBox)objectArray[4];
            for (int i = 0; i < this.searchFields.size(); ++i) {
                SearchField searchField = this.searchFields.elementAt(i);
                if (!searchField.belongsTo(jComboBox)) continue;
                string2 = searchField.getResult();
                break;
            }
        }
        catch (Throwable throwable) {
            return true;
        }
        if (string == null || string2 == null) {
            return true;
        }
        this.idata.setVariable(string, string2);
        this.entries.add(new TextValuePair(string, string2));
        return true;
    }

    private void addText(XMLElement xMLElement) {
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        this.addDescription(xMLElement, vector, vector2);
    }

    private void addSpace(XMLElement xMLElement) {
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        JPanel jPanel = new JPanel();
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        this.uiElements.add(new Object[]{null, SPACE_FIELD, null, twoColumnConstraints, jPanel, vector, vector2});
    }

    private void addDivider(XMLElement xMLElement) {
        Vector<XMLElement> vector = xMLElement.getChildrenNamed(SELECTEDPACKS);
        Vector<XMLElement> vector2 = xMLElement.getChildrenNamed(OS);
        JPanel jPanel = new JPanel();
        String string = xMLElement.getAttribute(ALIGNMENT);
        if (string != null) {
            if (string.equals(TOP)) {
                jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            } else {
                jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            }
        } else {
            jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        }
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        this.uiElements.add(new Object[]{null, DIVIDER_FIELD, null, twoColumnConstraints, jPanel, vector, vector2});
    }

    private void addDescription(XMLElement xMLElement, Vector<XMLElement> vector, Vector<XMLElement> vector2) {
        String string;
        TwoColumnConstraints twoColumnConstraints = new TwoColumnConstraints();
        twoColumnConstraints.position = 29;
        twoColumnConstraints.stretch = true;
        if (xMLElement != null && (string = this.getText(xMLElement)) != null) {
            String string2 = xMLElement.getAttribute(ALIGNMENT);
            int n = 0;
            if (string2 != null) {
                if (string2.equals(LEFT)) {
                    n = 0;
                } else if (string2.equals(CENTER)) {
                    n = 1;
                } else if (string2.equals(RIGHT)) {
                    n = 2;
                }
            }
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            if (string.startsWith("<html>") && string.endsWith("</html>")) {
                jTextPane.setContentType("text/html");
            }
            jTextPane.setText(string);
            jTextPane.setBackground(UIManager.getColor("label.backgroud"));
            jTextPane.setMargin(new Insets(3, 0, 3, 0));
            jTextPane.getPreferredSize();
            this.uiElements.add(new Object[]{null, DESCRIPTION, null, twoColumnConstraints, jTextPane, vector, vector2});
        }
    }

    private boolean getBoolean(XMLElement xMLElement, String string, boolean bl) {
        String string2;
        boolean bl2 = bl;
        if (string != null && string.length() > 0 && (string2 = xMLElement.getAttribute(string)) != null) {
            if (string2.equals(TRUE)) {
                bl2 = true;
            } else if (string2.equals(FALSE)) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private float getFloat(XMLElement xMLElement, String string, float f) {
        float f2 = f;
        if (string != null && string.length() > 0) {
            try {
                f2 = Float.parseFloat(xMLElement.getAttribute(string));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return f2;
    }

    private String getText(XMLElement xMLElement) {
        if (xMLElement == null) {
            return null;
        }
        String string = xMLElement.getAttribute("id");
        String string2 = null;
        if (string != null && this.langpack != null) {
            try {
                string2 = this.langpack.getString(string);
            }
            catch (Throwable throwable) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = xMLElement.getAttribute(TEXT);
        }
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        return variableSubstitutor.substitute(string2, null);
    }

    private int getAlignment(XMLElement xMLElement) {
        int n = 31;
        String string = xMLElement.getAttribute(ALIGNMENT);
        if (string != null) {
            if (string.equals(LEFT)) {
                n = 31;
            } else if (string.equals(CENTER)) {
                n = 35;
            } else if (string.equals(RIGHT)) {
                n = 47;
            }
        }
        return n;
    }

    public boolean itemRequiredForOs(Vector<XMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).getAttribute(FAMILY);
            boolean bl = false;
            if ("windows".equals(string)) {
                bl = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(string)) {
                bl = OsVersion.IS_OSX;
            } else if ("unix".equals(string)) {
                bl = OsVersion.IS_UNIX;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean itemRequiredFor(Vector<XMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean itemRequiredForUnselected(Vector<XMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return false;
            }
        }
        return true;
    }

    protected Vector<Object[]> getUiElements() {
        return this.uiElements;
    }

    protected void updateVariables() {
        Vector<XMLElement> vector = this.spec.getChildrenNamed("variable");
        RulesEngine rulesEngine = this.parent.getRules();
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            XMLElement xMLElement = vector.elementAt(i);
            String string = xMLElement.getAttribute("name");
            String string2 = xMLElement.getAttribute("value");
            if (string2 == null && xMLElement.hasChildren()) {
                object = xMLElement.getFirstChildNamed("value");
                string2 = ((XMLElement)object).getContent();
            }
            if ((object = xMLElement.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !rulesEngine.isConditionTrue((String)object, this.idata.getVariables()) || !OsConstraint.oneMatchesCurrentSystem(xMLElement) || string == null) continue;
            if (string2 != null) {
                string2 = variableSubstitutor.substitute(string2, null);
                this.idata.setVariable(string, "");
                string2 = variableSubstitutor.substitute(string2, null);
            }
            this.idata.setVariable(string, string2);
            this.entries.add(new TextValuePair(string, string2));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.validating = false;
        this.readInput();
        this.panelActivate();
        this.validating = true;
    }

    private void showMessageDialog(InstallerFrame installerFrame, String string, String string2, int n) {
        String string3;
        String string4 = installerFrame.langpack.getString(string);
        if (string4 == null || string4.trim().length() == 0) {
            string4 = string;
        }
        if ((string3 = installerFrame.langpack.getString(string2)) == null || string3.trim().length() == 0) {
            string3 = string2;
        }
        JOptionPane.showMessageDialog(installerFrame, string4, string3, n);
    }

    private void showWarningMessageDialog(InstallerFrame installerFrame, String string) {
        this.showMessageDialog(installerFrame, string, "UserInputPanel.error.caption", 2);
    }

    private class SearchField
    implements ActionListener {
        public static final int TYPE_DIRECTORY = 1;
        public static final int TYPE_FILE = 2;
        public static final int RESULT_DIRECTORY = 1;
        public static final int RESULT_FILE = 2;
        public static final int RESULT_PARENTDIR = 3;
        private String filename = null;
        private String checkFilename = null;
        private JButton autodetectButton = null;
        private JButton browseButton = null;
        private JComboBox pathComboBox = null;
        private int searchType = 1;
        private int resultType = 1;
        private InstallerFrame parent = null;

        public SearchField(String string, String string2, InstallerFrame installerFrame, JComboBox jComboBox, JButton jButton, JButton jButton2, int n, int n2) {
            this.filename = string;
            this.checkFilename = string2;
            this.parent = installerFrame;
            this.autodetectButton = jButton;
            this.browseButton = jButton2;
            this.pathComboBox = jComboBox;
            this.searchType = n;
            this.resultType = n2;
            this.autodetectButton.addActionListener(this);
            this.browseButton.addActionListener(this);
            ((JTextField)this.pathComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.checkNextButtonState();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.checkNextButtonState();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.checkNextButtonState();
                }

                private void checkNextButtonState() {
                    Document document = ((JTextField)SearchField.this.pathComboBox.getEditor().getEditorComponent()).getDocument();
                    try {
                        if (SearchField.this.pathMatches(document.getText(0, document.getLength()))) {
                            SearchField.this.getInstallerFrame().unlockNextButton(false);
                        } else {
                            SearchField.this.getInstallerFrame().lockNextButton();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            this.autodetect();
        }

        private InstallerFrame getInstallerFrame() {
            return this.parent;
        }

        public boolean belongsTo(JComboBox jComboBox) {
            return this.pathComboBox == jComboBox;
        }

        private boolean pathMatches(String string) {
            if (string != null) {
                File file = null;
                file = this.filename == null || this.searchType == 1 ? new File(string) : new File(string, this.filename);
                if (file.exists() && (this.searchType == 1 && file.isDirectory() || this.searchType == 2 && file.isFile())) {
                    if (this.checkFilename == null) {
                        return true;
                    }
                    file = new File(file, this.checkFilename);
                    return file.exists();
                }
            }
            return false;
        }

        public boolean autodetect() {
            Object object;
            String string4;
            Vector<String> vector = new Vector<String>();
            String string2 = (String)this.pathComboBox.getSelectedItem();
            if (string2 == null) {
                this.parent.lockNextButton();
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                if (!this.pathComboBox.getItemAt(i).equals(string2)) continue;
                bl = true;
            }
            if (!bl) {
                this.pathComboBox.addItem(this.pathComboBox.getSelectedItem());
            }
            VariableSubstitutor variableSubstitutor = new VariableSubstitutor(UserInputPanel.this.idata.getVariables());
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                string4 = variableSubstitutor.substitute((String)this.pathComboBox.getItemAt(i), null);
                if (string4.endsWith("*")) {
                    File[] fileArray;
                    object = new File(string4 = string4.substring(0, string4.length() - 1));
                    if (!((File)object).isDirectory()) continue;
                    for (File file : fileArray = ((File)object).listFiles()) {
                        String string3 = file.getAbsolutePath();
                        if (!this.pathMatches(string3)) continue;
                        vector.add(string3);
                    }
                    continue;
                }
                if (!this.pathMatches(string4)) continue;
                vector.add(string4);
            }
            vector = new Vector(new HashSet(vector));
            this.pathComboBox.removeAllItems();
            for (String string4 : vector) {
                object = variableSubstitutor.substitute(string4, "plain");
                this.pathComboBox.addItem(object);
            }
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                string4 = (String)this.pathComboBox.getItemAt(i);
                if (!this.pathMatches(string4)) continue;
                this.pathComboBox.setSelectedIndex(i);
                this.parent.unlockNextButton();
                return true;
            }
            if (this.pathMatches((String)this.pathComboBox.getSelectedItem())) {
                this.parent.unlockNextButton();
                return true;
            }
            this.parent.lockNextButton();
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.autodetectButton) {
                if (!this.autodetect()) {
                    UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.autodetect.failed.message", "UserInputPanel.search.autodetect.failed.caption", 2);
                }
            } else if (actionEvent.getSource() == this.browseButton) {
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                if (this.resultType != 2) {
                    jFileChooser.setFileSelectionMode(1);
                }
                if ((n = jFileChooser.showOpenDialog(this.parent)) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    this.pathComboBox.setSelectedItem(file.getAbsolutePath());
                    if (this.resultType != 2 && !this.pathMatches(file.getAbsolutePath())) {
                        UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.wrongselection.message", "UserInputPanel.search.wrongselection.caption", 2);
                    }
                }
            }
        }

        public String getResult() {
            String string = (String)this.pathComboBox.getSelectedItem();
            if (string != null) {
                string = string.trim();
            }
            String string2 = string;
            File file = new File(string);
            if (!file.isDirectory()) {
                string2 = file.getParent();
            }
            if (this.resultType == 1) {
                return string2;
            }
            if (this.resultType == 2) {
                if (this.filename != null) {
                    return string2 + File.separatorChar + this.filename;
                }
                return string;
            }
            if (this.resultType == 3) {
                File file2 = new File(string2);
                return file2.getParent();
            }
            return null;
        }
    }

    private static class TextValuePair {
        private String text = "";
        private String value = "";

        public TextValuePair(String string, String string2) {
            this.text = string;
            this.value = string2;
        }

        public void setText(String string) {
            this.text = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String toString() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }
    }
}

