/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jms;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.jms.JmsConnectorService;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.util.JndiUtil;

public class JmsConnectorServiceFactory
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    private String connectionFactoryJndiName = "java:comp/env/jms/JbpmConnectionFactory";
    private String destinationJndiName = "java:comp/env/jms/JobQueue";
    private JbpmConfiguration jbpmConfiguration;
    private ConnectionFactory connectionFactory;
    private Destination destination;

    public void setConnectionFactoryJndiName(String connectionFactoryJndiName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
    }

    public void setDestinationJndiName(String destinationJndiName) {
        this.destinationJndiName = destinationJndiName;
    }

    public synchronized ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = (ConnectionFactory)JndiUtil.lookup((String)this.connectionFactoryJndiName, ConnectionFactory.class);
        }
        return this.connectionFactory;
    }

    public synchronized Destination getDestination() {
        if (this.destination == null) {
            this.destination = (Destination)JndiUtil.lookup((String)this.destinationJndiName, Destination.class);
        }
        return this.destination;
    }

    public JbpmConfiguration getJbpmConfiguration() {
        if (this.jbpmConfiguration == null) {
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            if (jbpmContext == null) {
                throw new JbpmException("no active jbpm context");
            }
            this.jbpmConfiguration = jbpmContext.getJbpmConfiguration();
        }
        return this.jbpmConfiguration;
    }

    public Service openService() {
        try {
            return new JmsConnectorService(this);
        }
        catch (JMSException e) {
            throw new JbpmException("could not open message service", (Throwable)e);
        }
    }

    public void close() {
        this.connectionFactory = null;
        this.destination = null;
    }
}

