/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jms.JmsConnectorServiceFactory;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.msg.MessageService;
import org.jbpm.scheduler.SchedulerService;

public class JmsConnectorService
implements MessageService,
SchedulerService {
    private final JmsConnectorServiceFactory serviceFactory;
    private final Connection connection;
    private static final String SCHEDULED_DELIVERY_PROP = "JMS_JBOSS_SCHEDULED_DELIVERY";
    private static final String GROUP_ID_PROP = "JMSXGroupID";
    private static final String GROUP_PREFIX = "jBPMPID";
    private static final long serialVersionUID = 2L;
    private static final Log log = LogFactory.getLog(JmsConnectorService.class);

    JmsConnectorService(JmsConnectorServiceFactory serviceFactory) throws JMSException {
        this.connection = serviceFactory.getConnectionFactory().createConnection();
        this.serviceFactory = serviceFactory;
    }

    private JobSession getJobSession() {
        return this.serviceFactory.getJbpmConfiguration().getCurrentJbpmContext().getJobSession();
    }

    public void send(Job job) {
        this.getJobSession().saveJob(job);
        try {
            this.sendMessage(job);
        }
        catch (JMSException e) {
            throw new JbpmException("failed to send job message", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendMessage(Job job) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        try {
            Message message = session.createMessage();
            this.populateMessage(message, job);
            MessageProducer messageProducer = session.createProducer(this.serviceFactory.getDestination());
            messageProducer.send(message);
        }
        finally {
            session.close();
        }
    }

    protected void populateMessage(Message message, Job job) throws JMSException {
        message.setLongProperty("jobId", job.getId());
        if (job instanceof Timer) {
            Timer timer = (Timer)job;
            if (log.isDebugEnabled()) {
                log.debug((Object)("scheduling " + timer + " to execute at " + timer.getDueDate()));
            }
            message.setLongProperty(SCHEDULED_DELIVERY_PROP, timer.getDueDate().getTime());
            message.setJMSPriority(9);
        }
        if (job.isExclusive()) {
            message.setStringProperty(GROUP_ID_PROP, GROUP_PREFIX + job.getProcessInstance().getId());
        }
    }

    public void createTimer(Timer timer) {
        this.send((Job)timer);
    }

    public void deleteTimer(Timer timer) {
        this.getJobSession().deleteJob((Job)timer);
    }

    public void deleteTimersByName(String timerName, Token token) {
        this.getJobSession().deleteTimersByName(timerName, token);
    }

    public void deleteTimersByProcessInstance(ProcessInstance processInstance) {
        this.getJobSession().deleteJobsForProcessInstance(processInstance);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (JMSException e) {
            throw new JbpmException("failed to close jms connection", (Throwable)e);
        }
    }
}

