/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.sql.DataSource;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.ejb.LocalCommandService;

@Stateless
@Resources(value={@Resource(name="jdbc/JbpmDataSource", type=DataSource.class, shareable=true), @Resource(name="jms/JbpmConnectionFactory", type=ConnectionFactory.class, shareable=true), @Resource(name="jms/JobQueue", type=Queue.class)})
public class CommandServiceBean
implements LocalCommandService {
    private static final long serialVersionUID = 1L;
    @Resource
    private SessionContext sessionContext;
    @Resource(name="JbpmCfgResource")
    private String jbpmCfgResource;
    private JbpmConfiguration jbpmConfiguration;

    @PostConstruct
    void createConfiguration() {
        this.jbpmConfiguration = JbpmConfiguration.getInstance((String)this.jbpmCfgResource);
    }

    public Object execute(Command command) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            Object result = command.execute(jbpmContext);
            if (jbpmContext.getServices().getTxService().isRollbackOnly()) {
                this.sessionContext.setRollbackOnly();
            }
            Object object = result;
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JbpmException("failed to execute " + command, (Throwable)e);
        }
        finally {
            jbpmContext.close();
        }
    }
}

