/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ejb;

import java.io.Serializable;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.command.Command;
import org.jbpm.ejb.LocalCommandService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class CommandListenerBean
implements MessageListener {
    private static final long serialVersionUID = 1L;
    @Resource
    private MessageDrivenContext messageDrivenContext;
    @EJB(name="ejb/LocalCommandService")
    private LocalCommandService commandService;
    @Resource(name="jms/JbpmConnectionFactory", shareable=true)
    private ConnectionFactory jmsConnectionFactory;
    private static final Log log = LogFactory.getLog(CommandListenerBean.class);

    public void onMessage(Message message) {
        try {
            Destination replyTo;
            Object result;
            Command command = this.extractCommand(message);
            if (command == null) {
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("executing " + command));
                }
                result = this.commandService.execute(command);
                if (log.isTraceEnabled()) {
                    log.trace((Object)(command + " completed successfully, committing"));
                }
            }
            catch (RuntimeException e) {
                if (DbPersistenceService.isLockingException((Exception)e)) {
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)(message + " failed to execute " + command), (Throwable)e);
                } else {
                    log.error((Object)(message + " failed to execute " + command), (Throwable)e);
                }
                this.messageDrivenContext.setRollbackOnly();
                return;
            }
            if (this.jmsConnectionFactory != null && (replyTo = message.getJMSReplyTo()) != null && (result instanceof Serializable || result == null)) {
                this.sendResult((Serializable)result, replyTo, message.getJMSMessageID());
            }
        }
        catch (JMSException e) {
            this.messageDrivenContext.setRollbackOnly();
            log.error((Object)("failed to process message " + message), (Throwable)e);
        }
    }

    protected Command extractCommand(Message message) throws JMSException {
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable object = objectMessage.getObject();
            if (object instanceof Command) {
                return (Command)object;
            }
            log.warn((Object)(object + " is not a command"));
        } else {
            log.warn((Object)(message + " is not an object message"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResult(Serializable result, Destination destination, String correlationId) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("sending " + result + " to " + destination));
        }
        Connection jmsConnection = this.jmsConnectionFactory.createConnection();
        try {
            Session jmsSession = jmsConnection.createSession(false, 1);
            ObjectMessage resultMessage = jmsSession.createObjectMessage(result);
            resultMessage.setJMSCorrelationID(correlationId);
            MessageProducer producer = jmsSession.createProducer(destination);
            producer.send((Message)resultMessage);
        }
        finally {
            try {
                jmsConnection.close();
            }
            catch (JMSException e) {
                log.warn((Object)"failed to close jms connection", (Throwable)e);
            }
        }
    }
}

