/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.jms.JmsConnectorService;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;

public class ExecuteJobCommand
implements Command {
    private final long jobId;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ExecuteJobCommand.class);

    public ExecuteJobCommand(long jobId) {
        this.jobId = jobId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        Job job = ExecuteJobCommand.acquireJob(this.jobId, jbpmContext);
        if (job != null) {
            ExecuteJobCommand.executeJob(job, jbpmContext);
        }
        return job;
    }

    private static Job acquireJob(long jobId, JbpmContext jbpmContext) {
        Job job;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("acquiring job: " + jobId));
        }
        if ((job = jbpmContext.getJobSession().getJob(jobId)) != null) {
            ProcessInstance processInstance = job.getProcessInstance();
            jbpmContext.addAutoSaveProcessInstance(processInstance);
            if (job.isExclusive()) {
                jbpmContext.getGraphSession().lockProcessInstance(processInstance);
            }
            job.setLockOwner(Thread.currentThread().getName());
            if (debug) {
                log.debug((Object)("acquired " + job));
            }
        } else {
            log.warn((Object)("job not found: " + jobId));
        }
        return job;
    }

    private static void executeJob(Job job, JbpmContext jbpmContext) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executing " + job));
        }
        if (job.execute(jbpmContext)) {
            jbpmContext.getJobSession().deleteJob(job);
        } else {
            Timer timer = jbpmContext.getJobSession().loadTimer(job.getId());
            JmsConnectorService schedulerService = (JmsConnectorService)jbpmContext.getServices().getSchedulerService();
            schedulerService.sendMessage((Job)timer);
        }
    }

    public String toString() {
        return "ExecuteJobCommand(" + this.jobId + ")";
    }
}

