/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.model;

//$Id: FlowObjectImpl.java 2018 2008-08-26 15:23:39Z thomas.diesler@jboss.com $

import java.util.List;

import javax.management.ObjectName;

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.Assignment;
import org.jboss.bpm.model.FlowObject;
import org.jboss.bpm.model.ObjectNameFactory;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.SequenceFlow;
import org.jboss.util.id.UID;
import org.jbpm.graph.def.Node;

/**
 * A Flow Object is one of the set of following graphical objects: Event, Activity, and Gateway.
 * 
 * @author thomas.diesler@jboss.com
 * @since 26-Aug-2008
 */
@SuppressWarnings("serial")
public class FlowObjectImpl extends AbstractElementImpl implements FlowObject
{
  private Process proc;
  private Node jbpmNode;
  private SequenceFlow outFlow;
  
  public FlowObjectImpl(Process proc, Node jbpmNode)
  {
    this.proc = proc;
    this.jbpmNode = jbpmNode;
    
    NodeWrapper nodeWrapper = (NodeWrapper)jbpmNode;
    nodeWrapper.setFlowObject(this);
  }

  public Node getNode()
  {
    return jbpmNode;
  }

  public Process getProcess()
  {
    return proc;
  }
  
  public ObjectName getID()
  {
    if (id == null)
    {
      StringBuilder str = new StringBuilder("org.jbpm:");
      str.append("type=Other,name=" + getName() + ",id=" + new UID());
      id = ObjectNameFactory.create(str.toString());
    }
    return id;
  }
  
  public String getName()
  {
    return jbpmNode.getName();
  }
  
  public SequenceFlow getOutFlow()
  {
    return outFlow;
  }

  public void setOutFlow(SequenceFlow outFlow)
  {
    this.outFlow = outFlow;
  }

  public List<Assignment> getAssignments()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }
}