/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.integration.model;

//$Id: ProcessBuilderImpl.java 2018 2008-08-26 15:23:39Z thomas.diesler@jboss.com $

import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.model.EventBuilder;
import org.jboss.bpm.model.GatewayBuilder;
import org.jboss.bpm.model.MessageBuilder;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.ProcessBuilder;
import org.jboss.bpm.model.TaskBuilder;
import org.jboss.bpm.model.Assignment.AssignTime;
import org.jboss.bpm.model.Expression.ExpressionLanguage;
import org.jboss.bpm.model.Gateway.GatewayType;
import org.jboss.bpm.model.Task.TaskType;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;

/**
 * The ProcessBuilder can be used to dynamically build a {@link Process}.
 * 
 * @author thomas.diesler@jboss.com
 * @since 26-Aug-2008
 */
public class ProcessBuilderImpl implements ProcessBuilder
{
  protected ProcessImpl proc;
  protected FlowObjectImpl flowObject;

  public ProcessBuilderImpl()
  {
  }

  public ProcessBuilderImpl(ProcessImpl proc, FlowObjectImpl flowObject)
  {
    this.proc = proc;
    this.flowObject = flowObject;
  }

  public ProcessBuilder addProcess(String name)
  {
    ProcessDefinition jbpmProc = new ProcessDefinition(name);
    proc = new ProcessImpl(jbpmProc);
    return this;
  }
  
  public EventBuilder addStartEvent(String name)
  {
    Node jbpmNode = new StartStateWrapper(name);
    flowObject = new FlowObjectImpl(proc, jbpmNode);
    proc.addFlowObject(flowObject);
    ProcessDefinition jbpmProc = proc.getProcessDefinition();
    jbpmProc.setStartState(jbpmNode);
    return new EventBuilderImpl(proc, flowObject);
  }

  public EventBuilder addEndEvent(String name)
  {
    Node jbpmNode = new EndStateWrapper(name);
    flowObject = new FlowObjectImpl(proc, jbpmNode);
    proc.addFlowObject(flowObject);
    return new EventBuilderImpl(proc, flowObject);
  }

  public TaskBuilder addTask(String name)
  {
    Node jbpmNode = new StateWrapper(name);
    flowObject = new FlowObjectImpl(proc, jbpmNode);
    proc.addFlowObject(flowObject);
    return new TaskBuilderImpl(proc, flowObject);
  }

  public ProcessBuilder addSequenceFlow(String targetName)
  {
    Node jbpmNode = flowObject.getNode();
    Transition jbpmTransition = new Transition(targetName);
    jbpmTransition.setFrom(jbpmNode);
    jbpmNode.addLeavingTransition(jbpmTransition);
    flowObject.setOutFlow(new SequenceFlowImpl(jbpmTransition));
    return this;
  }

  public Process getProcess()
  {
    proc.initialize();
    return proc;
  }

  public ProcessBuilder addAssignment(AssignTime time, ExpressionLanguage lang, String fromExpr, String toProp)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public EventBuilder addEvent(String name)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ProcessBuilder addExecutionHandler(Class<?> clazz)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ProcessBuilder addFlowHandler(Class<?> clazz)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public GatewayBuilder addGateway(String name, GatewayType type)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public MessageBuilder addMessage(String name)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ProcessBuilder addMessageFlow(String targetName)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ProcessBuilder addProcess(Process proc)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ProcessBuilder addProperty(String name, String value)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public ProcessBuilder addSignalHandler(Class<?> clazz)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public TaskBuilder addTask(String name, TaskType type)
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }

  public Process getProcessForInclude()
  {
    throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
  }
}