/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.NotImplementedException;
import org.jboss.bpm.client.ExecutionManager;
import org.jboss.bpm.client.SignalManager;
import org.jboss.bpm.model.Process;
import org.jboss.bpm.model.Signal;
import org.jboss.bpm.model.StartEvent;
import org.jboss.bpm.runtime.Attachments;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Execution;
import org.jbpm.integration.model.ProcessImpl;

public class ExecutionManagerImpl
extends ExecutionManager {
    private static final Log log = LogFactory.getLog(ExecutionManagerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(Process proc, Attachments att) {
        ProcessImpl procImpl = (ProcessImpl)proc;
        procImpl.setProcessStatus(Process.ProcessStatus.Active);
        ProcessDefinition jbpmProc = procImpl.getProcessDefinition();
        SignalManager sigManager = SignalManager.locateSignalManager();
        sigManager.throwSignal(new Signal(proc.getID(), Signal.SignalType.SYSTEM_PROCESS_ENTER));
        try {
            Execution jbpmEx = new Execution(jbpmProc);
            while (!jbpmEx.hasEnded()) {
                jbpmEx.signal();
            }
        }
        finally {
            sigManager.throwSignal(new Signal(proc.getID(), Signal.SignalType.SYSTEM_PROCESS_EXIT));
        }
        procImpl.setProcessStatus(Process.ProcessStatus.Completed);
    }

    public Process.ProcessStatus waitForEnd(Process proc) {
        return proc.getProcessStatus();
    }

    public Process.ProcessStatus waitForEnd(Process proc, long timeout) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }

    public void startProcess(StartEvent start, Attachments att) {
        throw new NotImplementedException("JBPM-1705", "jBPM3 implementation of the API");
    }
}

